/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.fov.ui.jme3.scene_objects;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.apogy.addons.sensors.fov.ConicalFieldOfView;
import org.eclipse.apogy.addons.sensors.fov.DistanceRange;
import org.eclipse.apogy.addons.sensors.fov.ui.jme3.scene_objects.AbstractFieldOfViewJME3Object;
import org.eclipse.apogy.addons.sensors.fov.ui.jme3.utils.AbstractFieldOfViewImageProjectorControl;
import org.eclipse.apogy.addons.sensors.fov.ui.jme3.utils.ConicalFieldOfViewImageProjectorControl;
import org.eclipse.apogy.addons.sensors.fov.ui.jme3.utils.JME3FovUtilities;
import org.eclipse.apogy.addons.sensors.fov.ui.scene_objects.ConicalFieldOfViewSceneObject;
import org.eclipse.apogy.common.topology.addons.primitives.ui.jme3.JME3PrimitivesUtilities;
import org.eclipse.apogy.common.topology.ui.MeshPresentationMode;
import org.eclipse.apogy.common.topology.ui.jme3.JME3RenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.swt.graphics.RGB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConicalFieldOfViewJME3Object
extends AbstractFieldOfViewJME3Object<ConicalFieldOfView>
implements ConicalFieldOfViewSceneObject {
    private static final Logger Logger = LoggerFactory.getLogger(ConicalFieldOfViewJME3Object.class);
    private float previousAxisLength = 1.0f;
    private boolean axisVisible = true;
    public static float DEFAULT_ANGLE_INCREMENT = (float)Math.toRadians(10.0);
    private Adapter adapter;
    private final AssetManager assetManager;
    private Geometry frontHemisphereGeometry = null;
    private Geometry rearHemisphereGeometry = null;
    private Geometry truncatedConeGeometry = null;
    private Geometry axisGeometry = null;
    private ConicalFieldOfViewImageProjectorControl conicalFieldOfViewImageProjectorControl;

    public ConicalFieldOfViewJME3Object(ConicalFieldOfView node, JME3RenderEngineDelegate jme3RenderEngineDelegate) {
        super(node, jme3RenderEngineDelegate);
        if (node == null || jme3RenderEngineDelegate == null) {
            throw new IllegalArgumentException();
        }
        this.assetManager = this.jme3Application.getAssetManager();
        this.axisGeometry = JME3Utilities.createAxis3D((float)1.0f, (AssetManager)this.assetManager);
        this.requestUpdate();
        node.eAdapters().add((Object)this.getAdapter());
        node.getRange().eAdapters().add((Object)this.getAdapter());
    }

    public void updateGeometry(float tpf) {
        if (this.truncatedConeGeometry != null) {
            this.getFovNode().detachChild((Spatial)this.truncatedConeGeometry);
        }
        if (this.frontHemisphereGeometry != null) {
            this.getFovNode().detachChild((Spatial)this.frontHemisphereGeometry);
        }
        if (this.rearHemisphereGeometry != null) {
            this.getFovNode().detachChild((Spatial)this.rearHemisphereGeometry);
        }
        float apexAngle = (float)((ConicalFieldOfView)this.getTopologyNode()).getFieldOfViewAngle();
        float minRadius = (float)((ConicalFieldOfView)this.getTopologyNode()).getRange().getMinimumDistance();
        float maxRadius = (float)((ConicalFieldOfView)this.getTopologyNode()).getRange().getMaximumDistance();
        Mesh truncatedConeMesh = JME3FovUtilities.createTruncatedCone(apexAngle, minRadius, maxRadius, 36);
        this.truncatedConeGeometry = new Geometry("Sides", truncatedConeMesh);
        this.truncatedConeGeometry.setMaterial(this.createMaterial());
        Mesh frontHemisphereMesh = JME3PrimitivesUtilities.createSphericalCap((float)maxRadius, (float)((float)(Math.toRadians(90.0) - (double)apexAngle / 2.0)), (float)((float)Math.toRadians(90.0)), (int)36);
        this.frontHemisphereGeometry = new Geometry("Front", frontHemisphereMesh);
        this.frontHemisphereGeometry.setMaterial(this.createMaterial());
        Mesh rearHemisphereMesh = JME3PrimitivesUtilities.createSphericalCap((float)minRadius, (float)((float)(Math.toRadians(90.0) - (double)apexAngle / 2.0)), (float)((float)Math.toRadians(90.0)), (int)36);
        this.rearHemisphereGeometry = new Geometry("Rear", rearHemisphereMesh);
        this.rearHemisphereGeometry.setMaterial(this.createMaterial());
        this.getFovNode().attachChild((Spatial)this.truncatedConeGeometry);
        this.getFovNode().attachChild((Spatial)this.frontHemisphereGeometry);
        this.getFovNode().attachChild((Spatial)this.rearHemisphereGeometry);
        this.internalSetPresentationMode(this.meshPresentationMode);
        this.getAttachmentNode().addControl((Control)this.getConicalFieldOfViewImageProjectorControl());
    }

    public void dispose() {
        if (this.getTopologyNode() != null) {
            ((ConicalFieldOfView)this.getTopologyNode()).eAdapters().remove((Object)this.getAdapter());
            if (((ConicalFieldOfView)this.getTopologyNode()).getRange() != null) {
                ((ConicalFieldOfView)this.getTopologyNode()).getRange().eAdapters().remove((Object)this.getAdapter());
            }
        }
        if (this.conicalFieldOfViewImageProjectorControl != null) {
            this.conicalFieldOfViewImageProjectorControl.dispose();
            this.conicalFieldOfViewImageProjectorControl = null;
        }
        super.dispose();
    }

    public List<Geometry> getGeometries() {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        geometries.add(this.frontHemisphereGeometry);
        geometries.add(this.rearHemisphereGeometry);
        geometries.add(this.truncatedConeGeometry);
        if (this.axisGeometry != null) {
            geometries.add(this.axisGeometry);
        }
        return geometries;
    }

    @Override
    public void setColor(final RGB rgb) {
        Logger.info("Set Color <" + rgb + ")");
        super.setColor(rgb);
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    Material mat;
                    if (ConicalFieldOfViewJME3Object.this.frontHemisphereGeometry != null) {
                        mat = ConicalFieldOfViewJME3Object.this.createMaterial();
                        mat.setColor("Diffuse", ConicalFieldOfViewJME3Object.this.fovColor.clone());
                        mat.setColor("Ambient", ConicalFieldOfViewJME3Object.this.fovColor.clone());
                        mat.setColor("Specular", ConicalFieldOfViewJME3Object.this.fovColor.clone());
                        ConicalFieldOfViewJME3Object.this.frontHemisphereGeometry.setMaterial(mat);
                    }
                    if (ConicalFieldOfViewJME3Object.this.rearHemisphereGeometry != null) {
                        mat = ConicalFieldOfViewJME3Object.this.createMaterial();
                        mat.setColor("Diffuse", ConicalFieldOfViewJME3Object.this.fovColor.clone());
                        mat.setColor("Ambient", ConicalFieldOfViewJME3Object.this.fovColor.clone());
                        mat.setColor("Specular", ConicalFieldOfViewJME3Object.this.fovColor.clone());
                        ConicalFieldOfViewJME3Object.this.rearHemisphereGeometry.setMaterial(mat);
                    }
                    if (ConicalFieldOfViewJME3Object.this.truncatedConeGeometry != null) {
                        mat = ConicalFieldOfViewJME3Object.this.createMaterial();
                        mat.setColor("Diffuse", ConicalFieldOfViewJME3Object.this.fovColor.clone());
                        mat.setColor("Ambient", ConicalFieldOfViewJME3Object.this.fovColor.clone());
                        mat.setColor("Specular", ConicalFieldOfViewJME3Object.this.fovColor.clone());
                        ConicalFieldOfViewJME3Object.this.truncatedConeGeometry.setMaterial(mat);
                    }
                }
                catch (Throwable t) {
                    Logger.error("Failed to set color to <" + rgb + ">.", t);
                }
                return null;
            }
        });
    }

    public void setShowProjection(final boolean showProjection) {
        Logger.info("setShowProjection(" + showProjection + ")");
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ConicalFieldOfViewJME3Object.this.getConicalFieldOfViewImageProjectorControl().setEnabled(showProjection);
                return null;
            }
        });
        this.showProjection = showProjection;
    }

    public void setShowOutlineOnly(boolean showOutlineOnly) {
    }

    public void setPresentationMode(final MeshPresentationMode mode) {
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ConicalFieldOfViewJME3Object.this.internalSetPresentationMode(mode);
                return null;
            }
        });
    }

    @Override
    public AbstractFieldOfViewImageProjectorControl<ConicalFieldOfView> getAbstractFieldOfViewImageProjectorControl() {
        return this.getConicalFieldOfViewImageProjectorControl();
    }

    public void setAxisVisible(boolean visible) {
        Logger.info("Setting axis visible to <" + visible + ">.");
        this.axisVisible = visible;
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (ConicalFieldOfViewJME3Object.this.axisVisible) {
                    ConicalFieldOfViewJME3Object.this.getAttachmentNode().attachChild((Spatial)ConicalFieldOfViewJME3Object.this.axisGeometry);
                } else {
                    ConicalFieldOfViewJME3Object.this.getAttachmentNode().detachChild((Spatial)ConicalFieldOfViewJME3Object.this.axisGeometry);
                }
                return null;
            }
        });
    }

    public void setAxisLength(final double length) {
        Logger.info("Setting axis length to <" + length + ">.");
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    float scale = (float)Math.abs(length) / ConicalFieldOfViewJME3Object.this.previousAxisLength;
                    if (ConicalFieldOfViewJME3Object.this.axisGeometry != null) {
                        ConicalFieldOfViewJME3Object.this.axisGeometry.scale(scale);
                    }
                    ConicalFieldOfViewJME3Object.this.previousAxisLength = (float)length;
                }
                catch (Throwable t) {
                    Logger.error("Failed to setAxisLength(" + length + ").", t);
                }
                return null;
            }
        });
    }

    private void internalSetPresentationMode(MeshPresentationMode mode) {
        switch (mode.getValue()) {
            case 1: {
                if (this.truncatedConeGeometry != null) {
                    this.truncatedConeGeometry.getMaterial().getAdditionalRenderState().setWireframe(false);
                    this.truncatedConeGeometry.getMesh().setMode(Mesh.Mode.Triangles);
                }
                if (this.rearHemisphereGeometry != null) {
                    this.rearHemisphereGeometry.getMaterial().getAdditionalRenderState().setWireframe(false);
                    this.rearHemisphereGeometry.getMesh().setMode(Mesh.Mode.Triangles);
                }
                if (this.frontHemisphereGeometry == null) break;
                this.frontHemisphereGeometry.getMaterial().getAdditionalRenderState().setWireframe(false);
                this.frontHemisphereGeometry.getMesh().setMode(Mesh.Mode.Triangles);
                break;
            }
            case 2: {
                if (this.truncatedConeGeometry != null) {
                    this.truncatedConeGeometry.getMaterial().getAdditionalRenderState().setWireframe(true);
                    this.truncatedConeGeometry.getMesh().setMode(Mesh.Mode.Triangles);
                }
                if (this.rearHemisphereGeometry != null) {
                    this.rearHemisphereGeometry.getMaterial().getAdditionalRenderState().setWireframe(true);
                    this.rearHemisphereGeometry.getMesh().setMode(Mesh.Mode.Triangles);
                }
                if (this.frontHemisphereGeometry == null) break;
                this.frontHemisphereGeometry.getMaterial().getAdditionalRenderState().setWireframe(true);
                this.frontHemisphereGeometry.getMesh().setMode(Mesh.Mode.Triangles);
                break;
            }
            case 0: {
                if (this.truncatedConeGeometry != null) {
                    this.truncatedConeGeometry.getMaterial().getAdditionalRenderState().setWireframe(false);
                    this.truncatedConeGeometry.getMesh().setMode(Mesh.Mode.Points);
                }
                if (this.rearHemisphereGeometry != null) {
                    this.rearHemisphereGeometry.getMaterial().getAdditionalRenderState().setWireframe(false);
                    this.rearHemisphereGeometry.getMesh().setMode(Mesh.Mode.Points);
                }
                if (this.frontHemisphereGeometry == null) break;
                this.frontHemisphereGeometry.getMaterial().getAdditionalRenderState().setWireframe(false);
                this.frontHemisphereGeometry.getMesh().setMode(Mesh.Mode.Points);
                break;
            }
        }
    }

    private Material createMaterial() {
        Material mat = new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
        if (this.fovColor != null) {
            mat.setColor("Diffuse", this.fovColor.clone());
            mat.setColor("Ambient", this.fovColor.clone());
            mat.setColor("Specular", this.fovColor.clone());
        }
        mat.setFloat("Shininess", 64.0f);
        mat.setBoolean("UseMaterialColors", true);
        mat.getAdditionalRenderState().setFaceCullMode(RenderState.FaceCullMode.Off);
        return mat;
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification notification) {
                    try {
                        if (notification.getNotifier() instanceof ConicalFieldOfView) {
                            int featureId = notification.getFeatureID(ConicalFieldOfView.class);
                            switch (featureId) {
                                case 4: {
                                    ConicalFieldOfViewJME3Object.this.requestUpdate();
                                    ConicalFieldOfViewJME3Object.this.getConicalFieldOfViewImageProjectorControl().updateProjectorFOVSettings();
                                    break;
                                }
                                case 3: {
                                    if (notification.getOldValue() instanceof DistanceRange) {
                                        DistanceRange oldValue = (DistanceRange)notification.getOldValue();
                                        oldValue.eAdapters().remove((Object)ConicalFieldOfViewJME3Object.this.getAdapter());
                                    }
                                    if (notification.getNewValue() instanceof DistanceRange) {
                                        DistanceRange newValue = (DistanceRange)notification.getNewValue();
                                        newValue.eAdapters().add((Object)ConicalFieldOfViewJME3Object.this.getAdapter());
                                    }
                                    ConicalFieldOfViewJME3Object.this.requestUpdate();
                                }
                            }
                        } else if (notification.getNotifier() instanceof DistanceRange) {
                            int featureId = notification.getFeatureID(DistanceRange.class);
                            switch (featureId) {
                                case 0: 
                                case 1: {
                                    ConicalFieldOfViewJME3Object.this.requestUpdate();
                                    break;
                                }
                                default: {
                                    break;
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        Logger.error("Error during update of ConicalFieldOfView geometry.", (Throwable)e);
                    }
                }
            };
        }
        return this.adapter;
    }

    private ConicalFieldOfViewImageProjectorControl getConicalFieldOfViewImageProjectorControl() {
        if (this.conicalFieldOfViewImageProjectorControl == null) {
            this.conicalFieldOfViewImageProjectorControl = new ConicalFieldOfViewImageProjectorControl(this.jme3Application, (ConicalFieldOfView)this.getTopologyNode());
        }
        return this.conicalFieldOfViewImageProjectorControl;
    }
}

