/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.parts;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.apogy.common.ui.composites.NoContentComposite;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.PersistState;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MSnippetContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractPart {
    private Composite parentComposite;
    @Inject
    protected MPart mPart;
    protected String perspectiveID;
    @Inject
    protected ESelectionService selectionService;
    @Inject
    protected EModelService modelService;
    @Inject
    protected MApplication application;

    @PostConstruct
    public void createPartControl(Composite parent, @Optional MPerspective perspective) {
        this.userPostConstruct(this.mPart);
        if (perspective != null) {
            this.perspectiveID = perspective.getElementId();
        }
        this.parentComposite = parent;
        this.parentComposite.setLayout((Layout)new FillLayout());
        this.setNoContentComposite();
        this.parentComposite.layout();
        this.setEObject(this.getInitializeObject());
        this.reloadToolBarAndMenus();
    }

    @PostConstruct
    public void postConstruct(Composite parent) {
    }

    @PreDestroy
    public void preDestroy() {
        this.userPreDestroy(this.mPart);
    }

    @PersistState
    public void persist() {
        this.userPersistState(this.mPart);
    }

    public void userPostConstruct(MPart mPart) {
    }

    public void userPreDestroy(MPart mPart) {
    }

    public void userPersistState(MPart mPart) {
    }

    public void reloadToolBarAndMenus() {
        MPart partCopy;
        MPerspective perspectiveCopy = (MPerspective)this.modelService.cloneSnippet((MSnippetContainer)this.application, this.perspectiveID, (MWindow)this.modelService.find("org.eclipse.apogy.rcp.window.main", (MUIElement)this.application));
        if (perspectiveCopy != null && (partCopy = (MPart)this.modelService.find(this.mPart.getElementId(), (MUIElement)perspectiveCopy)) != null) {
            if (this.mPart.getMenus() != null) {
                this.mPart.getMenus().clear();
                if (partCopy.getMenus() != null) {
                    this.mPart.getMenus().addAll(partCopy.getMenus());
                }
            }
            if (this.mPart.getToolbar() != null && this.mPart.getToolbar().getChildren() != null) {
                this.mPart.getToolbar().getChildren().clear();
                if (partCopy.getToolbar() != null && partCopy.getToolbar().getChildren() != null) {
                    this.mPart.getToolbar().getChildren().addAll(partCopy.getToolbar().getChildren());
                }
            }
        }
    }

    protected abstract EObject getInitializeObject();

    protected abstract void createContentComposite(Composite var1, int var2);

    public Composite getActualComposite() {
        if (this.parentComposite != null && !this.parentComposite.isDisposed() && this.parentComposite.getChildren().length > 0) {
            return (Composite)this.parentComposite.getChildren()[0];
        }
        return null;
    }

    protected abstract void setCompositeContent(EObject var1);

    protected void setEObject(EObject eObject) {
        if (this.parentComposite != null) {
            if (eObject != null) {
                if (this.getActualComposite() instanceof NoContentComposite) {
                    Control[] controlArray = this.parentComposite.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control control = controlArray[n2];
                        control.dispose();
                        ++n2;
                    }
                    this.createContentComposite(this.parentComposite, 0);
                    this.parentComposite.layout();
                }
                this.setCompositeContent(eObject);
            } else {
                this.setNoContentComposite();
            }
        }
    }

    protected void setNoContentComposite() {
        if (this.getActualComposite() != null) {
            Control[] controlArray = this.parentComposite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.dispose();
                ++n2;
            }
        }
        if (!this.parentComposite.isDisposed()) {
            this.createNoContentComposite(this.parentComposite, 0);
            this.parentComposite.layout();
        }
        this.selectionService.setSelection(null);
    }

    protected abstract void createNoContentComposite(Composite var1, int var2);

    @PreDestroy
    private void destroy() {
        this.dispose();
    }

    protected void dispose() {
    }
}

