/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.surface.ui.jme3.internal;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class SunGlowImageGenerator {
    public static final int TRANSPARENT_COLOR = -1;

    public static int getColor(double value) {
        if (value >= 0.0) {
            float factor = (float)(1.0 - value);
            if (factor < 0.0f) {
                factor = 0.0f;
            }
            if (factor > 1.0f) {
                factor = 1.0f;
            }
            float hue = 0.0f;
            hue = factor < 0.5f ? (0.5f - factor) / 0.5f * 0.1f : 1.0f - (factor - 0.5f) / 0.5f * 0.1f;
            Color color = Color.getHSBColor(hue, 0.9f, 0.9f);
            return color.getRGB();
        }
        return -1;
    }

    public static double f(double x) {
        double a5 = -5.07451403E-11;
        double a4 = 8.635031873E-8;
        double a3 = -5.722601654E-5;
        double a2 = 0.01861529584;
        double a1 = -3.114455857;
        double a0 = 255.7552448;
        return a5 * Math.pow(x, 5.0) + a4 * Math.pow(x, 4.0) + a3 * Math.pow(x, 3.0) + a2 * Math.pow(x, 2.0) + a1 * Math.pow(x, 1.0) + a0;
    }

    public static double getDistanceOLD(double x, double y, int width) {
        double curveValue = SunGlowImageGenerator.f(x);
        if (y > curveValue) {
            return -1.0;
        }
        double xp = 0.0;
        double yp = 0.0;
        double distance = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < width) {
            yp = SunGlowImageGenerator.f(i);
            double d = Math.sqrt((x - (double)i) * (x - (double)i) + (y - yp) * (y - yp));
            if (d < distance) {
                xp = i;
                distance = d;
            }
            ++i;
        }
        yp = SunGlowImageGenerator.f(xp);
        return 1.0 - xp / (double)width;
    }

    public static BufferedImage generateImageOLD(int width, int height) {
        double[][] distances = new double[width][height];
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                double distance;
                distances[x][y] = distance = SunGlowImageGenerator.getDistanceOLD(x, y, width);
                ++y;
            }
            ++x;
        }
        int[][] pixelColors = new int[width][height];
        int x2 = 0;
        while (x2 < width) {
            int y = 0;
            while (y < height) {
                int color;
                pixelColors[x2][y] = color = SunGlowImageGenerator.getColor(distances[x2][y]);
                ++y;
            }
            ++x2;
        }
        BufferedImage bufferedImage = new BufferedImage(width, height, 2);
        Graphics2D g = bufferedImage.createGraphics();
        g.setColor(new Color(0, 0, 0, 0));
        g.fillRect(0, 0, width, height);
        int x3 = 0;
        while (x3 < width) {
            int y = 0;
            while (y < height) {
                int rgb = pixelColors[x3][y];
                if (rgb != -1) {
                    bufferedImage.setRGB(x3, height - 1 - y, rgb);
                }
                ++y;
            }
            ++x3;
        }
        return bufferedImage;
    }

    public static void applyGrayscaleMaskToAlpha(BufferedImage image) {
        int width = image.getWidth();
        int[] imgData = new int[width];
        int y = 0;
        while (y < image.getHeight()) {
            image.getRGB(0, y, width, 1, imgData, 0, 1);
            int x = 0;
            while (x < width) {
                int color = imgData[x] & 0xFFFFFF;
                if (color != 0) {
                    float intensity = (1.0f - 1.0f * (float)x / (float)width) * 200.0f;
                    if (x == 0) {
                        intensity = 255.0f;
                    }
                    System.out.println(intensity);
                    int maskColor = (int)Math.floor(intensity);
                    imgData[x] = color |= (maskColor <<= 24);
                }
                ++x;
            }
            image.setRGB(0, y, width, 1, imgData, 0, 1);
            ++y;
        }
    }

    public static double getClosestX(int y, int width) {
        double xp = 0.0;
        double yp = 0.0;
        double distance = Double.POSITIVE_INFINITY;
        int x = 0;
        while (x < width) {
            yp = SunGlowImageGenerator.f(x);
            double d = Math.sqrt(((double)y - yp) * ((double)y - yp));
            if (d < distance) {
                xp = x;
                distance = d;
            }
            ++x;
        }
        return xp;
    }

    public static BufferedImage generateImage(int width, int height) {
        float[] distances = new float[height];
        int x = 0;
        while (x < height) {
            double xp = SunGlowImageGenerator.getClosestX(x, width);
            distances[x] = (float)xp;
            ++x;
        }
        int[][] pixelColors = new int[width][height];
        int x2 = 0;
        while (x2 < width) {
            int y = 0;
            while (y < height) {
                double factor = 0.0;
                factor = (float)x2 < distances[y] ? 1.0 - 1.0 * (double)x2 / (double)width : -1.0;
                if (factor != -1.0) {
                    int maskColor;
                    float intensity;
                    int color = SunGlowImageGenerator.getColor(factor) & 0xFFFFFF;
                    float distance = distances[y];
                    if (y < 10) {
                        intensity = 255.0f;
                        if (x2 >= 256) {
                            intensity = (1.0f - (float)((x2 - 256) / (width - 256))) * 255.0f;
                        }
                        maskColor = (int)Math.floor(intensity);
                        color |= (maskColor <<= 24);
                    } else {
                        intensity = (1.0f - 1.0f * (float)x2 / distance) * 255.0f;
                        maskColor = (int)Math.floor(intensity);
                        color |= (maskColor <<= 24);
                    }
                    pixelColors[x2][y] = color;
                }
                ++y;
            }
            ++x2;
        }
        BufferedImage bufferedImage = new BufferedImage(width, height, 2);
        Graphics2D g = bufferedImage.createGraphics();
        g.setColor(new Color(0, 0, 0, 0));
        g.fillRect(0, 0, width, height);
        int x3 = 0;
        while (x3 < width) {
            int y = 0;
            while (y < height) {
                int rgb = pixelColors[x3][y];
                if (rgb != -1) {
                    bufferedImage.setRGB(x3, height - 1 - y, rgb);
                }
                ++y;
            }
            ++x3;
        }
        Color color = new Color(255, 255, 234);
        int rgb = color.getRGB();
        int y = 0;
        while (y < height) {
            bufferedImage.setRGB(0, y, rgb);
            ++y;
        }
        return bufferedImage;
    }

    public static void main(String[] args) {
        int width = 512;
        int height = 256;
        BufferedImage image = SunGlowImageGenerator.generateImage(width, height);
        File file = new File("/home/pallard/Pictures/test.png");
        try {
            ImageIO.write((RenderedImage)image, "png", file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

