/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.surface.converters;

import org.eclipse.apogy.common.converters.IConverter;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.core.environment.ApogyEnvironment;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;
import org.eclipse.apogy.core.environment.earth.surface.EarthSurfaceWorksite;
import org.eclipse.apogy.core.invocator.InvocatorSession;
import org.eclipse.emf.ecore.EObject;

public class GeographicalCoordinatesToPositionConverter
implements IConverter {
    public Class<?> getOutputType() {
        return Tuple3d.class;
    }

    public Class<?> getInputType() {
        return GeographicCoordinates.class;
    }

    public boolean canConvert(Object input) {
        GeographicCoordinates coordinates;
        EarthSurfaceWorksite worksite;
        return input instanceof GeographicCoordinates && (worksite = this.getEarthSurfaceWorksite(coordinates = (GeographicCoordinates)input)) != null;
    }

    public Object convert(Object input) throws Exception {
        if (this.canConvert(input)) {
            GeographicCoordinates coordinates = (GeographicCoordinates)input;
            EarthSurfaceWorksite worksite = this.getEarthSurfaceWorksite(coordinates);
            return worksite.convertToXYZPosition(coordinates);
        }
        return null;
    }

    protected EarthSurfaceWorksite getEarthSurfaceWorksite(GeographicCoordinates coordinates) {
        EarthSurfaceWorksite earthSurfaceWorksite = null;
        EObject container = coordinates.eContainer();
        while (earthSurfaceWorksite == null && container != null) {
            if (container instanceof EarthSurfaceWorksite) {
                earthSurfaceWorksite = (EarthSurfaceWorksite)container;
                continue;
            }
            if (container instanceof InvocatorSession) {
                InvocatorSession session = (InvocatorSession)container;
                if (!(session.getEnvironment() instanceof ApogyEnvironment)) continue;
                ApogyEnvironment se = (ApogyEnvironment)session.getEnvironment();
                if (!(se.getActiveWorksite() instanceof EarthSurfaceWorksite)) break;
                earthSurfaceWorksite = (EarthSurfaceWorksite)se.getActiveWorksite();
                continue;
            }
            container = container.eContainer();
        }
        return earthSurfaceWorksite;
    }
}

