/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.ui.impl;

import gov.nasa.worldwind.layers.RenderableLayer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.environment.earth.ui.ApogyEarthEnvironmentUIPackage;
import org.eclipse.apogy.core.environment.earth.ui.impl.AbstractWorldWindLayerImpl;
import org.eclipse.apogy.core.environment.earth.ui.utils.MultiEObjectsAdapter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.progress.UIJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWorldWindLayerCustomImpl
extends AbstractWorldWindLayerImpl {
    private static final Logger Logger = LoggerFactory.getLogger(AbstractWorldWindLayerImpl.class);
    private static UIJob blinkingJob = null;
    private static Map<AbstractWorldWindLayerCustomImpl, Boolean> blinkingLayers = new HashMap<AbstractWorldWindLayerCustomImpl, Boolean>();
    private MultiEObjectsAdapter layerAdapter = null;

    protected AbstractWorldWindLayerCustomImpl() {
        this.eAdapters().add((Object)this.getLayerAdapter());
        AbstractWorldWindLayerCustomImpl.getBlinkingJob();
    }

    @Override
    public void setVisible(boolean newVisible) {
        super.setVisible(newVisible);
        this.updateRenderableLayer();
    }

    @Override
    public void setBlinking(boolean newBlinking) {
        if (newBlinking && !this.blinking) {
            blinkingLayers.put(this, this.isVisible());
        } else if (!newBlinking && this.blinking) {
            Boolean originalVisibility = blinkingLayers.get(this);
            if (originalVisibility != null) {
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyEarthEnvironmentUIPackage.Literals.ABSTRACT_WORLD_WIND_LAYER__VISIBLE, (Object)originalVisibility, true);
            }
            blinkingLayers.remove(this);
        }
        super.setBlinking(newBlinking);
    }

    @Override
    public RenderableLayer getRenderableLayer() {
        RenderableLayer tmp = super.getRenderableLayer();
        if (tmp == null) {
            tmp = new RenderableLayer();
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyEarthEnvironmentUIPackage.Literals.ABSTRACT_WORLD_WIND_LAYER__RENDERABLE_LAYER, (Object)tmp);
        }
        return tmp;
    }

    @Override
    public void initialise() {
    }

    public void update() throws Exception {
        if (!this.isUpdating() && !this.isDisposed()) {
            try {
                this.updateRenderableLayer();
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void dispose() {
        while (this.isUpdating()) {
            try {
                Logger.warn("Waiting for layer to complete update...");
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyEarthEnvironmentUIPackage.Literals.ABSTRACT_WORLD_WIND_LAYER__DISPOSED, (Object)true, true);
        RenderableLayer layer = this.getRenderableLayer();
        layer.removeAllRenderables();
        this.getRenderableLayer().firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, (Object)this);
    }

    @Override
    public void selectionChanged(ISelection selection) {
    }

    public boolean getDefaultAutoUpdateEnabled() {
        return false;
    }

    protected abstract void updateRenderableLayer();

    private MultiEObjectsAdapter getLayerAdapter() {
        if (this.layerAdapter == null) {
            this.layerAdapter = new MultiEObjectsAdapter(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof AbstractWorldWindLayerCustomImpl) {
                        int featureId = msg.getFeatureID(AbstractWorldWindLayerCustomImpl.class);
                        switch (featureId) {
                            case 5: {
                                if (!AbstractWorldWindLayerCustomImpl.this.isAutoUpdateEnabled()) break;
                                AbstractWorldWindLayerCustomImpl.this.updateRenderableLayer();
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.layerAdapter;
    }

    private static UIJob getBlinkingJob() {
        if (blinkingJob == null) {
            blinkingJob = new UIJob("World Wind Layer Blinking"){
                private boolean visible = true;

                public IStatus runInUIThread(IProgressMonitor progressMonitor) {
                    ArrayList layers = new ArrayList(blinkingLayers.keySet());
                    for (AbstractWorldWindLayerCustomImpl layer : layers) {
                        if (layer.isDisposed()) continue;
                        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)layer, (EStructuralFeature)ApogyEarthEnvironmentUIPackage.Literals.ABSTRACT_WORLD_WIND_LAYER__VISIBLE, (Object)this.visible, true);
                    }
                    boolean bl = this.visible = !this.visible;
                    if (!progressMonitor.isCanceled()) {
                        this.schedule(1000L);
                    }
                    return Status.OK_STATUS;
                }
            };
            blinkingJob.setPriority(30);
            blinkingJob.schedule();
        }
        return blinkingJob;
    }
}

