/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.ui.impl;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.AnnotationAttributes;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.GlobeAnnotation;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfaceCircle;
import java.awt.Color;
import java.awt.Font;
import java.text.DecimalFormat;
import javax.vecmath.Color3f;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.ApogyCorePackage;
import org.eclipse.apogy.core.environment.earth.EarthSurfaceLocation;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;
import org.eclipse.apogy.core.environment.earth.ui.impl.EarthSurfaceLocationWorldWindLayerImpl;
import org.eclipse.apogy.core.environment.earth.ui.utils.MultiEObjectsAdapter;
import org.eclipse.apogy.core.environment.earth.ui.utils.WorldWindUtils;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EarthSurfaceLocationWorldWindLayerCustomImpl
extends EarthSurfaceLocationWorldWindLayerImpl {
    private static final Logger Logger = LoggerFactory.getLogger(EarthSurfaceLocationWorldWindLayerImpl.class);
    public static final String DEGREE_STRING = "\u00b0";
    private MultiEObjectsAdapter earthSurfaceLocationAdapter = null;

    protected EarthSurfaceLocationWorldWindLayerCustomImpl() {
        this.eAdapters().add((Object)this.getEarthSurfaceLocationAdapter());
    }

    @Override
    public void setEarthSurfaceLocation(EarthSurfaceLocation newEarthSurfaceLocation) {
        if (this.getEarthSurfaceLocation() != null) {
            this.getEarthSurfaceLocation().eAdapters().remove((Object)this.getEarthSurfaceLocationAdapter());
        }
        super.setEarthSurfaceLocation(newEarthSurfaceLocation);
        if (newEarthSurfaceLocation != null) {
            newEarthSurfaceLocation.eAdapters().add((Object)this.getEarthSurfaceLocationAdapter());
        }
        this.updateRenderableLayer();
    }

    @Override
    public void setTargetRadius(double newTargetRadius) {
        super.setTargetRadius(newTargetRadius);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void setDisplayBalloon(boolean newDisplayBalloon) {
        super.setDisplayBalloon(newDisplayBalloon);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void setDisplayLocation(boolean newDisplayLocation) {
        super.setDisplayLocation(newDisplayLocation);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void setColor(Color3f newColor) {
        super.setColor(newColor);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void setOpacity(double newOpacity) {
        if (newOpacity >= 0.0) {
            super.setOpacity(newOpacity);
            if (this.isAutoUpdateEnabled()) {
                try {
                    this.update();
                }
                catch (Exception e) {
                    Logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @Override
    public boolean getDefaultAutoUpdateEnabled() {
        return true;
    }

    @Override
    public void dispose() {
        if (this.getEarthSurfaceLocation() != null) {
            this.getEarthSurfaceLocation().eAdapters().remove((Object)this.getEarthSurfaceLocationAdapter());
        }
        this.getEarthSurfaceLocationAdapter().unregisterFromAllObjects();
        super.dispose();
    }

    @Override
    protected void updateRenderableLayer() {
        if (!this.isUpdating()) {
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyCorePackage.Literals.UPDATABLE__UPDATING, (Object)true, true);
            RenderableLayer layer = this.getRenderableLayer();
            layer.removeAllRenderables();
            if (this.isVisible() && !this.isDisposed()) {
                this.addRenderable(layer);
            }
            this.getRenderableLayer().firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, (Object)this);
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyCorePackage.Literals.UPDATABLE__UPDATING, (Object)false, true);
        }
    }

    protected void addRenderable(RenderableLayer layer) {
        try {
            if (this.getEarthSurfaceLocation() != null) {
                EarthSurfaceLocation coord = this.getEarthSurfaceLocation();
                Angle latitude = Angle.fromRadiansLatitude((double)coord.getLatitude());
                Angle longitude = Angle.fromRadiansLongitude((double)coord.getLongitude());
                double elevation = coord.getElevation();
                Position position = new Position(latitude, longitude, elevation);
                BasicShapeAttributes attributes = new BasicShapeAttributes();
                attributes.setDrawInterior(true);
                attributes.setOutlineOpacity(0.95);
                attributes.setInteriorOpacity(this.getOpacity());
                Material mat = new Material(WorldWindUtils.convertFrom(this.getColor()));
                attributes.setInteriorMaterial(mat);
                SurfaceCircle surfaceCircle = new SurfaceCircle((ShapeAttributes)attributes, (LatLon)position, this.getTargetRadius() * 1000.0, 24);
                surfaceCircle.setVisible(true);
                layer.addRenderable((Renderable)surfaceCircle);
                if (this.isDisplayBalloon()) {
                    String text = this.getDisplayedText();
                    GlobeAnnotation annotation = new GlobeAnnotation(text, position);
                    AnnotationAttributes annotationAttributes = new AnnotationAttributes();
                    annotationAttributes.setCornerRadius(0);
                    annotationAttributes.setVisible(true);
                    Font font = annotationAttributes.getFont();
                    font = font.deriveFont(1, 16.0f);
                    annotationAttributes.setFont(font);
                    Color transparent = new Color(0.0f, 0.0f, 1.0f, 0.3f);
                    annotationAttributes.setBackgroundColor(transparent);
                    annotationAttributes.setTextColor(Color.YELLOW);
                    annotation.setAttributes(annotationAttributes);
                    layer.addRenderable((Renderable)annotation);
                }
            }
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
    }

    protected String getDisplayedText() {
        String text = "";
        text = this.getName() != null && this.getName().length() > 0 ? this.getName() : "?";
        if (this.isDisplayLocation()) {
            DecimalFormat latLongDecimalFormat = new DecimalFormat("0.00000");
            double lat = Math.toDegrees(this.getEarthSurfaceLocation().getLatitude());
            double lon = Math.toDegrees(this.getEarthSurfaceLocation().getLongitude());
            DecimalFormat altitudeDecimalFormat = new DecimalFormat("0.000");
            double altitude = this.getEarthSurfaceLocation().getElevation() * 0.001;
            text = String.valueOf(text) + "\n lat " + latLongDecimalFormat.format(lat) + DEGREE_STRING + "\n lon " + latLongDecimalFormat.format(lon) + DEGREE_STRING + "\n alt " + altitudeDecimalFormat.format(altitude) + " km";
        }
        return text;
    }

    private MultiEObjectsAdapter getEarthSurfaceLocationAdapter() {
        if (this.earthSurfaceLocationAdapter == null) {
            this.earthSurfaceLocationAdapter = new MultiEObjectsAdapter(){

                @Override
                public void registerToEObject(EObject eObject) {
                    if (eObject instanceof EarthSurfaceLocation) {
                        EarthSurfaceLocation newEarthSurfaceLocation = (EarthSurfaceLocation)eObject;
                        newEarthSurfaceLocation.eAdapters().add((Object)EarthSurfaceLocationWorldWindLayerCustomImpl.this.getEarthSurfaceLocationAdapter());
                    } else {
                        super.registerToEObject(eObject);
                    }
                }

                public void notifyChanged(Notification msg) {
                    block6: {
                        block5: {
                            if (!(msg.getNotifier() instanceof EarthSurfaceLocation)) break block5;
                            int featureId = msg.getFeatureID(EarthSurfaceLocation.class);
                            switch (featureId) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: {
                                    if (EarthSurfaceLocationWorldWindLayerCustomImpl.this.isAutoUpdateEnabled()) {
                                        EarthSurfaceLocationWorldWindLayerCustomImpl.this.updateRenderableLayer();
                                        break;
                                    } else {
                                        break;
                                    }
                                }
                            }
                            break block6;
                        }
                        if (msg.getNotifier() instanceof GeographicCoordinates && EarthSurfaceLocationWorldWindLayerCustomImpl.this.isAutoUpdateEnabled()) {
                            EarthSurfaceLocationWorldWindLayerCustomImpl.this.updateRenderableLayer();
                        }
                    }
                }
            };
        }
        return this.earthSurfaceLocationAdapter;
    }
}

