/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.ui.impl;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.ogc.kml.KMLAbstractFeature;
import gov.nasa.worldwind.ogc.kml.KMLAbstractGeometry;
import gov.nasa.worldwind.ogc.kml.KMLDocument;
import gov.nasa.worldwind.ogc.kml.KMLLinearRing;
import gov.nasa.worldwind.ogc.kml.KMLMultiGeometry;
import gov.nasa.worldwind.ogc.kml.KMLPlacemark;
import gov.nasa.worldwind.ogc.kml.KMLPolygon;
import gov.nasa.worldwind.ogc.kml.KMLRoot;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfacePolygon;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWMath;
import java.awt.Color;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.Color3f;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.ApogyCorePackage;
import org.eclipse.apogy.core.environment.earth.ApogyEarthEnvironmentFactory;
import org.eclipse.apogy.core.environment.earth.ApogyEarthFacade;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;
import org.eclipse.apogy.core.environment.earth.ui.ApogyEarthEnvironmentUIPackage;
import org.eclipse.apogy.core.environment.earth.ui.impl.SurfacePolygonWorldWindLayerImpl;
import org.eclipse.apogy.core.environment.earth.ui.utils.WorldWindUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SurfacePolygonWorldWindLayerCustomImpl
extends SurfacePolygonWorldWindLayerImpl {
    private static final Logger Logger = LoggerFactory.getLogger(SurfacePolygonWorldWindLayerImpl.class);
    protected SurfacePolygon polygon;

    @Override
    public void setUrl(String newUrl) {
        super.setUrl(newUrl);
        this.loadFile();
    }

    @Override
    public void setColor(Color3f newColor) {
        super.setColor(newColor);
        this.updateRenderableLayer();
    }

    @Override
    public void setOpacity(double newOpacity) {
        if (newOpacity > 1.0) {
            super.setOpacity(1.0);
        } else if (newOpacity < 0.0) {
            super.setOpacity(0.0);
        } else {
            super.setOpacity(newOpacity);
        }
        this.updateRenderableLayer();
    }

    @Override
    public boolean isCoordinatesInside(GeographicCoordinates coordinates) {
        if (this.polygon != null) {
            Position position = WorldWindUtils.convertToPosition(coordinates);
            return WWMath.isLocationInside((LatLon)position, (Iterable)this.polygon.getLocations());
        }
        return false;
    }

    @Override
    public void initialise() {
        this.loadFile();
        super.initialise();
    }

    @Override
    public boolean getDefaultAutoUpdateEnabled() {
        return true;
    }

    protected void loadFile() {
        try {
            ApogyCommonTransactionFacade.INSTANCE.basicClear((EObject)this, (EStructuralFeature)ApogyEarthEnvironmentUIPackage.Literals.SURFACE_POLYGON_WORLD_WIND_LAYER__GEOGRAPHIC_COORDINATES_LIST, true);
            List<Object> coords = new ArrayList();
            if (this.getUrl() != null) {
                if (this.getUrl().endsWith("csv")) {
                    coords = ApogyEarthFacade.INSTANCE.loadGeographicCoordinatesFromURL(this.getUrl());
                } else if (this.getUrl().endsWith("kmz") || this.getUrl().endsWith("kml")) {
                    coords = this.loadGeographicCoordinatesFromKML(this.getUrl());
                }
            }
            ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)this, (EStructuralFeature)ApogyEarthEnvironmentUIPackage.Literals.SURFACE_POLYGON_WORLD_WIND_LAYER__GEOGRAPHIC_COORDINATES_LIST, coords, true);
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), (Throwable)e);
        }
        if (this.isAutoUpdateEnabled()) {
            this.updateRenderableLayer();
        }
    }

    @Override
    protected void updateRenderableLayer() {
        if (!this.isUpdating() && !this.isDisposed()) {
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyCorePackage.Literals.UPDATABLE__UPDATING, (Object)true);
            RenderableLayer layer = this.getRenderableLayer();
            layer.removeAllRenderables();
            if (this.isVisible()) {
                this.addRenderable(layer);
            }
            this.getRenderableLayer().firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, (Object)this);
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyCorePackage.Literals.UPDATABLE__UPDATING, (Object)false);
        }
    }

    private void addRenderable(RenderableLayer layer) {
        try {
            if (!this.getGeographicCoordinatesList().isEmpty()) {
                this.polygon = this.createPolygon(this.getWorldWindow());
                layer.addRenderable((Renderable)this.polygon);
            } else {
                this.polygon = null;
            }
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
    }

    protected SurfacePolygon createPolygon(WorldWindow wwd) {
        SurfacePolygon poly = new SurfacePolygon();
        poly.setAttributes(this.getDefaultAttributes());
        poly.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)this.getName());
        this.initializePolygon(wwd, poly);
        return poly;
    }

    protected void initializePolygon(WorldWindow wwd, SurfacePolygon polygon) {
        ArrayList<Position> positions = new ArrayList<Position>();
        for (GeographicCoordinates coords : this.getGeographicCoordinatesList()) {
            Position position = WorldWindUtils.convertToPosition(coords);
            positions.add(position);
        }
        polygon.setLocations(positions);
    }

    protected ShapeAttributes getDefaultAttributes() {
        BasicShapeAttributes attributes = new BasicShapeAttributes();
        Color color = WorldWindUtils.convertFrom(this.getColor());
        attributes.setInteriorMaterial(new Material(color, color, color, color, 0.0f));
        attributes.setOutlineMaterial(new Material(color, color, color, color, 0.0f));
        attributes.setDrawOutline(true);
        attributes.setInteriorOpacity(this.getOpacity());
        attributes.setOutlineOpacity(0.95);
        attributes.setOutlineWidth(2.0);
        return attributes;
    }

    private List<GeographicCoordinates> loadGeographicCoordinatesFromKML(String urlString) {
        ArrayList<GeographicCoordinates> coords = new ArrayList<GeographicCoordinates>();
        try {
            URL url = WWIO.makeURL((String)urlString);
            KMLRoot kmlRoot = KMLRoot.createAndParse((Object)url);
            KMLDocument kmlDocument = (KMLDocument)kmlRoot.getFeature();
            List<KMLAbstractFeature> features = WorldWindUtils.getAllKMLAbstractFeatureOfType(KMLPlacemark.class, kmlDocument);
            System.out.println();
            KMLPlacemark kmlPlacemark = (KMLPlacemark)features.get(0);
            if (kmlPlacemark.getGeometry() instanceof KMLMultiGeometry) {
                KMLMultiGeometry kmlMultiGeometry = (KMLMultiGeometry)kmlPlacemark.getGeometry();
                KMLPolygon kmlPolygon = null;
                Iterator it = kmlMultiGeometry.getGeometries().iterator();
                while (it.hasNext() && kmlPolygon == null) {
                    KMLAbstractGeometry tmp = (KMLAbstractGeometry)it.next();
                    if (!(tmp instanceof KMLPolygon)) continue;
                    kmlPolygon = (KMLPolygon)tmp;
                }
                KMLLinearRing ring = kmlPolygon.getOuterBoundary();
                Position.PositionList positionList = ring.getCoordinates();
                for (Position position : positionList.list) {
                    GeographicCoordinates coordinates = ApogyEarthEnvironmentFactory.eINSTANCE.createGeographicCoordinates();
                    coordinates.setElevation(position.getElevation());
                    coordinates.setLatitude(position.getLatitude().radians);
                    coordinates.setLongitude(position.getLongitude().radians);
                    coords.add(coordinates);
                }
            }
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), (Throwable)e);
        }
        return coords;
    }
}

