/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.ui.composites;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ui.EClassSettings;
import org.eclipse.apogy.common.emf.ui.wizards.ApogyEObjectWizard;
import org.eclipse.apogy.core.environment.surface.AbstractMapLayer;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentFacade;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentPackage;
import org.eclipse.apogy.core.environment.surface.CartesianTriangularMeshMapLayer;
import org.eclipse.apogy.core.environment.surface.FeaturesOfInterestMapLayer;
import org.eclipse.apogy.core.environment.surface.ImageMapLayer;
import org.eclipse.apogy.core.environment.surface.Map;
import org.eclipse.apogy.core.environment.surface.ui.ApogySurfaceEnvironmentUIFactory;
import org.eclipse.apogy.core.environment.surface.ui.ImageMapLayerUISettings;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OtherLayersListComposite
extends Composite {
    private static final Logger Logger = LoggerFactory.getLogger(OtherLayersListComposite.class);
    private Map map;
    private final Tree tree;
    private final TreeViewer treeViewer;
    private final Button btnNew;
    private final Button btnDelete;
    private final AdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private DataBindingContext m_bindingContext;

    public OtherLayersListComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        this.treeViewer = new TreeViewer((Composite)this, 68354);
        this.tree = this.treeViewer.getTree();
        GridData gd_tree = new GridData(4, 4, false, true, 1, 1);
        gd_tree.widthHint = 300;
        gd_tree.minimumWidth = 300;
        this.tree.setLayoutData((Object)gd_tree);
        this.tree.setLinesVisible(true);
        this.treeViewer.setContentProvider((IContentProvider)new CompositeFilterContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory));
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                OtherLayersListComposite.this.newAbstractMapLayerSelected((AbstractMapLayer)((IStructuredSelection)event.getSelection()).getFirstElement());
            }
        });
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        composite.setLayout((Layout)new GridLayout(1, false));
        this.btnNew = new Button(composite, 0);
        this.btnNew.setSize(74, 29);
        this.btnNew.setText("New");
        this.btnNew.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnNew.setEnabled(true);
        this.btnNew.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 13) {
                    ImageMapLayerUISettings settings = ApogySurfaceEnvironmentUIFactory.eINSTANCE.createImageMapLayerUISettings();
                    settings.setName(ApogyCommonEMFFacade.INSTANCE.getDefaultName((EObject)OtherLayersListComposite.this.getMap(), null, (ETypedElement)ApogySurfaceEnvironmentPackage.Literals.MAP__LAYERS));
                    settings.setMap(OtherLayersListComposite.this.getMap());
                    ApogyEObjectWizard wizard = new ApogyEObjectWizard(ApogySurfaceEnvironmentPackage.Literals.MAP__LAYERS, (EObject)OtherLayersListComposite.this.getMap(), (EClassSettings)settings, ApogySurfaceEnvironmentPackage.Literals.ABSTRACT_MAP_LAYER);
                    WizardDialog dialog = new WizardDialog(OtherLayersListComposite.this.getShell(), (IWizard)wizard);
                    dialog.open();
                    if (!OtherLayersListComposite.this.treeViewer.isBusy()) {
                        OtherLayersListComposite.this.treeViewer.setInput((Object)OtherLayersListComposite.this.getMap());
                    }
                }
            }
        });
        this.btnDelete = new Button(composite, 0);
        this.btnDelete.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnDelete.setSize(74, 29);
        this.btnDelete.setText("Delete");
        this.btnDelete.setEnabled(false);
        this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String abstractMapLayerToDeleteMessage = "";
                Iterator<AbstractMapLayer> abstractMapLayers = OtherLayersListComposite.this.getSelectedAbstractMapLayers().iterator();
                while (abstractMapLayers.hasNext()) {
                    AbstractMapLayer abstractMapLayer = abstractMapLayers.next();
                    abstractMapLayerToDeleteMessage = String.valueOf(abstractMapLayerToDeleteMessage) + abstractMapLayer.getName();
                    if (!abstractMapLayers.hasNext()) continue;
                    abstractMapLayerToDeleteMessage = String.valueOf(abstractMapLayerToDeleteMessage) + ", ";
                }
                MessageDialog dialog = new MessageDialog(null, "Delete the selected Map Layers", null, "Are you sure to delete these Map Layers: " + abstractMapLayerToDeleteMessage, 3, new String[]{"Yes", "No"}, 1);
                int result = dialog.open();
                if (result == 0) {
                    for (AbstractMapLayer layer : OtherLayersListComposite.this.getSelectedAbstractMapLayers()) {
                        try {
                            ApogySurfaceEnvironmentFacade.INSTANCE.deleteLayerFromMap(layer.getMap(), layer);
                        }
                        catch (Exception e) {
                            Logger.error("Unable to delete the Map Layer <" + layer.getName() + ">.", (Throwable)e);
                        }
                    }
                }
                if (!OtherLayersListComposite.this.treeViewer.isBusy()) {
                    OtherLayersListComposite.this.treeViewer.setInput((Object)OtherLayersListComposite.this.getMap());
                }
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (OtherLayersListComposite.this.m_bindingContext != null) {
                    OtherLayersListComposite.this.m_bindingContext.dispose();
                }
            }
        });
    }

    public Map getMap() {
        return this.map;
    }

    public void setMap(Map newMap) {
        if (this.m_bindingContext != null) {
            this.m_bindingContext.dispose();
        }
        this.map = newMap;
        if (newMap != null) {
            this.m_bindingContext = this.customInitDataBindings();
            this.treeViewer.setInput((Object)newMap);
            AbstractMapLayer layer = this.getFirstAbstractMapLayer(newMap);
            if (layer != null) {
                this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)layer), true);
            }
        }
    }

    public List<AbstractMapLayer> getSelectedAbstractMapLayers() {
        return ((IStructuredSelection)this.treeViewer.getSelection()).toList();
    }

    protected AbstractMapLayer getFirstAbstractMapLayer(Map map) {
        List<AbstractMapLayer> maps = this.filterMap(map);
        if (!maps.isEmpty()) {
            return maps.get(0);
        }
        return null;
    }

    protected void newAbstractMapLayerSelected(AbstractMapLayer abstractMapLayer) {
    }

    protected DataBindingContext customInitDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        IViewerObservableValue observeSingleSelectionViewer = ViewerProperties.singleSelection().observe((Viewer)this.treeViewer);
        ISWTObservableValue observeEnabledBtnDeleteObserveWidget = WidgetProperties.enabled().observe((Widget)this.btnDelete);
        bindingContext.bindValue((IObservableValue)observeEnabledBtnDeleteObserveWidget, (IObservableValue)observeSingleSelectionViewer, null, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(Object.class, Boolean.class){

            public Object convert(Object fromObject) {
                if (fromObject != null) {
                    return true;
                }
                return false;
            }
        }));
        return bindingContext;
    }

    private List<AbstractMapLayer> filterMap(Map map) {
        ArrayList<AbstractMapLayer> maps = new ArrayList<AbstractMapLayer>();
        for (AbstractMapLayer layer : map.getLayers()) {
            if (layer instanceof CartesianTriangularMeshMapLayer || layer instanceof FeaturesOfInterestMapLayer || layer instanceof ImageMapLayer) continue;
            maps.add(layer);
        }
        return maps;
    }

    private class CompositeFilterContentProvider
    implements ITreeContentProvider {
        private CompositeFilterContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Map) {
                Map map = (Map)inputElement;
                return OtherLayersListComposite.this.filterMap(map).toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Map) {
                Map map = (Map)parentElement;
                return OtherLayersListComposite.this.filterMap(map).toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof Map) {
                Map map = (Map)element;
                return !OtherLayersListComposite.this.filterMap(map).isEmpty();
            }
            return false;
        }
    }
}

