/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.ui.composites;

import java.util.Iterator;
import java.util.List;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentFactory;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentPackage;
import org.eclipse.apogy.core.environment.surface.CartesianTriangularMeshDiscreteSlopeImageMapLayer;
import org.eclipse.apogy.core.environment.surface.SlopeRange;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlopeRangeListComposite
extends Composite {
    private static final Logger Logger = LoggerFactory.getLogger(SlopeRangeListComposite.class);
    private CartesianTriangularMeshDiscreteSlopeImageMapLayer cartesianTriangularMeshDiscreteSlopeImageMapLayer;
    private final TableViewer tableViewer;
    private final Table table;
    private final Button btnNew;
    private final Button btnDelete;
    private final AdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private DataBindingContext m_bindingContext;

    public SlopeRangeListComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        this.tableViewer = new TableViewer((Composite)this, 68354);
        this.table = this.tableViewer.getTable();
        GridData gd_tree = new GridData(4, 4, false, true, 1, 1);
        gd_tree.widthHint = 300;
        gd_tree.minimumWidth = 300;
        this.table.setLayoutData((Object)gd_tree);
        this.table.setLinesVisible(true);
        TableViewerColumn tableViewerColumnItem_Name = new TableViewerColumn(this.tableViewer, 0);
        TableColumn trclmnItemName = tableViewerColumnItem_Name.getColumn();
        trclmnItemName.setWidth(200);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory));
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                System.out.println("SELECTION : " + event);
                SlopeRangeListComposite.this.newSlopeRangeSelected((SlopeRange)((IStructuredSelection)event.getSelection()).getFirstElement());
            }
        });
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        composite.setLayout((Layout)new GridLayout(1, false));
        this.btnNew = new Button(composite, 0);
        this.btnNew.setSize(74, 29);
        this.btnNew.setText("New");
        this.btnNew.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnNew.setEnabled(true);
        this.btnNew.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 13) {
                    SlopeRange newSlopeRange = ApogySurfaceEnvironmentFactory.eINSTANCE.createSlopeRange();
                    newSlopeRange.setName("TEST");
                    newSlopeRange.setSlopeLowerBound(0.0);
                    newSlopeRange.setSlopeUpperBound(10.0);
                    ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)SlopeRangeListComposite.this.getCartesianTriangularMeshDiscreteSlopeImageMapLayer(), (EStructuralFeature)ApogySurfaceEnvironmentPackage.Literals.CARTESIAN_TRIANGULAR_MESH_DISCRETE_SLOPE_IMAGE_MAP_LAYER__SLOPE_RANGES, (Object)newSlopeRange);
                    if (!SlopeRangeListComposite.this.tableViewer.isBusy()) {
                        SlopeRangeListComposite.this.tableViewer.setInput((Object)SlopeRangeListComposite.this.getCartesianTriangularMeshDiscreteSlopeImageMapLayer().getSlopeRanges());
                    }
                    SlopeRangeListComposite.this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)newSlopeRange));
                }
            }
        });
        this.btnDelete = new Button(composite, 0);
        this.btnDelete.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnDelete.setSize(74, 29);
        this.btnDelete.setText("Delete");
        this.btnDelete.setEnabled(false);
        this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String imageMapLayersToDeleteMessage = "";
                Iterator<SlopeRange> slopeRangeList = SlopeRangeListComposite.this.getSelectedSlopeRanges().iterator();
                while (slopeRangeList.hasNext()) {
                    SlopeRange slopeRange = slopeRangeList.next();
                    imageMapLayersToDeleteMessage = String.valueOf(imageMapLayersToDeleteMessage) + slopeRange.getName();
                    if (!slopeRangeList.hasNext()) continue;
                    imageMapLayersToDeleteMessage = String.valueOf(imageMapLayersToDeleteMessage) + ", ";
                }
                MessageDialog dialog = new MessageDialog(null, "Delete the selected Slope Range", null, "Are you sure to delete these Slope Range: " + imageMapLayersToDeleteMessage, 3, new String[]{"Yes", "No"}, 1);
                int result = dialog.open();
                if (result == 0) {
                    for (SlopeRange slopeRange : SlopeRangeListComposite.this.getSelectedSlopeRanges()) {
                        try {
                            ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)SlopeRangeListComposite.this.getCartesianTriangularMeshDiscreteSlopeImageMapLayer(), (EStructuralFeature)ApogySurfaceEnvironmentPackage.Literals.CARTESIAN_TRIANGULAR_MESH_DISCRETE_SLOPE_IMAGE_MAP_LAYER__SLOPE_RANGES, (Object)slopeRange);
                        }
                        catch (Exception e) {
                            Logger.error("Unable to delete the Slope Range <" + slopeRange.getName() + ">", (Throwable)e);
                        }
                    }
                }
                if (!SlopeRangeListComposite.this.tableViewer.isBusy()) {
                    SlopeRangeListComposite.this.tableViewer.setInput((Object)SlopeRangeListComposite.this.getCartesianTriangularMeshDiscreteSlopeImageMapLayer().getSlopeRanges());
                }
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (SlopeRangeListComposite.this.m_bindingContext != null) {
                    SlopeRangeListComposite.this.m_bindingContext.dispose();
                }
            }
        });
    }

    public CartesianTriangularMeshDiscreteSlopeImageMapLayer getCartesianTriangularMeshDiscreteSlopeImageMapLayer() {
        return this.cartesianTriangularMeshDiscreteSlopeImageMapLayer;
    }

    public void setCartesianTriangularMeshDiscreteSlopeImageMapLayer(CartesianTriangularMeshDiscreteSlopeImageMapLayer newLayer) {
        if (this.m_bindingContext != null) {
            this.m_bindingContext.dispose();
        }
        this.cartesianTriangularMeshDiscreteSlopeImageMapLayer = newLayer;
        if (newLayer != null) {
            this.m_bindingContext = this.customInitDataBindings();
            this.tableViewer.setInput((Object)newLayer.getSlopeRanges());
            if (!newLayer.getSlopeRanges().isEmpty()) {
                SlopeRange selectedSlopeRange = (SlopeRange)newLayer.getSlopeRanges().get(0);
                this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)selectedSlopeRange), true);
                this.newSlopeRangeSelected(selectedSlopeRange);
            } else {
                this.tableViewer.setSelection(null, true);
            }
        }
    }

    public List<SlopeRange> getSelectedSlopeRanges() {
        return ((IStructuredSelection)this.tableViewer.getSelection()).toList();
    }

    public SlopeRange getSelectedSlopeRange() {
        List<SlopeRange> selected = this.getSelectedSlopeRanges();
        if (selected != null && !selected.isEmpty()) {
            return selected.get(0);
        }
        return null;
    }

    protected void newSlopeRangeSelected(SlopeRange newSlopeRange) {
    }

    protected DataBindingContext customInitDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        IViewerObservableValue observeSingleSelectionViewer = ViewerProperties.singleSelection().observe((Viewer)this.tableViewer);
        ISWTObservableValue observeEnabledBtnDeleteObserveWidget = WidgetProperties.enabled().observe((Widget)this.btnDelete);
        bindingContext.bindValue((IObservableValue)observeEnabledBtnDeleteObserveWidget, (IObservableValue)observeSingleSelectionViewer, null, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(Object.class, Boolean.class){

            public Object convert(Object fromObject) {
                Boolean result = fromObject != null;
                result = result != false && SlopeRangeListComposite.this.getCartesianTriangularMeshDiscreteSlopeImageMapLayer().getSlopeRanges().size() > 1;
                return result;
            }
        }));
        return bindingContext;
    }
}

