/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.impl;

import javax.vecmath.Vector3d;
import org.eclipse.apogy.core.ApogyCoreFactory;
import org.eclipse.apogy.core.FeatureOfInterest;
import org.eclipse.apogy.core.FeatureOfInterestList;
import org.eclipse.apogy.core.FeatureOfInterestListNode;
import org.eclipse.apogy.core.environment.surface.AbstractMapLayerNode;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentFactory;
import org.eclipse.apogy.core.environment.surface.RectangularRegion;
import org.eclipse.apogy.core.environment.surface.impl.FeaturesOfInterestMapLayerImpl;

public class FeaturesOfInterestMapLayerCustomImpl
extends FeaturesOfInterestMapLayerImpl {
    private FeatureOfInterestListNode featureOfInterestListNode = null;

    @Override
    public void setFeatures(FeatureOfInterestList newFeatures) {
        super.setFeatures(newFeatures);
        this.getFeatureOfInterestListNode().setFeatureOfInterestList(newFeatures);
    }

    @Override
    public RectangularRegion getRegion() {
        RectangularRegion region = ApogySurfaceEnvironmentFactory.eINSTANCE.createRectangularRegion();
        if (this.getFeatures().getFeaturesOfInterest().size() > 0) {
            double xMin = Double.POSITIVE_INFINITY;
            double yMin = Double.POSITIVE_INFINITY;
            double xMax = Double.NEGATIVE_INFINITY;
            double yMax = Double.NEGATIVE_INFINITY;
            for (FeatureOfInterest foi : this.getFeatures().getFeaturesOfInterest()) {
                Vector3d position = new Vector3d();
                foi.getPose().asMatrix4d().get(position);
                if (position.x < xMin) {
                    xMin = position.x;
                }
                if (position.x > xMax) {
                    xMax = position.x;
                }
                if (position.y < yMin) {
                    yMin = position.y;
                }
                if (!(position.y > yMax)) continue;
                yMax = position.y;
            }
            region.setXMin(xMin);
            region.setXMax(xMax);
            region.setYMin(yMin);
            region.setYMax(yMax);
        }
        return region;
    }

    @Override
    public void dispose() {
        if (this.featureOfInterestListNode == null && this.getAbstractMapLayerNode() != null) {
            this.getAbstractMapLayerNode().getChildren().remove((Object)this.featureOfInterestListNode);
        }
    }

    @Override
    public AbstractMapLayerNode getAbstractMapLayerNode() {
        AbstractMapLayerNode abstractMapLayerNode = super.getAbstractMapLayerNode();
        return abstractMapLayerNode;
    }

    protected synchronized FeatureOfInterestListNode getFeatureOfInterestListNode() {
        if (this.featureOfInterestListNode == null) {
            this.featureOfInterestListNode = ApogyCoreFactory.eINSTANCE.createFeatureOfInterestListNode();
            this.getAbstractMapLayerNode().getChildren().add((Object)this.featureOfInterestListNode);
        }
        return this.featureOfInterestListNode;
    }
}

