/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.ui.composites;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.apogy.common.emf.TimeSource;
import org.eclipse.apogy.common.emf.ui.Activator;
import org.eclipse.apogy.common.emf.ui.TimeSourceCompositeProvider;
import org.eclipse.apogy.common.emf.ui.composites.AbstractTimeSourceComposite;
import org.eclipse.apogy.core.environment.TimeSourcesList;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class ApogyEnvironmentTimeSourcesListComposite
extends Composite {
    private final Map<TimeSource, TabItem> timeSourceToTabItemMap = new HashMap<TimeSource, TabItem>();
    private TimeSourcesList timeSourcesList;
    private final TabFolder tabFolder;

    public ApogyEnvironmentTimeSourcesListComposite(Composite parent, int style) {
        this(parent, style, null);
    }

    public ApogyEnvironmentTimeSourcesListComposite(Composite parent, int style, TimeSourcesList timeSourcesList) {
        super(parent, 2048);
        this.setTimeSourcesList(timeSourcesList);
        this.tabFolder = new TabFolder((Composite)this, 0);
        this.tabFolder.setLayout((Layout)new FillLayout());
    }

    public TimeSourcesList getTimeSourcesList() {
        return this.timeSourcesList;
    }

    public void setTimeSourcesList(TimeSourcesList timeSourcesList) {
        this.timeSourcesList = timeSourcesList;
        this.populateTabFolder(this.tabFolder);
    }

    public void enableTimeSourceTab(TimeSource timeSource) {
        TabItem tabItem = this.getTabItem(timeSource);
        if (tabItem != null) {
            tabItem.getControl().setEnabled(true);
        }
    }

    public void disableTimeSourceTab(TimeSource timeSource) {
        TabItem tabItem = this.getTabItem(timeSource);
        if (tabItem != null) {
            tabItem.getControl().setEnabled(false);
        }
    }

    public void setSelectedTimeSourceTab(TimeSource timeSource) {
        if (!this.isDisposed()) {
            int numberItems = this.tabFolder.getItemCount();
            int i = 0;
            while (i < numberItems) {
                TabItem tabItem = this.tabFolder.getItem(i);
                if (tabItem != null && !tabItem.isDisposed() && tabItem.getControl() instanceof AbstractTimeSourceComposite) {
                    AbstractTimeSourceComposite atsc = (AbstractTimeSourceComposite)tabItem.getControl();
                    if (atsc.getTimeSource() == timeSource) {
                        atsc.activate(true);
                        this.tabFolder.setSelection(i);
                    } else {
                        atsc.activate(false);
                    }
                }
                ++i;
            }
        }
    }

    protected TabItem getTabItem(TimeSource timeSource) {
        return this.timeSourceToTabItemMap.get(timeSource);
    }

    protected void populateTabFolder(TabFolder tabFolder) {
        this.timeSourceToTabItemMap.clear();
        if (this.getTimeSourcesList() != null) {
            for (TimeSource timeSource : this.getTimeSourcesList().getTimeSources()) {
                TabItem tabItem = this.createTabItem(tabFolder, timeSource);
                this.timeSourceToTabItemMap.put(timeSource, tabItem);
            }
            tabFolder.pack();
        } else {
            this.clearTabFolder(tabFolder);
        }
    }

    protected void clearTabFolder(TabFolder tabFolder) {
        if (tabFolder != null && tabFolder.getItemCount() > 0) {
            ArrayList<TabItem> items = new ArrayList<TabItem>();
            int numberItems = tabFolder.getItemCount();
            int i = 0;
            while (i < numberItems) {
                items.add(tabFolder.getItem(i));
                ++i;
            }
            for (TabItem item : items) {
                if (item == null) continue;
                item.dispose();
            }
        }
    }

    protected TabItem createTabItem(TabFolder tabFolder, TimeSource timeSource) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(this.getTimeSourceText(timeSource));
        AbstractTimeSourceComposite composite = this.createAbstractTimeSourceComposite((Composite)tabFolder, timeSource);
        tabItem.setControl((Control)composite);
        return tabItem;
    }

    protected String getTimeSourceText(TimeSource timeSource) {
        String text = timeSource.eClass().getName();
        return text;
    }

    protected AbstractTimeSourceComposite createAbstractTimeSourceComposite(Composite parent, TimeSource timeSource) {
        AbstractTimeSourceComposite composite = null;
        TimeSourceCompositeProvider provider = Activator.getDefault().getTimeSourceCompositeProvider(timeSource);
        if (provider != null) {
            composite = provider.getComposite(parent, 0, timeSource);
        }
        return composite;
    }
}

