/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.ui.composites;

import java.util.Iterator;
import java.util.List;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.EClassSettings;
import org.eclipse.apogy.common.emf.ui.MapBasedEClassSettings;
import org.eclipse.apogy.common.emf.ui.wizards.ApogyEObjectWizard;
import org.eclipse.apogy.common.topology.AbstractViewPoint;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyPackage;
import org.eclipse.apogy.core.environment.ApogyCoreEnvironmentPackage;
import org.eclipse.apogy.core.environment.ViewPointList;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewPointListComposite
extends Composite {
    private static final Logger Logger = LoggerFactory.getLogger(ViewPointListComposite.class);
    private ViewPointList viewPointList;
    private final Tree tree;
    private final TreeViewer treeViewer;
    private final Button btnNew;
    private final Button btnDelete;
    private DataBindingContext m_bindingContext;
    private final AdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);

    public ViewPointListComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        this.treeViewer = new TreeViewer((Composite)this, 68356);
        this.tree = this.treeViewer.getTree();
        GridData gd_tree = new GridData(4, 4, false, true, 1, 1);
        gd_tree.widthHint = 200;
        gd_tree.minimumWidth = 200;
        this.tree.setLayoutData((Object)gd_tree);
        this.tree.setLinesVisible(true);
        this.treeViewer.setContentProvider((IContentProvider)new ViewPointContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory));
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ViewPointListComposite.this.newViewPointSelected((AbstractViewPoint)((IStructuredSelection)event.getSelection()).getFirstElement());
            }
        });
        Composite compositeButtons = new Composite((Composite)this, 0);
        compositeButtons.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        compositeButtons.setLayout((Layout)new GridLayout(1, false));
        this.btnNew = new Button(compositeButtons, 0);
        this.btnNew.setSize(74, 29);
        this.btnNew.setText("New");
        this.btnNew.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnNew.setEnabled(true);
        this.btnNew.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 13) {
                    MapBasedEClassSettings settings = ApogyCommonEMFUIFactory.eINSTANCE.createMapBasedEClassSettings();
                    settings.getUserDataMap().put("name", ApogyCommonEMFFacade.INSTANCE.getDefaultName((EObject)ViewPointListComposite.this.getViewPointList(), null, (ETypedElement)ApogyCoreEnvironmentPackage.Literals.VIEW_POINT_LIST__VIEW_POINTS));
                    ApogyEObjectWizard wizard = new ApogyEObjectWizard(ApogyCoreEnvironmentPackage.Literals.VIEW_POINT_LIST__VIEW_POINTS, (EObject)ViewPointListComposite.this.getViewPointList(), (EClassSettings)settings, ApogyCommonTopologyPackage.Literals.ABSTRACT_VIEW_POINT);
                    WizardDialog dialog = new WizardDialog(ViewPointListComposite.this.getShell(), (IWizard)wizard);
                    dialog.open();
                    if (!ViewPointListComposite.this.treeViewer.isBusy()) {
                        ViewPointListComposite.this.treeViewer.setInput((Object)ViewPointListComposite.this.getViewPointList());
                    }
                }
            }
        });
        this.btnDelete = new Button(compositeButtons, 0);
        this.btnDelete.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnDelete.setSize(74, 29);
        this.btnDelete.setText("Delete");
        this.btnDelete.setEnabled(false);
        this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String viewPointsToDeleteMessage = "";
                Iterator<AbstractViewPoint> viewPointsToDelete = ViewPointListComposite.this.getSelectedViewPoints().iterator();
                while (viewPointsToDelete.hasNext()) {
                    AbstractViewPoint viewPoint = viewPointsToDelete.next();
                    viewPointsToDeleteMessage = String.valueOf(viewPointsToDeleteMessage) + viewPoint.getName();
                    if (!viewPointsToDelete.hasNext()) continue;
                    viewPointsToDeleteMessage = String.valueOf(viewPointsToDeleteMessage) + ", ";
                }
                MessageDialog dialog = new MessageDialog(null, "Delete the selected View Points", null, "Are you sure to delete these View Points: " + viewPointsToDeleteMessage, 3, new String[]{"Yes", "No"}, 1);
                int result = dialog.open();
                if (result == 0) {
                    for (AbstractViewPoint viewPoint : ViewPointListComposite.this.getSelectedViewPoints()) {
                        try {
                            ApogyCommonTransactionFacade.INSTANCE.basicRemove(viewPoint.eContainer(), (EStructuralFeature)ApogyCoreEnvironmentPackage.Literals.VIEW_POINT_LIST__VIEW_POINTS, (Object)viewPoint);
                        }
                        catch (Exception e) {
                            Logger.error("Unable to delete the View Points <" + viewPoint.getName() + ">.", (Throwable)e);
                        }
                    }
                }
                if (!ViewPointListComposite.this.treeViewer.isBusy()) {
                    ViewPointListComposite.this.treeViewer.setInput((Object)ViewPointListComposite.this.getViewPointList());
                }
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ViewPointListComposite.this.m_bindingContext != null) {
                    ViewPointListComposite.this.m_bindingContext.dispose();
                }
            }
        });
    }

    public ViewPointList getViewPointList() {
        return this.viewPointList;
    }

    public void setViewPointList(ViewPointList viewPointList) {
        if (this.m_bindingContext != null) {
            this.m_bindingContext.dispose();
        }
        this.viewPointList = viewPointList;
        if (viewPointList != null) {
            this.m_bindingContext = this.customInitDataBindings();
        }
        this.treeViewer.setInput((Object)viewPointList);
    }

    public void setSelectedViewPoint(AbstractViewPoint viewPoint) {
        if (viewPoint != null) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)viewPoint), true);
            this.treeViewer.refresh();
        } else {
            this.treeViewer.setSelection(null);
        }
    }

    public List<AbstractViewPoint> getSelectedViewPoints() {
        return ((IStructuredSelection)this.treeViewer.getSelection()).toList();
    }

    protected void newViewPointSelected(AbstractViewPoint viewPoint) {
    }

    protected DataBindingContext customInitDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        IViewerObservableValue observeSingleSelectionViewer = ViewerProperties.singleSelection().observe((Viewer)this.treeViewer);
        ISWTObservableValue observeEnabledBtnDeleteObserveWidget = WidgetProperties.enabled().observe((Widget)this.btnDelete);
        bindingContext.bindValue((IObservableValue)observeEnabledBtnDeleteObserveWidget, (IObservableValue)observeSingleSelectionViewer, null, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(Object.class, Boolean.class){

            public Object convert(Object fromObject) {
                if (fromObject != null && ViewPointListComposite.this.getViewPointList().getViewPoints().size() > 0) {
                    return true;
                }
                return false;
            }
        }));
        return bindingContext;
    }

    private class ViewPointContentProvider
    implements ITreeContentProvider {
        private ViewPointContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ViewPointList) {
                return ((ViewPointList)inputElement).getViewPoints().toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }
}

