/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.ui.composites;

import java.util.Iterator;
import java.util.List;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.wizards.ApogyEObjectWizard;
import org.eclipse.apogy.core.ApogyCorePackage;
import org.eclipse.apogy.core.FeatureOfInterest;
import org.eclipse.apogy.core.FeatureOfInterestList;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureOfInterestListComposite
extends Composite {
    private static final Logger Logger = LoggerFactory.getLogger(FeatureOfInterestListComposite.class);
    private FeatureOfInterestList featureOfInterestList;
    private final Tree tree;
    private final TreeViewer treeViewer;
    private final Button btnNew;
    private final Button btnDelete;
    private final AdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private DataBindingContext m_bindingContext;

    public FeatureOfInterestListComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        this.treeViewer = new TreeViewer((Composite)this, 68354);
        this.tree = this.treeViewer.getTree();
        GridData gd_tree = new GridData(4, 4, false, true, 1, 1);
        gd_tree.widthHint = 300;
        gd_tree.minimumWidth = 300;
        this.tree.setLayoutData((Object)gd_tree);
        this.tree.setLinesVisible(true);
        this.treeViewer.setContentProvider((IContentProvider)new CompositeFilterContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory));
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FeatureOfInterestListComposite.this.newFeatureOfInterestSelected((FeatureOfInterest)((IStructuredSelection)event.getSelection()).getFirstElement());
            }
        });
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        composite.setLayout((Layout)new GridLayout(1, false));
        this.btnNew = new Button(composite, 0);
        this.btnNew.setSize(74, 29);
        this.btnNew.setText("New");
        this.btnNew.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnNew.setEnabled(true);
        this.btnNew.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 13) {
                    ApogyEObjectWizard wizard = new ApogyEObjectWizard(ApogyCorePackage.Literals.FEATURE_OF_INTEREST_LIST__FEATURES_OF_INTEREST, (EObject)FeatureOfInterestListComposite.this.getFeatureOfInterestList(), null, ApogyCorePackage.Literals.FEATURE_OF_INTEREST);
                    WizardDialog dialog = new WizardDialog(FeatureOfInterestListComposite.this.getShell(), (IWizard)wizard);
                    dialog.open();
                    if (!FeatureOfInterestListComposite.this.treeViewer.isBusy()) {
                        FeatureOfInterestListComposite.this.treeViewer.setInput((Object)FeatureOfInterestListComposite.this.getFeatureOfInterestList());
                    }
                }
            }
        });
        this.btnDelete = new Button(composite, 0);
        this.btnDelete.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnDelete.setSize(74, 29);
        this.btnDelete.setText("Delete");
        this.btnDelete.setEnabled(false);
        this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String foisToDeleteMessage = "";
                Iterator<FeatureOfInterest> foiList = FeatureOfInterestListComposite.this.getSelectedFeatureOfInterests().iterator();
                while (foiList.hasNext()) {
                    FeatureOfInterest foi = foiList.next();
                    foisToDeleteMessage = String.valueOf(foisToDeleteMessage) + foi.getName();
                    if (!foiList.hasNext()) continue;
                    foisToDeleteMessage = String.valueOf(foisToDeleteMessage) + ", ";
                }
                MessageDialog dialog = new MessageDialog(null, "Delete the selected Feature of Interests (FOI)", null, "Are you sure to delete these FOIs: " + foisToDeleteMessage, 3, new String[]{"Yes", "No"}, 1);
                int result = dialog.open();
                if (result == 0) {
                    for (FeatureOfInterest foi : FeatureOfInterestListComposite.this.getSelectedFeatureOfInterests()) {
                        try {
                            ApogyCommonTransactionFacade.INSTANCE.basicRemove(foi.eContainer(), (EStructuralFeature)ApogyCorePackage.Literals.FEATURE_OF_INTEREST_LIST__FEATURES_OF_INTEREST, (Object)foi);
                        }
                        catch (Exception e) {
                            Logger.error("Unable to delete the FOI <" + foi.getName() + ">", (Throwable)e);
                        }
                    }
                }
                if (!FeatureOfInterestListComposite.this.treeViewer.isBusy()) {
                    FeatureOfInterestListComposite.this.treeViewer.setInput((Object)FeatureOfInterestListComposite.this.getFeatureOfInterestList());
                }
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (FeatureOfInterestListComposite.this.m_bindingContext != null) {
                    FeatureOfInterestListComposite.this.m_bindingContext.dispose();
                }
            }
        });
    }

    public FeatureOfInterestList getFeatureOfInterestList() {
        return this.featureOfInterestList;
    }

    public void setFeatureOfInterestList(FeatureOfInterestList newFeatureOfInterestList) {
        if (this.m_bindingContext != null) {
            this.m_bindingContext.dispose();
        }
        this.featureOfInterestList = newFeatureOfInterestList;
        if (newFeatureOfInterestList != null) {
            this.m_bindingContext = this.customInitDataBindings();
            this.treeViewer.setInput((Object)newFeatureOfInterestList);
        }
    }

    public List<FeatureOfInterest> getSelectedFeatureOfInterests() {
        return ((IStructuredSelection)this.treeViewer.getSelection()).toList();
    }

    protected void newFeatureOfInterestSelected(FeatureOfInterest newFeatureOfInterest) {
    }

    protected DataBindingContext customInitDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        IViewerObservableValue observeSingleSelectionViewer = ViewerProperties.singleSelection().observe((Viewer)this.treeViewer);
        ISWTObservableValue observeEnabledBtnDeleteObserveWidget = WidgetProperties.enabled().observe((Widget)this.btnDelete);
        bindingContext.bindValue((IObservableValue)observeEnabledBtnDeleteObserveWidget, (IObservableValue)observeSingleSelectionViewer, null, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(Object.class, Boolean.class){

            public Object convert(Object fromObject) {
                if (fromObject != null) {
                    return true;
                }
                return false;
            }
        }));
        return bindingContext;
    }

    private class CompositeFilterContentProvider
    implements ITreeContentProvider {
        private CompositeFilterContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof FeatureOfInterestList) {
                FeatureOfInterestList featureOfInterestList = (FeatureOfInterestList)inputElement;
                return featureOfInterestList.getFeaturesOfInterest().toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof FeatureOfInterestList) {
                FeatureOfInterestList featureOfInterestList = (FeatureOfInterestList)parentElement;
                return featureOfInterestList.getFeaturesOfInterest().toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof FeatureOfInterestList) {
                FeatureOfInterestList featureOfInterestList = (FeatureOfInterestList)element;
                return !featureOfInterestList.getFeaturesOfInterest().isEmpty();
            }
            return false;
        }
    }
}

