/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.ui.composites;

import java.awt.Color;
import java.awt.Paint;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.math.Matrix4x4;
import org.eclipse.apogy.core.PoseProvider;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.experimental.chart.swt.ChartComposite;
import org.jfree.ui.RectangleInsets;

public class TrajectoryComposite
extends Composite {
    private PoseProvider movable = null;
    private Adapter movableAdapter;
    private Vector3d previousPosition = null;
    private final ChartComposite chartComposite;
    private JFreeChart chart;
    private XYPlot plot;
    private XYSeriesCollection xySeriesCollection;
    private XYSeries xySeries;
    private double maxX = Double.NEGATIVE_INFINITY;
    private double minX = Double.POSITIVE_INFINITY;
    private double maxY = Double.NEGATIVE_INFINITY;
    private double minY = Double.POSITIVE_INFINITY;

    public TrajectoryComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.setSize(200, 200);
        this.chartComposite = new ChartComposite((Composite)this, 0, this.getChart(), true);
        this.chartComposite.pack();
        this.chartComposite.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                TrajectoryComposite.this.squareOffGraph();
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (TrajectoryComposite.this.getMovable() != null) {
                    TrajectoryComposite.this.getMovable().eAdapters().remove((Object)TrajectoryComposite.this.getMovableAdapter());
                }
                TrajectoryComposite.this.getXYSeries().clear();
            }
        });
    }

    public void setMovable(PoseProvider newMovable) {
        if (this.movable != null) {
            this.movable.eAdapters().remove((Object)this.getMovableAdapter());
        }
        this.clearTrajectoryData();
        if (newMovable != null) {
            newMovable.eAdapters().add((Object)this.getMovableAdapter());
        }
        this.movable = newMovable;
    }

    public PoseProvider getMovable() {
        return this.movable;
    }

    public void clearTrajectoryData() {
        this.getXYSeries().clear();
        this.maxX = Double.NEGATIVE_INFINITY;
        this.minX = Double.POSITIVE_INFINITY;
        this.maxY = Double.NEGATIVE_INFINITY;
        this.minY = Double.POSITIVE_INFINITY;
    }

    protected JFreeChart getChart() {
        if (this.chart == null) {
            this.plot = new XYPlot((XYDataset)this.getXYSeriesCollection(), (ValueAxis)new NumberAxis("X (m)"), (ValueAxis)new NumberAxis("Y (m)"), (XYItemRenderer)new StandardXYItemRenderer());
            this.chart = new JFreeChart((Plot)this.plot);
            this.chart.removeLegend();
            this.chart.setAntiAlias(true);
            this.squareOffGraph();
        }
        return this.chart;
    }

    public XYSeries getXYSeries() {
        if (this.xySeries == null) {
            this.xySeries = new XYSeries((Comparable)((Object)"trajectory"), false, true);
        }
        return this.xySeries;
    }

    protected XYSeriesCollection getXYSeriesCollection() {
        if (this.xySeriesCollection == null) {
            this.xySeriesCollection = new XYSeriesCollection();
            this.xySeriesCollection.addSeries(this.getXYSeries());
        }
        return this.xySeriesCollection;
    }

    protected XYPlot createXYPlot() {
        XYPlot plot = new XYPlot((XYDataset)this.getXYSeriesCollection(), (ValueAxis)new NumberAxis("X (m)"), (ValueAxis)new NumberAxis("Y (m)"), (XYItemRenderer)new StandardXYItemRenderer());
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setDomainGridlinePaint((Paint)Color.black);
        plot.setRangeGridlinePaint((Paint)Color.black);
        plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        plot.setDomainCrosshairVisible(true);
        plot.setRangeCrosshairVisible(true);
        plot.setDomainMinorGridlinesVisible(true);
        plot.setRangeMinorGridlinesVisible(true);
        plot.setDomainGridlinesVisible(true);
        plot.setRangeGridlinesVisible(true);
        plot.getRangeAxis().setLowerBound(-1.0);
        plot.getRangeAxis().setUpperBound(1.0);
        plot.getRangeAxis().setAutoRange(false);
        plot.getDomainAxis().setLowerBound(-1.0);
        plot.getDomainAxis().setUpperBound(1.0);
        plot.getDomainAxis().setAutoRange(false);
        return plot;
    }

    private void squareOffGraph() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (TrajectoryComposite.this.chartComposite != null && !TrajectoryComposite.this.chartComposite.isDisposed()) {
                    double width = ((TrajectoryComposite)TrajectoryComposite.this).chartComposite.getSize().x;
                    double height = ((TrajectoryComposite)TrajectoryComposite.this).chartComposite.getSize().y;
                    ValueAxis xAxis = ((XYPlot)TrajectoryComposite.this.chart.getPlot()).getDomainAxis(0);
                    ValueAxis yAxis = ((XYPlot)TrajectoryComposite.this.chart.getPlot()).getRangeAxis(0);
                    double yLower = yAxis.getLowerBound();
                    double yUpper = yAxis.getUpperBound();
                    double xLower = xAxis.getLowerBound();
                    double xUpper = xAxis.getUpperBound();
                    if (width > height) {
                        double idealXRange = (yUpper - yLower) * width / height;
                        double currXRange = xUpper - xLower;
                        double xDelta = (idealXRange - currXRange) / 2.0;
                        if ((int)(xDelta * width) == 0) {
                            return;
                        }
                        xAxis.setLowerBound(xLower - xDelta);
                        xAxis.setUpperBound(xUpper + xDelta);
                    } else if (height > width) {
                        double idealYRange = (xUpper - xLower) * height / width;
                        double currYRange = yUpper - yLower;
                        double yDelta = (idealYRange - currYRange) / 2.0;
                        if ((int)(yDelta * height) == 0) {
                            return;
                        }
                        yAxis.setLowerBound(yLower - yDelta);
                        yAxis.setUpperBound(yUpper + yDelta);
                    }
                }
            }
        });
    }

    protected Adapter getMovableAdapter() {
        if (this.movableAdapter == null) {
            this.movableAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    super.notifyChanged(msg);
                    if (msg.getEventType() != 8 && msg.getFeatureID(PoseProvider.class) == 0 && msg.getNewValue() instanceof Matrix4x4) {
                        Matrix4x4 matrix4x4 = (Matrix4x4)msg.getNewValue();
                        final Vector3d position = new Vector3d();
                        matrix4x4.asMatrix4d().get(position);
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!TrajectoryComposite.this.chartComposite.isDisposed()) {
                                    double positionDelta = Double.MAX_VALUE;
                                    if (TrajectoryComposite.this.previousPosition != null) {
                                        Vector3d delta = new Vector3d();
                                        delta.sub((Tuple3d)position, (Tuple3d)TrajectoryComposite.this.previousPosition);
                                        positionDelta = delta.lengthSquared();
                                    }
                                    TrajectoryComposite.this.previousPosition = position;
                                    if (positionDelta > 0.0) {
                                        if (!TrajectoryComposite.this.chartComposite.isDisposed()) {
                                            TrajectoryComposite.this.xySeries.add(new XYDataItem(position.x, position.y));
                                        }
                                        boolean update = false;
                                        if (position.x < TrajectoryComposite.this.minX || TrajectoryComposite.this.minX == Double.POSITIVE_INFINITY) {
                                            TrajectoryComposite.this.minX = position.x;
                                            update = true;
                                        }
                                        if (position.x > TrajectoryComposite.this.maxX || TrajectoryComposite.this.maxX == Double.NEGATIVE_INFINITY) {
                                            TrajectoryComposite.this.maxX = position.x;
                                            if (TrajectoryComposite.this.maxX == TrajectoryComposite.this.minX) {
                                                TrajectoryComposite trajectoryComposite = TrajectoryComposite.this;
                                                trajectoryComposite.maxX = trajectoryComposite.maxX + 0.01;
                                            }
                                            update = true;
                                        }
                                        if (position.y < TrajectoryComposite.this.minY || TrajectoryComposite.this.minY == Double.POSITIVE_INFINITY) {
                                            TrajectoryComposite.this.minY = position.y;
                                            update = true;
                                        }
                                        if (position.y > TrajectoryComposite.this.maxY || TrajectoryComposite.this.maxY == Double.NEGATIVE_INFINITY) {
                                            TrajectoryComposite.this.maxY = position.y;
                                            if (TrajectoryComposite.this.maxY == TrajectoryComposite.this.minY) {
                                                TrajectoryComposite trajectoryComposite = TrajectoryComposite.this;
                                                trajectoryComposite.maxY = trajectoryComposite.maxY + 0.01;
                                            }
                                            update = true;
                                        }
                                        if (update) {
                                            double yRange;
                                            double width = ((TrajectoryComposite)(this).TrajectoryComposite.this).chartComposite.getSize().x;
                                            double height = ((TrajectoryComposite)(this).TrajectoryComposite.this).chartComposite.getSize().y;
                                            double aspectRatio = width / height;
                                            double xRange = TrajectoryComposite.this.maxX - TrajectoryComposite.this.minX;
                                            double rangeRatio = xRange / (yRange = TrajectoryComposite.this.maxY - TrajectoryComposite.this.minY);
                                            if (rangeRatio < aspectRatio) {
                                                double stretch = aspectRatio / rangeRatio;
                                                double xCenter = (TrajectoryComposite.this.minX + TrajectoryComposite.this.maxX) / 2.0;
                                                double lowerX = xCenter + (TrajectoryComposite.this.minX - xCenter) * stretch;
                                                double upperX = xCenter + (TrajectoryComposite.this.maxX - xCenter) * stretch;
                                                ValueAxis xAxis = ((XYPlot)TrajectoryComposite.this.chart.getPlot()).getDomainAxis(0);
                                                xAxis.setLowerBound(lowerX);
                                                xAxis.setUpperBound(upperX);
                                                ValueAxis yAxis = ((XYPlot)TrajectoryComposite.this.chart.getPlot()).getRangeAxis(0);
                                                yAxis.setLowerBound(TrajectoryComposite.this.minY);
                                                yAxis.setUpperBound(TrajectoryComposite.this.maxY);
                                            } else {
                                                double stretch = rangeRatio / aspectRatio;
                                                double yCenter = (TrajectoryComposite.this.minY + TrajectoryComposite.this.maxY) / 2.0;
                                                double lowerY = yCenter + (TrajectoryComposite.this.minY - yCenter) * stretch;
                                                double upperY = yCenter + (TrajectoryComposite.this.maxY - yCenter) * stretch;
                                                ValueAxis yAxis = ((XYPlot)TrajectoryComposite.this.chart.getPlot()).getRangeAxis(0);
                                                yAxis.setLowerBound(lowerY);
                                                yAxis.setUpperBound(upperY);
                                                ValueAxis xAxis = ((XYPlot)TrajectoryComposite.this.chart.getPlot()).getDomainAxis(0);
                                                xAxis.setLowerBound(TrajectoryComposite.this.minX);
                                                xAxis.setUpperBound(TrajectoryComposite.this.maxX);
                                            }
                                        }
                                    }
                                }
                            }
                        });
                    }
                }
            };
        }
        return this.movableAdapter;
    }
}

