/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.examples.satellite.ui.composites;

import org.eclipse.apogy.examples.satellite.AbstractConstellationRequest;
import org.eclipse.apogy.examples.satellite.ConstellationRequestsList;
import org.eclipse.apogy.examples.satellite.ConstellationRequestsListsContainer;
import org.eclipse.apogy.examples.satellite.ObservationConstellationRequest;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ConstellationRequestsComposite
extends Composite {
    private final FormToolkit toolkit = new FormToolkit(Display.getCurrent());
    private final TreeViewer requestsViewer;
    private final AdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private DataBindingContext m_bindingContext;
    private ConstellationRequestsListsContainer constellationRequestsListsContainer;
    private ISelectionChangedListener requestsViewerListener;

    public ConstellationRequestsComposite(Composite parent, int style) {
        super(parent, 0);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ConstellationRequestsComposite.this.toolkit.dispose();
            }
        });
        this.toolkit.adapt((Composite)this);
        this.toolkit.paintBordersFor((Composite)this);
        this.setLayout((Layout)new GridLayout(1, false));
        this.requestsViewer = new TreeViewer((Composite)this, 2816);
        this.requestsViewer.setUseHashlookup(true);
        Tree treeRequests = this.requestsViewer.getTree();
        treeRequests.setHeaderVisible(true);
        treeRequests.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        treeRequests.setLinesVisible(true);
        TreeViewerColumn treeViewerColumnUID = new TreeViewerColumn(this.requestsViewer, 0);
        TreeColumn treeclmnUID = treeViewerColumnUID.getColumn();
        treeclmnUID.setWidth(150);
        treeclmnUID.setText("UID");
        treeclmnUID.setToolTipText("Refers to the constellation Request Unique Identifier.");
        TreeViewerColumn treeViewerColumnType = new TreeViewerColumn(this.requestsViewer, 0);
        TreeColumn treeclmnType = treeViewerColumnType.getColumn();
        treeclmnType.setWidth(150);
        treeclmnType.setText("Type");
        treeclmnType.setToolTipText("Refers to the constellation Request type.");
        TreeViewerColumn treeViewerPriority = new TreeViewerColumn(this.requestsViewer, 0);
        TreeColumn treeclmnPriority = treeViewerPriority.getColumn();
        treeclmnPriority.setWidth(100);
        treeclmnPriority.setText("Priority");
        treeclmnPriority.setToolTipText("Specifies the priority level the constellation request.");
        TreeViewerColumn treeViewerColumnStatus = new TreeViewerColumn(this.requestsViewer, 0);
        TreeColumn treeclmnStatus = treeViewerColumnStatus.getColumn();
        treeclmnStatus.setWidth(100);
        treeclmnStatus.setText("Status");
        treeclmnStatus.setToolTipText("Actual execution status of the constellation Request.");
        TreeViewerColumn treeViewerLongitude = new TreeViewerColumn(this.requestsViewer, 0);
        TreeColumn treeclmnLongitude = treeViewerLongitude.getColumn();
        treeclmnLongitude.setWidth(150);
        treeclmnLongitude.setText("Longitude (\u00b0)");
        treeclmnLongitude.setToolTipText("Specifies the observation request longitude.");
        TreeViewerColumn treeViewerLatitude = new TreeViewerColumn(this.requestsViewer, 0);
        TreeColumn treeclmnLatitude = treeViewerLatitude.getColumn();
        treeclmnLatitude.setWidth(150);
        treeclmnLatitude.setText("Latitude (\u00b0)");
        treeclmnLatitude.setToolTipText("Specifies the observation request latitude in degrees.");
        TreeViewerColumn treeViewerElevation = new TreeViewerColumn(this.requestsViewer, 0);
        TreeColumn treeclmnElevation = treeViewerElevation.getColumn();
        treeclmnElevation.setWidth(150);
        treeclmnElevation.setText("Elevation (m)");
        treeclmnElevation.setToolTipText("Specifies the observation request altitude in meters.");
        this.requestsViewer.setContentProvider((IContentProvider)new RequestsContentProvider(this.adapterFactory));
        this.requestsViewer.setLabelProvider((IBaseLabelProvider)new RequestsLabelProvider(this.adapterFactory));
        this.requestsViewer.addSelectionChangedListener(this.getViewerListener());
        Menu contextMenu = new Menu((Control)treeRequests);
        this.requestsViewer.getTree().setMenu(contextMenu);
        TreeColumn[] treeColumnArray = this.requestsViewer.getTree().getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            final TreeColumn tableColumn = treeColumnArray[n2];
            final MenuItem itemName = new MenuItem(contextMenu, 32);
            itemName.setText(tableColumn.getText());
            itemName.setSelection(tableColumn.getResizable());
            itemName.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (itemName.getSelection()) {
                        tableColumn.setWidth(150);
                        tableColumn.setResizable(true);
                    } else {
                        tableColumn.setWidth(0);
                        tableColumn.setResizable(false);
                    }
                }
            });
            ++n2;
        }
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ConstellationRequestsComposite.this.m_bindingContext != null) {
                    ConstellationRequestsComposite.this.m_bindingContext.dispose();
                }
            }
        });
    }

    public void setConstellationRequestsListsContainer(ConstellationRequestsListsContainer constellationRequestsListsContainer) {
        this.constellationRequestsListsContainer = constellationRequestsListsContainer;
        if (this.m_bindingContext != null) {
            this.m_bindingContext.dispose();
            this.m_bindingContext = null;
        }
        if (this.constellationRequestsListsContainer != null) {
            this.m_bindingContext = this.initDataBindings();
        }
    }

    private DataBindingContext initDataBindings() {
        return this.initDataBindingsCustom();
    }

    private DataBindingContext initDataBindingsCustom() {
        DataBindingContext bindingContext = new DataBindingContext();
        if (this.constellationRequestsListsContainer != null) {
            this.requestsViewer.setInput((Object)this.constellationRequestsListsContainer);
        }
        return bindingContext;
    }

    public void dispose() {
        super.dispose();
        if (this.m_bindingContext != null) {
            this.m_bindingContext.dispose();
            this.m_bindingContext = null;
        }
        this.requestsViewer.removeSelectionChangedListener(this.getViewerListener());
    }

    protected void newSelection(ISelection selection) {
    }

    private ISelectionChangedListener getViewerListener() {
        if (this.requestsViewerListener == null) {
            this.requestsViewerListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ConstellationRequestsComposite.this.newSelection(event.getSelection());
                }
            };
        }
        return this.requestsViewerListener;
    }

    public class ActivitiesViewerComparator
    extends ViewerComparator {
    }

    private class RequestsContentProvider
    extends AdapterFactoryContentProvider {
        public RequestsContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Object[] getChildren(Object object) {
            Object[] children = null;
            if (object instanceof ConstellationRequestsList) {
                children = super.getChildren(object);
            }
            return children;
        }

        public boolean hasChildren(Object object) {
            return object instanceof ConstellationRequestsList ? super.hasChildren(object) : false;
        }
    }

    private class RequestsLabelProvider
    extends AdapterFactoryLabelProvider
    implements ITableLabelProvider {
        private static final int UID_COLUMN_ID = 0;
        private static final int TYPE_COLUMN_ID = 1;
        private static final int PRIORITY_COLUMN_ID = 2;
        private static final int STATUS_COLUMN_ID = 3;
        private static final int LONGITUDE_COLUMN_ID = 4;
        private static final int LATITUDE_COLUMN_ID = 5;
        private static final int ELEVATION_COLUMN_ID = 6;

        public RequestsLabelProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public String getColumnText(Object object, int columnIndex) {
            String str = "<undefined>";
            if (object instanceof ConstellationRequestsList) {
                ConstellationRequestsList list = (ConstellationRequestsList)object;
                if (columnIndex == 0) {
                    if (list.getName() != null) {
                        str = list.getName();
                    }
                } else {
                    str = "";
                }
            }
            if (object instanceof AbstractConstellationRequest) {
                AbstractConstellationRequest request = (AbstractConstellationRequest)object;
                switch (columnIndex) {
                    case 0: {
                        if (request.getUid() == null) break;
                        str = request.getUid().toString();
                        break;
                    }
                    case 2: {
                        str = request.getOrderPriority().getName();
                        break;
                    }
                    case 3: {
                        str = request.getOrderStatus().getName();
                        break;
                    }
                    case 1: {
                        str = request.eClass().getName();
                        break;
                    }
                    case 4: {
                        if (!(request instanceof ObservationConstellationRequest)) break;
                        ObservationConstellationRequest observationRequest = (ObservationConstellationRequest)request;
                        str = observationRequest.getLocation() == null ? "N/A" : Double.toString(observationRequest.getLocation().getLongitude());
                        break;
                    }
                    case 5: {
                        if (!(request instanceof ObservationConstellationRequest)) break;
                        ObservationConstellationRequest observationRequest = (ObservationConstellationRequest)request;
                        str = observationRequest.getLocation() == null ? "N/A" : Double.toString(observationRequest.getLocation().getLatitude());
                        break;
                    }
                    case 6: {
                        if (!(request instanceof ObservationConstellationRequest)) break;
                        ObservationConstellationRequest observationRequest = (ObservationConstellationRequest)request;
                        str = observationRequest.getLocation() == null ? "N/A" : Double.toString(observationRequest.getLocation().getElevation());
                        break;
                    }
                }
            }
            return str;
        }

        public Image getColumnImage(Object object, int columnIndex) {
            return null;
        }
    }
}

