/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.imaging.camera.wizards;

import org.eclipse.apogy.addons.sensors.imaging.camera.ImageFrozenOverlay;
import org.eclipse.apogy.addons.sensors.imaging.camera.composites.ImageFrozenOverlayComposite;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ImageFrozenOverlayWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.addons.sensors.imaging.camera.wizards.EMFFeatureOverlayWizardPage";
    private final ImageFrozenOverlay imageFrozenOverlay;
    private ImageFrozenOverlayComposite imageFrozenOverlayComposite;
    private DataBindingContext m_bindingContext;

    public ImageFrozenOverlayWizardPage(ImageFrozenOverlay imageFrozenOverlay) {
        super(WIZARD_PAGE_ID);
        this.imageFrozenOverlay = imageFrozenOverlay;
        this.setTitle("Image Frozen Overlay.");
        this.setDescription("Select Expected Update Period and Frozen message.");
        this.validate();
    }

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(1, false));
        this.imageFrozenOverlayComposite = new ImageFrozenOverlayComposite(top, 2048){

            @Override
            protected void newExpectedImageUpdatePeriodSelected(double expectedImageUpdatePeriod) {
                ImageFrozenOverlayWizardPage.this.validate();
            }

            @Override
            protected void newFrozenMessageSelected(String frozenMessage) {
                ImageFrozenOverlayWizardPage.this.validate();
            }
        };
        this.imageFrozenOverlayComposite.setLayoutData(new GridData(4, 4, true, true));
        this.imageFrozenOverlayComposite.setImageFrozenOverlay(this.imageFrozenOverlay);
        this.setControl((Control)top);
        this.m_bindingContext = this.initDataBindingsCustom();
        top.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ImageFrozenOverlayWizardPage.this.m_bindingContext != null) {
                    ImageFrozenOverlayWizardPage.this.m_bindingContext.dispose();
                }
            }
        });
    }

    protected void validate() {
        this.setErrorMessage(null);
        if (this.imageFrozenOverlay.getExpectedImageUpdatePeriod() <= 0.0) {
            this.setErrorMessage("The Expected Image Refresh Period specified is invalid ! It should be greater tahn zero.");
        }
        if (this.imageFrozenOverlay.getFrozenMessage() == null || this.imageFrozenOverlay.getFrozenMessage().length() == 0) {
            this.setErrorMessage("The Frozen Message is empty !");
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    private DataBindingContext initDataBindingsCustom() {
        DataBindingContext bindingContext = new DataBindingContext();
        return bindingContext;
    }
}

