/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.vehicle.impl;

import org.eclipse.apogy.addons.vehicle.impl.ThrusterImpl;

public class ThrusterCustomImpl
extends ThrusterImpl {
    @Override
    public void setMinimumThrust(double newMinimumThrust) {
        super.setMinimumThrust(newMinimumThrust);
        this.updateThrustLevel();
    }

    @Override
    public void setMaximumThrust(double newMaximumThrust) {
        super.setMaximumThrust(newMaximumThrust);
        this.updateThrustLevel();
    }

    @Override
    public void setCurrentThrust(double newCurrentThrust) {
        if (newCurrentThrust < this.getMinimumThrust()) {
            super.setCurrentThrust(this.getMinimumThrust());
        } else if (newCurrentThrust > this.getMaximumThrust()) {
            super.setCurrentThrust(this.getMaximumThrust());
        } else {
            super.setCurrentThrust(newCurrentThrust);
        }
        this.updateThrustLevel();
    }

    private void updateThrustLevel() {
        double newThrustLevel = this.getCurrentThrust() / this.getMaximumThrust();
        if (newThrustLevel < 0.0) {
            newThrustLevel = 0.0;
        } else if (newThrustLevel > 1.0) {
            newThrustLevel = 1.0;
        }
        this.setThrustLevel(newThrustLevel);
    }
}

