/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.composites;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.apogy.common.databinding.converters.DateToStringConverter;
import org.eclipse.apogy.common.emf.ApogyCommonEMFPackage;
import org.eclipse.apogy.common.emf.BrowseableTimeSource;
import org.eclipse.apogy.common.emf.TimeSource;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.composites.AbstractTimeSourceComposite;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public class BrowseableTimeSourceComposite
extends AbstractTimeSourceComposite {
    protected BrowseableTimeSource browseableTimeSource;
    protected DataBindingContext bindingContext;
    protected Spinner updatePeriodSpinner;
    protected Spinner timeAccelerationSpinner;
    protected Label startTimeValueLabel;
    protected DateTime dateWidget;
    protected DateTime timeWidget;
    protected Button setStartTimeButton;
    protected Button playReverseButton;
    protected Button playPauseButton;
    protected Button playForwardButton;
    protected Button playResetButton;

    public BrowseableTimeSourceComposite(Composite parent, int style) {
        this(parent, style, null);
    }

    public BrowseableTimeSourceComposite(Composite parent, int style, BrowseableTimeSource acceleratedTimeSource) {
        super(parent, style);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (BrowseableTimeSourceComposite.this.bindingContext != null) {
                    BrowseableTimeSourceComposite.this.bindingContext.dispose();
                }
            }
        });
        this.createContent();
        this.setBrowseableTimeSource(acceleratedTimeSource);
    }

    protected void createContent() {
        Composite top = new Composite((Composite)this, 0);
        top.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout gl_top = new GridLayout(1, true);
        gl_top.marginWidth = 0;
        gl_top.marginHeight = 0;
        top.setLayout((Layout)gl_top);
        Composite setupComposite = this.createSettingsComposite(top, 0);
        setupComposite.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Composite buttonsComposite = this.createButtonsComposite(top, 0);
        buttonsComposite.setLayoutData((Object)new GridData(4, 128, true, true, 1, 1));
        Composite startTimeComposite = this.createStartTimeComposite(top, 0);
        startTimeComposite.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
    }

    @Override
    public void activate(boolean active) {
        if (this.updatePeriodSpinner != null) {
            this.updatePeriodSpinner.setEnabled(active);
        }
        if (this.timeAccelerationSpinner != null) {
            this.timeAccelerationSpinner.setEnabled(active);
        }
        if (this.startTimeValueLabel != null) {
            this.startTimeValueLabel.setEnabled(active);
        }
        if (this.dateWidget != null) {
            this.dateWidget.setEnabled(active);
        }
        if (this.timeWidget != null) {
            this.timeWidget.setEnabled(active);
        }
        if (this.setStartTimeButton != null) {
            this.setStartTimeButton.setEnabled(active);
        }
        if (this.playReverseButton != null) {
            this.playReverseButton.setEnabled(active);
        }
        if (this.playPauseButton != null) {
            this.playPauseButton.setEnabled(active);
        }
        if (this.playForwardButton != null) {
            this.playForwardButton.setEnabled(active);
        }
        if (this.playResetButton != null) {
            this.playResetButton.setEnabled(active);
        }
    }

    @Override
    public TimeSource getTimeSource() {
        return this.getBrowseableTimeSource();
    }

    public BrowseableTimeSource getBrowseableTimeSource() {
        return this.browseableTimeSource;
    }

    public void setBrowseableTimeSource(BrowseableTimeSource acceleratedTimeSource) {
        this.setBrowseableTimeSource(acceleratedTimeSource, true);
    }

    public void setBrowseableTimeSource(BrowseableTimeSource acceleratedTimeSource, boolean update) {
        this.browseableTimeSource = acceleratedTimeSource;
        if (update) {
            if (this.bindingContext != null) {
                this.bindingContext.dispose();
                this.bindingContext = null;
            }
            if (acceleratedTimeSource != null) {
                this.bindingContext = this.initDataBindings();
                int periodDigits = this.updatePeriodSpinner.getDigits();
                this.updatePeriodSpinner.setSelection((int)Math.round(Math.pow(10.0, periodDigits) * (double)acceleratedTimeSource.getUpdatePeriod() * 0.001));
                int accelerationDigits = this.timeAccelerationSpinner.getDigits();
                this.timeAccelerationSpinner.setSelection((int)Math.round(Math.pow(10.0, accelerationDigits) * (double)acceleratedTimeSource.getTimeAcceration()));
            }
        }
        super.setTimeSource((TimeSource)acceleratedTimeSource);
    }

    protected Composite createStartTimeComposite(Composite parent, int style) {
        Composite startTimeComposite = new Composite(parent, 0);
        startTimeComposite.setLayout((Layout)new GridLayout(2, false));
        Label startTimeLabel = new Label(startTimeComposite, 0);
        startTimeLabel.setText("Start Time : ");
        this.startTimeValueLabel = new Label(startTimeComposite, 0);
        this.startTimeValueLabel.setText("?");
        GridData startTimeValueLabelGridData = new GridData(16384, 0x1000000, false, false);
        startTimeValueLabelGridData.widthHint = 250;
        startTimeValueLabelGridData.minimumWidth = 250;
        this.startTimeValueLabel.setLayoutData((Object)startTimeValueLabelGridData);
        this.dateWidget = new DateTime(startTimeComposite, 1024);
        this.dateWidget.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        this.timeWidget = new DateTime(startTimeComposite, 0x10000880);
        this.timeWidget.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        this.setStartTimeButton = new Button(startTimeComposite, 8);
        this.setStartTimeButton.setLayoutData((Object)new GridData(0x1000000, 128, false, false, 2, 1));
        this.setStartTimeButton.setText("Set Start Time");
        this.setStartTimeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (BrowseableTimeSourceComposite.this.getBrowseableTimeSource() != null) {
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)BrowseableTimeSourceComposite.this.getBrowseableTimeSource(), (EStructuralFeature)ApogyCommonEMFPackage.Literals.BROWSEABLE_TIME_SOURCE__START_TIME, (Object)BrowseableTimeSourceComposite.this.getSelectedStartDate());
                }
            }
        });
        return startTimeComposite;
    }

    protected Composite createSettingsComposite(Composite parent, int style) {
        Composite settingsComposite = new Composite(parent, style);
        settingsComposite.setLayout((Layout)new GridLayout(4, true));
        Label updatePeriodLabel = new Label(settingsComposite, 0);
        updatePeriodLabel.setText("Update period (s):");
        this.updatePeriodSpinner = new Spinner(settingsComposite, 2048);
        GridData updatePeriodSpinnerGridData = new GridData(16384, 0x1000000, false, false, 1, 1);
        updatePeriodSpinnerGridData.widthHint = 100;
        updatePeriodSpinnerGridData.minimumWidth = 100;
        this.updatePeriodSpinner.setLayoutData((Object)updatePeriodSpinnerGridData);
        this.updatePeriodSpinner.setDigits(3);
        this.updatePeriodSpinner.setMinimum(1);
        this.updatePeriodSpinner.setMaximum(60000);
        this.updatePeriodSpinner.setIncrement(1);
        this.updatePeriodSpinner.setSelection(1000);
        this.updatePeriodSpinner.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int selection = BrowseableTimeSourceComposite.this.updatePeriodSpinner.getSelection();
                int digits = BrowseableTimeSourceComposite.this.updatePeriodSpinner.getDigits();
                int period = (int)Math.round((double)selection / Math.pow(10.0, digits) * 1000.0);
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)BrowseableTimeSourceComposite.this.getBrowseableTimeSource(), (EStructuralFeature)ApogyCommonEMFPackage.Literals.BROWSEABLE_TIME_SOURCE__UPDATE_PERIOD, (Object)period);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label timeAccelerationLabel = new Label(settingsComposite, 0);
        timeAccelerationLabel.setText("Time Acceleration:");
        this.timeAccelerationSpinner = new Spinner(settingsComposite, 2048);
        GridData timeAccelerationSpinnerGridData = new GridData(16384, 0x1000000, false, false, 1, 1);
        timeAccelerationSpinnerGridData.widthHint = 100;
        timeAccelerationSpinnerGridData.minimumWidth = 100;
        this.timeAccelerationSpinner.setLayoutData((Object)timeAccelerationSpinnerGridData);
        this.timeAccelerationSpinner.setDigits(1);
        this.timeAccelerationSpinner.setMinimum(1);
        this.timeAccelerationSpinner.setMaximum(100000);
        this.timeAccelerationSpinner.setIncrement(1);
        this.timeAccelerationSpinner.setSelection(100);
        this.timeAccelerationSpinner.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int selection = BrowseableTimeSourceComposite.this.timeAccelerationSpinner.getSelection();
                int digits = BrowseableTimeSourceComposite.this.timeAccelerationSpinner.getDigits();
                float acceleration = (float)((double)selection / Math.pow(10.0, digits));
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)BrowseableTimeSourceComposite.this.getBrowseableTimeSource(), (EStructuralFeature)ApogyCommonEMFPackage.Literals.BROWSEABLE_TIME_SOURCE__TIME_ACCERATION, (Object)Float.valueOf(acceleration));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return settingsComposite;
    }

    protected Composite createButtonsComposite(Composite parent, int style) {
        Composite buttonsComposite = new Composite(parent, style);
        buttonsComposite.setLayout((Layout)new GridLayout(4, false));
        this.playResetButton = new Button(buttonsComposite, 8);
        GridData resetButtonGridData = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        resetButtonGridData.minimumWidth = 75;
        resetButtonGridData.widthHint = 75;
        this.playResetButton.setLayoutData((Object)resetButtonGridData);
        this.playResetButton.setText("Reset");
        this.playResetButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (BrowseableTimeSourceComposite.this.getBrowseableTimeSource() != null) {
                    BrowseableTimeSourceComposite.this.getBrowseableTimeSource().reset();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.playReverseButton = new Button(buttonsComposite, 8);
        GridData reverseButtonGridData = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        reverseButtonGridData.minimumWidth = 75;
        reverseButtonGridData.widthHint = 75;
        this.playReverseButton.setLayoutData((Object)reverseButtonGridData);
        this.playReverseButton.setText("Reverse");
        this.playReverseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (BrowseableTimeSourceComposite.this.getBrowseableTimeSource() != null) {
                    BrowseableTimeSourceComposite.this.getBrowseableTimeSource().playReverse();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.playPauseButton = new Button(buttonsComposite, 8);
        GridData pauseButtonGridData = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        pauseButtonGridData.minimumWidth = 75;
        pauseButtonGridData.widthHint = 75;
        this.playPauseButton.setLayoutData((Object)pauseButtonGridData);
        this.playPauseButton.setText("Pause");
        this.playPauseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (BrowseableTimeSourceComposite.this.getBrowseableTimeSource() != null) {
                    BrowseableTimeSourceComposite.this.getBrowseableTimeSource().pause();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.playForwardButton = new Button(buttonsComposite, 8);
        GridData forwardButtonGridData = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        forwardButtonGridData.minimumWidth = 75;
        forwardButtonGridData.widthHint = 75;
        this.playForwardButton.setLayoutData((Object)forwardButtonGridData);
        this.playForwardButton.setText("Forward");
        this.playForwardButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (BrowseableTimeSourceComposite.this.getBrowseableTimeSource() != null) {
                    BrowseableTimeSourceComposite.this.getBrowseableTimeSource().playForward();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return buttonsComposite;
    }

    protected Date getSelectedStartDate() {
        Date date = null;
        if (this.dateWidget != null && this.timeWidget != null) {
            int year = this.dateWidget.getYear();
            int month = this.dateWidget.getMonth();
            int day = this.dateWidget.getDay();
            int hrs = this.timeWidget.getHours();
            int min = this.timeWidget.getMinutes();
            int sec = this.timeWidget.getSeconds();
            GregorianCalendar calendar = new GregorianCalendar(year, month, day, hrs, min, sec);
            date = calendar.getTime();
        }
        return date;
    }

    protected void setStartDate(Date date) {
        if (date != null) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(date);
            if (this.dateWidget != null) {
                this.dateWidget.setDate(calendar.get(1), calendar.get(2), calendar.get(5));
                this.dateWidget.redraw();
            }
            if (this.timeWidget != null) {
                this.timeWidget.setHours(calendar.get(11));
                this.timeWidget.setMinutes(calendar.get(12));
                this.timeWidget.setSeconds(calendar.get(13));
            }
        }
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        if (this.startTimeValueLabel != null) {
            IObservableValue startTimeLabelValue = PojoProperties.value((String)"text").observe((Object)this.startTimeValueLabel);
            IObservableValue startTimeObserveValue = EMFProperties.value((FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCommonEMFPackage.Literals.BROWSEABLE_TIME_SOURCE__START_TIME})).observe((Object)this.getBrowseableTimeSource());
            UpdateValueStrategy startTimeValueStrategy = new UpdateValueStrategy();
            startTimeValueStrategy.setConverter((IConverter)new DateToStringConverter(new SimpleDateFormat("yyyy.MM.dd HH:mm:ss.SSS z")));
            bindingContext.bindValue(startTimeLabelValue, startTimeObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), startTimeValueStrategy);
        }
        return bindingContext;
    }
}

