/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.common.ApogyCommonOSGiUtilities;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.EClassSettings;
import org.eclipse.apogy.common.emf.ui.WizardPagesProvider;
import org.eclipse.apogy.common.emf.ui.WizardPagesProviderRegistry;
import org.eclipse.apogy.common.emf.ui.wizards.ChooseEClassImplementationWizardPage;
import org.eclipse.apogy.common.ui.ApogyCommonUiFacade;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApogyEObjectWizard
extends Wizard {
    private static final Logger Logger = LoggerFactory.getLogger(ApogyEObjectWizard.class);
    private ChooseEClassImplementationWizardPage chooseEClassImplementationWizardPage;
    private EReference eReference;
    private EObject parent;
    private EClassSettings settings;
    private EClass eClass;
    private List<EClass> displayedEClasses;
    private WizardPagesProvider pagesProvider;
    private List<WizardPage> providedWizardPages;
    private boolean openWizard = true;

    public ApogyEObjectWizard(EReference eReference, EObject parent, EClassSettings settings, EClass eClass) {
        this.setWindowTitle("New Child");
        this.setNeedsProgressMonitor(true);
        this.setForcePreviousAndNextButtons(true);
        ImageDescriptor image = AbstractUIPlugin.imageDescriptorFromPlugin((String)ApogyCommonOSGiUtilities.INSTANCE.getBundleSymbolicName(((Object)((Object)this)).getClass()), (String)"icons/wizban/emf_new_child.png");
        this.setDefaultPageImageDescriptor(image);
        if (eReference == null || parent == null) {
            Logger.error("No reference or parent set in wizard");
            this.openWizard = false;
            return;
        }
        this.eReference = eReference;
        this.parent = parent;
        this.settings = settings;
        this.displayedEClasses = new ArrayList<EClass>();
        if (eClass == null || !eReference.getEReferenceType().isSuperTypeOf(eClass)) {
            this.eClass = eReference.getEReferenceType();
            this.displayedEClasses = this.verifyEClass(this.eClass);
        } else {
            this.eClass = eClass;
            this.displayedEClasses.addAll(ApogyCommonEMFFacade.INSTANCE.sortAlphabetically(ApogyCommonEMFFacade.INSTANCE.getAllSubEClasses(this.eClass)));
        }
        if (this.displayedEClasses.isEmpty()) {
            Logger.error("No concrete class settable in " + this.eReference.getName());
            this.openWizard = false;
        } else if (this.displayedEClasses.size() == 1) {
            this.pagesProvider = WizardPagesProviderRegistry.INSTANCE.getProvider(this.eClass);
            this.providedWizardPages = this.pagesProvider.getPages(this.displayedEClasses.get(0), settings);
            if (this.providedWizardPages.isEmpty()) {
                this.openWizard = false;
            }
        }
    }

    public void addPages() {
        if (this.providedWizardPages != null) {
            for (WizardPage page : this.providedWizardPages) {
                this.addPage((IWizardPage)page);
            }
        } else {
            this.addPage((IWizardPage)this.getChooseEClassImplementationWizardPage());
        }
        if (this.getPages().length > 0) {
            ApogyCommonUiFacade.INSTANCE.adjustWizardPage((WizardPage)this.getPages()[0], Double.valueOf(0.5));
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.getChooseEClassImplementationWizardPage()) {
            if (this.getChooseEClassImplementationWizardPage().getSelectedEClass() != null) {
                if (this.providedWizardPages != null) {
                    return this.providedWizardPages.isEmpty() ? null : (IWizardPage)this.providedWizardPages.get(0);
                }
                return null;
            }
            return null;
        }
        return this.pagesProvider.getNextPage(page);
    }

    protected ChooseEClassImplementationWizardPage getChooseEClassImplementationWizardPage() {
        if (this.chooseEClassImplementationWizardPage == null) {
            this.chooseEClassImplementationWizardPage = new ChooseEClassImplementationWizardPage(this.displayedEClasses){

                @Override
                protected void newSelection(TreeSelection selection) {
                    if (selection.getFirstElement() instanceof EClass) {
                        ApogyEObjectWizard.this.eClass = (EClass)selection.getFirstElement();
                        ApogyEObjectWizard.this.pagesProvider = WizardPagesProviderRegistry.INSTANCE.getProvider(ApogyEObjectWizard.this.eClass);
                        ApogyEObjectWizard.this.providedWizardPages = ApogyEObjectWizard.this.pagesProvider.getPages(ApogyEObjectWizard.this.eClass, ApogyEObjectWizard.this.settings);
                        for (WizardPage page : ApogyEObjectWizard.this.providedWizardPages) {
                            ApogyEObjectWizard.this.addPage((IWizardPage)page);
                        }
                    }
                }
            };
        }
        return this.chooseEClassImplementationWizardPage;
    }

    public boolean openWizard() {
        return this.openWizard;
    }

    public EReference getEReference() {
        return this.eReference;
    }

    public EObject getCreatedEObject() {
        return this.pagesProvider.getEObject();
    }

    public boolean performFinish() {
        if (this.pagesProvider != null) {
            EObject eObject = this.pagesProvider.getEObject();
            eObject.eResource().getResourceSet().getResources().remove((Object)eObject.eResource());
            TransactionUtil.disconnectFromEditingDomain((Resource)eObject.eResource());
            Object command = this.eReference.isMany() ? new AddCommand((EditingDomain)TransactionUtil.getEditingDomain((EObject)this.parent), this.parent, (EStructuralFeature)this.eReference, (Object)eObject) : new SetCommand((EditingDomain)TransactionUtil.getEditingDomain((EObject)this.parent), this.parent, (EStructuralFeature)this.eReference, (Object)eObject);
            CompoundCommand compoundCommand = new CompoundCommand();
            compoundCommand.append((Command)command);
            CompoundCommand usersCommand = this.pagesProvider.getPerformFinishCommands(eObject, this.settings, (EditingDomain)TransactionUtil.getEditingDomain((EObject)this.parent));
            if (usersCommand != null) {
                if (usersCommand.canExecute()) {
                    compoundCommand.append((Command)usersCommand);
                } else {
                    Logger.error("The compound command returned by <" + this.pagesProvider.getClass().getName() + "> is not executable.");
                }
            }
            TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((EObject)this.parent);
            boolean tempED = false;
            if (transactionalEditingDomain == null) {
                transactionalEditingDomain = ApogyCommonTransactionFacade.INSTANCE.getDefaultEditingDomain();
                ApogyCommonTransactionFacade.INSTANCE.addInTempTransactionalEditingDomain(this.parent);
                tempED = true;
            }
            transactionalEditingDomain.getCommandStack().execute((Command)compoundCommand);
            if (tempED) {
                ApogyCommonTransactionFacade.INSTANCE.removeFromEditingDomain(this.parent);
            }
        }
        return true;
    }

    public boolean canFinish() {
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if ((page instanceof ChooseEClassImplementationWizardPage || this.providedWizardPages.contains(page)) && !page.isPageComplete()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private List<EClass> verifyEClass(EClass eClass) {
        if (!this.getEReference().getEReferenceType().isSuperTypeOf(eClass)) {
            Logger.error(eClass + " is not settable in reference");
            eClass = this.getEReference().getEReferenceType();
        }
        List subClasses = ApogyCommonEMFFacade.INSTANCE.getAllSubEClasses(eClass);
        return subClasses;
    }
}

