/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.impl;

import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFacade;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFactory;
import org.eclipse.apogy.common.geometry.data3d.CartesianCoordinatesSet;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangle;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.apogy.common.geometry.data3d.impl.DelaunayMesherImpl;
import org.eclipse.apogy.common.math.quickhull3d.QuickHull3D;

public class DelaunayMesherCustomImpl
extends DelaunayMesherImpl {
    public CartesianTriangularMesh process(CartesianCoordinatesSet input) throws Exception {
        Vector3d[] inputPoints = new Vector3d[input.getPoints().size()];
        int i = 0;
        for (CartesianPositionCoordinates point : input.getPoints()) {
            double newZ;
            inputPoints[i] = new Vector3d((Tuple3d)point.asPoint3d());
            inputPoints[i].z = 0.0;
            inputPoints[i].z = newZ = inputPoints[i].lengthSquared();
            ++i;
        }
        long t0 = System.currentTimeMillis();
        QuickHull3D qhull = new QuickHull3D(inputPoints);
        qhull.triangulate();
        int[][] faces = qhull.getFaces();
        long t1 = System.currentTimeMillis();
        System.out.println("DelaunayMesherImpl.process() time to compute triangulation: " + (t1 - t0));
        CartesianTriangularMesh mesh = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianTriangularMesh();
        for (CartesianPositionCoordinates point : input.getPoints()) {
            double x = point.getX();
            double y = point.getY();
            double z = point.getZ();
            CartesianPositionCoordinates copy = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(x, y, z);
            mesh.getPoints().add((Object)copy);
        }
        i = 0;
        while (i < faces.length) {
            if (faces[i].length == 3 && this.isLower(faces[i], inputPoints) && faces[i].length == 3) {
                CartesianPositionCoordinates p0 = (CartesianPositionCoordinates)mesh.getPoints().get(faces[i][0]);
                CartesianPositionCoordinates p1 = (CartesianPositionCoordinates)mesh.getPoints().get(faces[i][1]);
                CartesianPositionCoordinates p2 = (CartesianPositionCoordinates)mesh.getPoints().get(faces[i][2]);
                CartesianTriangle triangle = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianTriangle(p2, p1, p0);
                mesh.getPolygons().add((Object)triangle);
            }
            ++i;
        }
        return mesh;
    }

    private boolean isLower(int[] face, Vector3d[] data) {
        Vector3d v0 = new Vector3d(data[face[1]]);
        Vector3d v1 = new Vector3d(data[face[2]]);
        v0.sub((Tuple3d)data[face[0]]);
        v1.sub((Tuple3d)data[face[0]]);
        Vector3d res = new Vector3d();
        res.cross(v0, v1);
        return res.z < 0.0;
    }
}

