/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.impl;

import java.util.ArrayList;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangle;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.apogy.common.geometry.data3d.Geometry3DUtilities;
import org.eclipse.apogy.common.geometry.data3d.impl.TriangleEdgeLengthTriangularMeshFilterImpl;

public class TriangleEdgeLengthTriangularMeshFilterCustomImpl
extends TriangleEdgeLengthTriangularMeshFilterImpl {
    public CartesianTriangularMesh process(CartesianTriangularMesh input) throws Exception {
        this.setInput(input);
        CartesianTriangularMesh filteredMesh = this.filter(input);
        this.setOutput(filteredMesh);
        return filteredMesh;
    }

    @Override
    public CartesianTriangularMesh filter(CartesianTriangularMesh input) {
        Matrix4d identity = new Matrix4d();
        identity.setIdentity();
        CartesianTriangularMesh output = Geometry3DUtilities.createTransformedCartesianTriangularMesh(identity, input);
        ArrayList<CartesianTriangle> trianglesToRemove = new ArrayList<CartesianTriangle>();
        for (CartesianTriangle triangle : output.getPolygons()) {
            Point3d center = triangle.getCentroid().asPoint3d();
            double range = Math.sqrt(center.x * center.x + center.y * center.y);
            if (!(this.getMinimumRange() <= range) || !(range <= this.getMaximumRange())) continue;
            int i = 0;
            while (i < 2) {
                Point3d p0 = ((CartesianPositionCoordinates)triangle.getVertices().get(i)).asPoint3d();
                p0.z = 0.0;
                Point3d p1 = ((CartesianPositionCoordinates)triangle.getVertices().get(i + 1)).asPoint3d();
                p1.z = 0.0;
                double edgeLength = p0.distance(p1);
                if (edgeLength > this.getMaximumEdgeLength()) {
                    trianglesToRemove.add(triangle);
                }
                ++i;
            }
        }
        output.getPolygons().removeAll(trianglesToRemove);
        return output;
    }
}

