/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.images.impl;

import com.jhlabs.image.ContrastFilter;
import com.jhlabs.image.EdgeFilter;
import com.jhlabs.image.ExposureFilter;
import com.jhlabs.image.FlipFilter;
import com.jhlabs.image.GainFilter;
import com.jhlabs.image.GrayscaleFilter;
import com.jhlabs.image.InvertFilter;
import com.jhlabs.image.RescaleFilter;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.images.ApogyCommonImagesFactory;
import org.eclipse.apogy.common.images.EImage;
import org.eclipse.apogy.common.images.EImagesUtilities;
import org.eclipse.apogy.common.images.ImageAlignment;
import org.eclipse.apogy.common.images.ImageSize;
import org.eclipse.apogy.common.images.impl.EImagesUtilitiesImpl;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EImagesUtilitiesCustomImpl
extends EImagesUtilitiesImpl {
    private static final Logger Logger = LoggerFactory.getLogger(EImagesUtilitiesImpl.class);

    @Override
    public AbstractEImage copy(AbstractEImage originalImage) {
        EImage copy = ApogyCommonImagesFactory.eINSTANCE.createEImage();
        if (originalImage.asBufferedImage() != null) {
            BufferedImage b = new BufferedImage(originalImage.getWidth(), originalImage.getHeight(), 2);
            Graphics g = b.getGraphics();
            g.drawImage(originalImage.asBufferedImage(), 0, 0, null);
            g.dispose();
            copy.setImageContent(b);
        }
        return copy;
    }

    @Override
    public AbstractEImage convertToGrayScale(AbstractEImage originalImage) {
        GrayscaleFilter grayscaleFilter = new GrayscaleFilter();
        int width = originalImage.getWidth();
        int height = originalImage.getHeight();
        BufferedImage sourceImage = originalImage.asBufferedImage();
        BufferedImage destinationImage = new BufferedImage(width, height, 2);
        grayscaleFilter.setDimensions(width, height);
        grayscaleFilter.filter(sourceImage, destinationImage);
        EImage grayScaleImage = ApogyCommonImagesFactory.eINSTANCE.createEImage();
        grayScaleImage.setImageContent(destinationImage);
        return grayScaleImage;
    }

    @Override
    public AbstractEImage resize(AbstractEImage originalImage, double scaleFactor) {
        if (scaleFactor <= 0.0) {
            throw new RuntimeException("ScaleFactor must be greater than zero !");
        }
        return this.resize(originalImage, scaleFactor, scaleFactor);
    }

    @Override
    public AbstractEImage resize(AbstractEImage originalImage, double widthScaleFactor, double heightScaleFactor) {
        if (widthScaleFactor <= 0.0) {
            throw new RuntimeException("WidthScaleFactor must be greater than zero !");
        }
        if (heightScaleFactor <= 0.0) {
            throw new RuntimeException("HeightScaleFactor must be greater than zero !");
        }
        int height = (int)Math.round(heightScaleFactor * (double)originalImage.getHeight());
        int width = (int)Math.round(widthScaleFactor * (double)originalImage.getWidth());
        return this.resize(originalImage, width, height);
    }

    @Override
    public AbstractEImage resize(AbstractEImage originalImage, int newWidth, int newHeight) {
        if (newWidth <= 0) {
            throw new RuntimeException("newWidth must be greater than zero !");
        }
        if (newHeight <= 0) {
            throw new RuntimeException("newHeight must be greater than zero !");
        }
        Image image = originalImage.asBufferedImage().getScaledInstance(newWidth, newHeight, 4);
        BufferedImage result = new BufferedImage(newWidth, newHeight, 2);
        Graphics2D g2d = result.createGraphics();
        g2d.drawImage(image, 0, 0, null);
        EImage scaledImage = ApogyCommonImagesFactory.eINSTANCE.createEImage();
        scaledImage.setImageContent(result);
        g2d.dispose();
        return scaledImage;
    }

    @Override
    public AbstractEImage createTransparentImage(int width, int height) {
        return this.createUniformColorImage(width, height, 0, 0, 0, 0);
    }

    @Override
    public AbstractEImage createUniformColorImage(int width, int height, int red, int green, int blue, int alpha) {
        BufferedImage bufferedImage = new BufferedImage(width, height, 2);
        Graphics2D g = bufferedImage.createGraphics();
        g.setColor(new Color(red, green, blue, alpha));
        g.fillRect(0, 0, width, height);
        EImage eImage = ApogyCommonImagesFactory.eINSTANCE.createEImage();
        eImage.setImageContent(bufferedImage);
        return eImage;
    }

    @Override
    public AbstractEImage applyAlpha(AbstractEImage originalImage, float alpha) {
        BufferedImage bufferedImage = new BufferedImage(originalImage.getWidth(), originalImage.getHeight(), 2);
        Graphics2D g2d = bufferedImage.createGraphics();
        g2d.setComposite(AlphaComposite.getInstance(3, alpha));
        g2d.drawImage((Image)originalImage.asBufferedImage(), 0, 0, null);
        EImage eImage = ApogyCommonImagesFactory.eINSTANCE.createEImage();
        eImage.setImageContent(bufferedImage);
        return eImage;
    }

    @Override
    public AbstractEImage applyEdgeFilter(AbstractEImage originalImage) {
        EdgeFilter filter = new EdgeFilter();
        int width = originalImage.getWidth();
        int height = originalImage.getHeight();
        BufferedImage sourceImage = originalImage.asBufferedImage();
        BufferedImage destinationImage = new BufferedImage(width, height, 2);
        filter.filter(sourceImage, destinationImage);
        EImage filteredImage = ApogyCommonImagesFactory.eINSTANCE.createEImage();
        filteredImage.setImageContent(destinationImage);
        return filteredImage;
    }

    @Override
    public AbstractEImage applyContrastAndBrightnessFilter(AbstractEImage originalImage, double contrast, double brightness) {
        ContrastFilter filter = new ContrastFilter();
        filter.setContrast((float)contrast);
        filter.setBrightness((float)brightness);
        int width = originalImage.getWidth();
        int height = originalImage.getHeight();
        BufferedImage sourceImage = originalImage.asBufferedImage();
        BufferedImage destinationImage = new BufferedImage(width, height, 2);
        filter.filter(sourceImage, destinationImage);
        EImage filteredImage = ApogyCommonImagesFactory.eINSTANCE.createEImage();
        filteredImage.setImageContent(destinationImage);
        return filteredImage;
    }

    @Override
    public AbstractEImage applyExposureFilter(AbstractEImage originalImage, double exposure) {
        ExposureFilter filter = new ExposureFilter();
        filter.setExposure((float)exposure);
        int width = originalImage.getWidth();
        int height = originalImage.getHeight();
        BufferedImage sourceImage = originalImage.asBufferedImage();
        BufferedImage destinationImage = new BufferedImage(width, height, 2);
        filter.filter(sourceImage, destinationImage);
        EImage filteredImage = ApogyCommonImagesFactory.eINSTANCE.createEImage();
        filteredImage.setImageContent(destinationImage);
        return filteredImage;
    }

    @Override
    public AbstractEImage applyInvertFilter(AbstractEImage originalImage) {
        InvertFilter filter = new InvertFilter();
        int width = originalImage.getWidth();
        int height = originalImage.getHeight();
        BufferedImage sourceImage = originalImage.asBufferedImage();
        BufferedImage destinationImage = new BufferedImage(width, height, 2);
        filter.filter(sourceImage, destinationImage);
        EImage filteredImage = ApogyCommonImagesFactory.eINSTANCE.createEImage();
        filteredImage.setImageContent(destinationImage);
        return filteredImage;
    }

    @Override
    public AbstractEImage applyRescaleFilter(AbstractEImage originalImage, double scale) {
        RescaleFilter filter = new RescaleFilter();
        filter.setScale((float)scale);
        int width = originalImage.getWidth();
        int height = originalImage.getHeight();
        BufferedImage sourceImage = originalImage.asBufferedImage();
        BufferedImage destinationImage = new BufferedImage(width, height, 2);
        filter.filter(sourceImage, destinationImage);
        EImage filteredImage = ApogyCommonImagesFactory.eINSTANCE.createEImage();
        filteredImage.setImageContent(destinationImage);
        return filteredImage;
    }

    @Override
    public AbstractEImage applyGainFilter(AbstractEImage originalImage, double gain, double bias) {
        GainFilter filter = new GainFilter();
        filter.setGain((float)gain);
        filter.setBias((float)bias);
        int width = originalImage.getWidth();
        int height = originalImage.getHeight();
        BufferedImage sourceImage = originalImage.asBufferedImage();
        BufferedImage destinationImage = new BufferedImage(width, height, 2);
        filter.filter(sourceImage, destinationImage);
        EImage filteredImage = ApogyCommonImagesFactory.eINSTANCE.createEImage();
        filteredImage.setImageContent(destinationImage);
        return filteredImage;
    }

    @Override
    public AbstractEImage createTextImage(String text, Font font, Color textColor, Color backgroundColor, int borderWidth) {
        Rectangle2D imageRectangle = EImagesUtilitiesCustomImpl.getRawTextImageSize(text, font);
        int w = (int)Math.ceil(imageRectangle.getWidth()) + borderWidth * 2;
        int h = (int)Math.ceil(imageRectangle.getHeight()) + borderWidth * 2;
        BufferedImage img = EImagesUtilities.INSTANCE.createUniformColorImage(w, h, backgroundColor.getRed(), backgroundColor.getGreen(), backgroundColor.getBlue(), backgroundColor.getAlpha()).asBufferedImage();
        Graphics g = img.getGraphics();
        g.setColor(textColor);
        g.setFont(font);
        FontMetrics fm = g.getFontMetrics();
        int x = img.getWidth() - fm.stringWidth(text) - borderWidth;
        int y = fm.getHeight() - fm.getDescent() + borderWidth;
        g.drawString(text, x, y);
        g.dispose();
        EImage image = ApogyCommonImagesFactory.eINSTANCE.createEImage();
        image.setImageContent(img);
        return image;
    }

    private static Rectangle2D getRawTextImageSize(String text, Font font) {
        BufferedImage img = new BufferedImage(1, 1, 6);
        Graphics g = img.getGraphics();
        g.setFont(font);
        FontRenderContext frc = g.getFontMetrics().getFontRenderContext();
        Rectangle2D rect = font.getStringBounds(text, frc);
        g.dispose();
        return rect;
    }

    @Override
    public void saveImageAsJPEG(String destinationFilePath, AbstractEImage image) throws Exception {
        File file = new File(destinationFilePath);
        ImageIO.write((RenderedImage)image.asBufferedImage(), "jpg", file);
    }

    @Override
    public void saveImageAsPNG(String destinationFilePath, AbstractEImage image) throws Exception {
        File file = new File(destinationFilePath);
        ImageIO.write((RenderedImage)image.asBufferedImage(), "png", file);
    }

    @Override
    public AbstractEImage applyOverlay(AbstractEImage originalImage, AbstractEImage overlayImage, boolean allowOverlayResize) {
        if (overlayImage != null && overlayImage.asBufferedImage() != null) {
            BufferedImage result = new BufferedImage(originalImage.getWidth(), originalImage.getHeight(), 2);
            BufferedImage overlay = overlayImage.asBufferedImage();
            if (allowOverlayResize) {
                overlay = this.resize(overlayImage, originalImage.getWidth(), originalImage.getHeight()).asBufferedImage();
            }
            Graphics2D g2d = result.createGraphics();
            g2d.drawImage((Image)originalImage.asBufferedImage(), 0, 0, null);
            g2d.drawImage((Image)overlay, 0, 0, null);
            EImage resultImage = ApogyCommonImagesFactory.eINSTANCE.createEImage();
            resultImage.setImageContent(result);
            g2d.dispose();
            return resultImage;
        }
        return this.copy(originalImage);
    }

    @Override
    public AbstractEImage flipHorizontal(AbstractEImage originalImage) {
        FlipFilter flipFilter = new FlipFilter(1);
        int width = originalImage.getWidth();
        int height = originalImage.getHeight();
        BufferedImage sourceImage = originalImage.asBufferedImage();
        BufferedImage destinationImage = new BufferedImage(width, height, 2);
        flipFilter.filter(sourceImage, destinationImage);
        EImage flippedImage = ApogyCommonImagesFactory.eINSTANCE.createEImage();
        flippedImage.setImageContent(destinationImage);
        return flippedImage;
    }

    @Override
    public AbstractEImage flipVertical(AbstractEImage originalImage) {
        FlipFilter flipFilter = new FlipFilter(2);
        int width = originalImage.getWidth();
        int height = originalImage.getHeight();
        BufferedImage sourceImage = originalImage.asBufferedImage();
        BufferedImage destinationImage = new BufferedImage(width, height, 2);
        flipFilter.filter(sourceImage, destinationImage);
        EImage flippedImage = ApogyCommonImagesFactory.eINSTANCE.createEImage();
        flippedImage.setImageContent(destinationImage);
        return flippedImage;
    }

    @Override
    public ImageSize getAllEncompassingImageSize(List<? extends AbstractEImage> images) {
        ImageSize imageSize = ApogyCommonImagesFactory.eINSTANCE.createImageSize();
        for (AbstractEImage abstractEImage : images) {
            if (abstractEImage.getWidth() > imageSize.getWidth()) {
                imageSize.setWidth(abstractEImage.getWidth());
            }
            if (abstractEImage.getHeight() <= imageSize.getHeight()) continue;
            imageSize.setHeight(abstractEImage.getHeight());
        }
        return imageSize;
    }

    @Override
    public AbstractEImage superPoseImages(List<? extends AbstractEImage> images, boolean allowImageResize, ImageAlignment alignment) {
        ImageSize resultImageSize = this.getAllEncompassingImageSize(images);
        AbstractEImage result = this.createTransparentImage(resultImageSize.getWidth(), resultImageSize.getHeight());
        for (AbstractEImage abstractEImage : images) {
            result = this.superPoseImages(result, abstractEImage, allowImageResize, alignment);
        }
        return result;
    }

    @Override
    public AbstractEImage superPoseImages(AbstractEImage imageA, AbstractEImage imageB, boolean allowImageResize, ImageAlignment alignment) {
        AbstractEImage imageBCopy = imageB;
        if (allowImageResize) {
            imageBCopy = this.resize(imageB, imageA.getWidth(), imageA.getHeight());
        }
        BufferedImage result = new BufferedImage(imageA.getWidth(), imageA.getHeight(), 2);
        Graphics2D g2d = result.createGraphics();
        int imageOffsetX = 0;
        int imageOffsetY = 0;
        int imageWidth = imageBCopy.getWidth();
        int imageHeight = imageBCopy.getHeight();
        if (imageBCopy.getHeight() > imageA.getHeight()) {
            imageHeight = imageA.getHeight();
        }
        if (imageBCopy.getWidth() > imageA.getWidth()) {
            imageWidth = imageA.getWidth();
        }
        switch (alignment.getValue()) {
            case 1: {
                imageOffsetX = Math.round((float)(imageA.getWidth() - imageWidth) * 0.5f);
                imageOffsetY = Math.round((float)(imageA.getHeight() - imageHeight) * 0.5f);
                break;
            }
            case 2: {
                imageOffsetX = 0;
                imageOffsetY = Math.round(imageA.getHeight() - imageHeight);
                break;
            }
            case 3: {
                imageOffsetX = 0;
                imageOffsetY = 0;
                break;
            }
            case 4: {
                imageOffsetX = Math.round(imageA.getWidth() - imageWidth);
                imageOffsetY = Math.round(imageA.getHeight() - imageHeight);
                break;
            }
            case 5: {
                imageOffsetX = Math.round(imageA.getWidth() - imageWidth);
                imageOffsetY = 0;
                break;
            }
        }
        g2d.drawImage((Image)imageA.asBufferedImage(), 0, 0, null);
        g2d.drawImage((Image)imageBCopy.asBufferedImage(), imageOffsetX, imageOffsetY, null);
        g2d.dispose();
        EImage resultImage = ApogyCommonImagesFactory.eINSTANCE.createEImage();
        resultImage.setImageContent(result);
        g2d.dispose();
        return resultImage;
    }

    @Override
    public AbstractEImage addBorder(AbstractEImage originalImage, int borderWidth, int red, int green, int blue) {
        BufferedImage result = this.copy(originalImage).asBufferedImage();
        Graphics2D g2d = result.createGraphics();
        if (borderWidth > 0) {
            Color color = new Color(red, green, blue);
            g2d.setColor(color);
            g2d.setStroke(new BasicStroke(1.0f));
            int x0 = 0;
            int x1 = originalImage.getWidth() - 1;
            int y0 = 0;
            int y1 = originalImage.getHeight() - 1;
            int i = 0;
            while (i < borderWidth) {
                g2d.drawLine(x0, y0, x1, y0);
                g2d.drawLine(x1, y0, x1, y1);
                g2d.drawLine(x1, y1, x0, y1);
                g2d.drawLine(x0, y1, x0, y0);
                ++x0;
                --x1;
                ++y0;
                --y1;
                ++i;
            }
            g2d.dispose();
        }
        EImage resultImage = ApogyCommonImagesFactory.eINSTANCE.createEImage();
        resultImage.setImageContent(result);
        return resultImage;
    }

    @Override
    public AbstractEImage getSubImage(AbstractEImage originalImage, int widthOffset, int heightOffset, int subImageWidth, int subImageHeight) throws Exception {
        if (originalImage.getHeight() > heightOffset && originalImage.getWidth() > widthOffset) {
            BufferedImage result = new BufferedImage(subImageWidth, subImageHeight, 2);
            Graphics2D g2d = result.createGraphics();
            g2d.drawImage(originalImage.asBufferedImage(), 0, 0, subImageWidth, subImageHeight, widthOffset, heightOffset, widthOffset + subImageWidth, heightOffset + subImageWidth, null);
            EImage resultImage = ApogyCommonImagesFactory.eINSTANCE.createEImage();
            resultImage.setImageContent(result);
            g2d.dispose();
            return resultImage;
        }
        throw new IllegalArgumentException("Specified offsets are outside the original image !");
    }

    @Override
    public AbstractEImage rotate(AbstractEImage originalImage, double angle, boolean enableImageResize) {
        BufferedImage sourceImage = originalImage.asBufferedImage();
        int w = sourceImage.getWidth();
        int h = sourceImage.getHeight();
        if (enableImageResize) {
            Point2D size = this.getResultingRectangleSizeForRotatedImage(w, h, angle);
            int newWidth = (int)Math.round(size.getX());
            int newHeight = (int)Math.round(size.getY());
            BufferedImage rot = new BufferedImage(newWidth, newHeight, 2);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(newWidth / 2, newHeight / 2);
            affineTransform.rotate(angle);
            affineTransform.translate(-w / 2, -h / 2);
            Graphics2D g = rot.createGraphics();
            g.drawImage(sourceImage, affineTransform, null);
            g.dispose();
            EImage filteredImage = ApogyCommonImagesFactory.eINSTANCE.createEImage();
            filteredImage.setImageContent(rot);
            return filteredImage;
        }
        BufferedImage rot = new BufferedImage(h, w, 2);
        AffineTransform xform = AffineTransform.getRotateInstance(angle, w / 2, h / 2);
        Graphics2D g = rot.createGraphics();
        g.drawImage(sourceImage, xform, null);
        g.dispose();
        EImage filteredImage = ApogyCommonImagesFactory.eINSTANCE.createEImage();
        filteredImage.setImageContent(rot);
        return filteredImage;
    }

    @Override
    public AbstractEImage translate(AbstractEImage originalImage, int widthTranslation, int heightTranslation) {
        int newWidth = originalImage.getWidth() + Math.abs(widthTranslation);
        int newHeight = originalImage.getHeight() + Math.abs(heightTranslation);
        AbstractEImage result = this.createTransparentImage(newWidth, newHeight);
        ImageAlignment imageAlignment = ImageAlignment.CENTER;
        imageAlignment = widthTranslation > 0 ? (heightTranslation > 0 ? ImageAlignment.LOWER_RIGHT_CORNER : ImageAlignment.UPPER_RIGHT_CORNER) : (heightTranslation > 0 ? ImageAlignment.LOWER_LEFT_CORNER : ImageAlignment.UPPER_LEFT_CORNER);
        result = this.superPoseImages(result, originalImage, false, imageAlignment);
        return result;
    }

    private Point2D getResultingRectangleSizeForRotatedImage(int w, int h, double angle) {
        double halfWidth = (double)w * 0.5;
        double halfheight = (double)h * 0.5;
        ArrayList<Point2D> corners = new ArrayList<Point2D>();
        corners.add(new Point2D.Double(-halfWidth, -halfheight));
        corners.add(new Point2D.Double(-halfWidth, halfheight));
        corners.add(new Point2D.Double(halfWidth, halfheight));
        corners.add(new Point2D.Double(halfWidth, -halfheight));
        List<Point2D> rotatedCorners = this.applyRotation(corners, angle);
        double width = 0.0;
        double height = 0.0;
        for (Point2D p : rotatedCorners) {
            if (Math.abs(p.getX()) > width) {
                width = Math.abs(p.getX());
            }
            if (!(Math.abs(p.getY()) > height)) continue;
            height = Math.abs(p.getY());
        }
        return new Point2D.Double(width * 2.0, height * 2.0);
    }

    private List<Point2D> applyRotation(List<Point2D> points, double angle) {
        ArrayList<Point2D> results = new ArrayList<Point2D>();
        AffineTransform rotation = AffineTransform.getRotateInstance(angle);
        for (Point2D p : points) {
            Point2D.Double result = new Point2D.Double();
            rotation.transform(p, result);
            results.add(result);
        }
        return results;
    }

    @Override
    public BufferedImage convertToBufferedImage(ImageData data) {
        ColorModel colorModel = null;
        PaletteData palette = data.palette;
        if (palette.isDirect) {
            colorModel = new DirectColorModel(data.depth, palette.redMask, palette.greenMask, palette.blueMask);
            BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(data.width, data.height), false, null);
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    int pixel = data.getPixel(x, y);
                    RGB rgb = palette.getRGB(pixel);
                    bufferedImage.setRGB(x, y, rgb.red << 16 | rgb.green << 8 | rgb.blue);
                    ++x;
                }
                ++y;
            }
            return bufferedImage;
        }
        RGB[] rgbs = palette.getRGBs();
        byte[] red = new byte[rgbs.length];
        byte[] green = new byte[rgbs.length];
        byte[] blue = new byte[rgbs.length];
        int i = 0;
        while (i < rgbs.length) {
            RGB rgb = rgbs[i];
            red[i] = (byte)rgb.red;
            green[i] = (byte)rgb.green;
            blue[i] = (byte)rgb.blue;
            ++i;
        }
        colorModel = data.transparentPixel != -1 ? new IndexColorModel(data.depth, rgbs.length, red, green, blue, data.transparentPixel) : new IndexColorModel(data.depth, rgbs.length, red, green, blue);
        BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(data.width, data.height), false, null);
        WritableRaster raster = bufferedImage.getRaster();
        int[] pixelArray = new int[1];
        int y = 0;
        while (y < data.height) {
            int x = 0;
            while (x < data.width) {
                int pixel;
                pixelArray[0] = pixel = data.getPixel(x, y);
                raster.setPixel(x, y, pixelArray);
                ++x;
            }
            ++y;
        }
        return bufferedImage;
    }

    @Override
    public ImageData convertToImageData(BufferedImage bufferedImage) {
        if (bufferedImage.getColorModel() instanceof DirectColorModel) {
            DirectColorModel colorModel = (DirectColorModel)bufferedImage.getColorModel();
            PaletteData palette = new PaletteData(colorModel.getRedMask(), colorModel.getGreenMask(), colorModel.getBlueMask());
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    int rgb = bufferedImage.getRGB(x, y);
                    int pixel = palette.getPixel(new RGB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF));
                    data.setPixel(x, y, pixel);
                    if (colorModel.hasAlpha()) {
                        data.setAlpha(x, y, rgb >> 24 & 0xFF);
                    }
                    ++x;
                }
                ++y;
            }
            return data;
        }
        if (bufferedImage.getColorModel() instanceof IndexColorModel) {
            IndexColorModel colorModel = (IndexColorModel)bufferedImage.getColorModel();
            int size = colorModel.getMapSize();
            byte[] reds = new byte[size];
            byte[] greens = new byte[size];
            byte[] blues = new byte[size];
            colorModel.getReds(reds);
            colorModel.getGreens(greens);
            colorModel.getBlues(blues);
            RGB[] rgbs = new RGB[size];
            int i = 0;
            while (i < rgbs.length) {
                rgbs[i] = new RGB(reds[i] & 0xFF, greens[i] & 0xFF, blues[i] & 0xFF);
                ++i;
            }
            PaletteData palette = new PaletteData(rgbs);
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            data.transparentPixel = colorModel.getTransparentPixel();
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[1];
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    raster.getPixel(x, y, pixelArray);
                    data.setPixel(x, y, pixelArray[0]);
                    ++x;
                }
                ++y;
            }
            return data;
        }
        try {
            File tempFile = File.createTempFile("convertToImageData", "png");
            ImageIO.write((RenderedImage)bufferedImage, "png", tempFile);
            FileInputStream inputStream = new FileInputStream(tempFile);
            ImageData imageData = new ImageData((InputStream)inputStream);
            tempFile.deleteOnExit();
            return imageData;
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

