/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.ui.viewer;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum MouseButton implements Enumerator
{
    LEFT(0, "LEFT", "LEFT"),
    MIDDLE(1, "MIDDLE", "MIDDLE"),
    RIGHT(2, "RIGHT", "RIGHT");

    public static final int LEFT_VALUE = 0;
    public static final int MIDDLE_VALUE = 1;
    public static final int RIGHT_VALUE = 2;
    private static final MouseButton[] VALUES_ARRAY;
    public static final List<MouseButton> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new MouseButton[]{LEFT, MIDDLE, RIGHT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static MouseButton get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MouseButton result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MouseButton getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MouseButton result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MouseButton get(int value) {
        switch (value) {
            case 0: {
                return LEFT;
            }
            case 1: {
                return MIDDLE;
            }
            case 2: {
                return RIGHT;
            }
        }
        return null;
    }

    private MouseButton(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

