/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.examples.camera.apogy.impl;

import javax.vecmath.Matrix4d;
import org.eclipse.apogy.addons.sensors.fov.ApogyAddonsSensorsFOVFacade;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Matrix4x4;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.core.invocator.AbstractInitializationData;
import org.eclipse.apogy.core.invocator.OperationCall;
import org.eclipse.apogy.examples.camera.PTUCamera;
import org.eclipse.apogy.examples.camera.apogy.ApogyExamplesCameraApogyFactory;
import org.eclipse.apogy.examples.camera.apogy.PTUCameraData;
import org.eclipse.apogy.examples.camera.apogy.impl.PTUCameraApogySystemApiAdapterImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PTUCameraApogySystemApiAdapterCustomImpl
extends PTUCameraApogySystemApiAdapterImpl {
    private static final Logger Logger = LoggerFactory.getLogger(PTUCameraApogySystemApiAdapterImpl.class);

    protected PTUCamera getPTUCamera() {
        return (PTUCamera)this.getInstance();
    }

    public AbstractInitializationData createInitializationData() {
        return ApogyExamplesCameraApogyFactory.eINSTANCE.createPTUCameraData();
    }

    public void apply(AbstractInitializationData initializationData) {
        super.apply(initializationData);
        if (initializationData instanceof PTUCameraData) {
            PTUCameraData ptuCameraData = (PTUCameraData)initializationData;
            if (ptuCameraData.isInitialized()) {
                if (!this.getPTUCamera().isInitialized()) {
                    this.getPTUCamera().init();
                }
                this.getPTUCamera().commandZoom(ptuCameraData.getZoom());
                this.getPTUCamera().moveToPanTilt(ptuCameraData.getPanAngle(), ptuCameraData.getTiltAngle());
                if (ptuCameraData.getFov() != null) {
                    this.getPTUCamera().setFov(ApogyAddonsSensorsFOVFacade.INSTANCE.createRectangularFrustrumFieldOfView(ptuCameraData.getFov()));
                } else {
                    this.getPTUCamera().setFov(null);
                }
            } else if (this.getPTUCamera().isInitialized()) {
                String message = "The given initialization data cannot be applied to this PTU camera; the given init data says that the camera should not be initialized, when it already is in that state.";
                throw new RuntimeException(message);
            }
        }
    }

    public void collect(AbstractInitializationData initializationData) {
        super.collect(initializationData);
        if (initializationData instanceof PTUCameraData) {
            PTUCameraData ptuCameraData = (PTUCameraData)initializationData;
            if (this.getPTUCamera().getFov() != null) {
                ptuCameraData.setFov(ApogyAddonsSensorsFOVFacade.INSTANCE.createRectangularFrustrumFieldOfView(this.getPTUCamera().getFov()));
            } else {
                ptuCameraData.setFov(null);
            }
            ptuCameraData.setZoom(this.getPTUCamera().getCurrentZoom());
            ptuCameraData.setPanAngle(this.getPTUCamera().getCurrentPanAngle());
            ptuCameraData.setTiltAngle(this.getPTUCamera().getCurrentTiltAngle());
            ptuCameraData.setInitialized(this.getPTUCamera().isInitialized());
        }
    }

    public Matrix4x4 createResultMatrix(OperationCall operationCall) {
        if (operationCall.getEOperation().getOperationID() == 1) {
            Node tip = (Node)ApogyCommonTopologyFacade.INSTANCE.findNodesByID("PTU_CAMERA_SYM_SYS_LENS", this.getApogySystem().getTopologyRoot().getOriginNode()).get(0);
            Node root = (Node)ApogyCommonTopologyFacade.INSTANCE.findNodesByID("PTU_CAMERA_SYM_SYS_ROOT", this.getApogySystem().getTopologyRoot().getOriginNode()).get(0);
            Matrix4d matrix4d = ApogyCommonTopologyFacade.INSTANCE.expressInFrame(tip, root);
            return ApogyCommonMathFacade.INSTANCE.createMatrix4x4(matrix4d);
        }
        return super.createResultMatrix(operationCall);
    }

    public void dispose() {
        try {
            if (this.getPTUCamera().isStreamingEnabled()) {
                this.getPTUCamera().commandStreaming(false);
            }
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), (Throwable)e);
        }
        super.dispose();
    }
}

