/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.examples.camera.impl;

import org.eclipse.apogy.examples.camera.impl.PTUCameraStubImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PTUCameraStubCustomImpl
extends PTUCameraStubImpl {
    private static final Logger Logger = LoggerFactory.getLogger(PTUCameraStubImpl.class);
    private static final String DEGREE_SYM = "\u00b0";

    @Override
    public boolean init() {
        Logger.info("Just a stub - the necessary initialization for the PTU camera would have taken place.");
        return true;
    }

    @Override
    public double getMaximumPanAngle() {
        Logger.info("Just a stub - the largest allowed pan angle would have been returned.");
        return this.getCurrentPanAngle();
    }

    @Override
    public double getMinimumPanAngle() {
        Logger.info(".getMinimumPanAngle(): Just a stub - the smallest allowed pan angle would have been returned.");
        return this.getCurrentPanAngle();
    }

    @Override
    public double getMaximumTiltAngle() {
        Logger.info("Just a stub - the largest allowed tilt angle would have been returned.");
        return this.getCurrentTiltAngle();
    }

    @Override
    public double getMinimumTiltAngle() {
        Logger.info("Just a stub - the smallest allowed tilt angle would have been returned.");
        return this.getCurrentTiltAngle();
    }

    @Override
    public boolean moveToPanTilt(double panAngle, double tiltAngle) {
        Logger.info("moveToPanTilt(" + Math.toDegrees(panAngle) + DEGREE_SYM + ", " + Math.toDegrees(tiltAngle) + DEGREE_SYM + "): Just a stub - " + "the camera's PTU would have moved " + "to the specified pan and tilt angles.");
        return true;
    }

    @Override
    public boolean moveToPan(double panAngle) {
        Logger.info("moveToPan(" + Math.toDegrees(panAngle) + DEGREE_SYM + "): Just a stub - " + "the camera's PTU would have moved to the specified pan angle.");
        return true;
    }

    @Override
    public boolean moveToTilt(double tiltAngle) {
        Logger.info("moveToTilt(" + Math.toDegrees(tiltAngle) + DEGREE_SYM + "): Just a stub - " + "the camera's PTU would have moved to the specified tilt angle.");
        return true;
    }

    @Override
    public boolean moveByPanTilt(double panAngleDelta, double tiltAngleDelta) {
        Logger.info("moveByPanTilt(" + Math.toDegrees(panAngleDelta) + DEGREE_SYM + ", " + Math.toDegrees(tiltAngleDelta) + DEGREE_SYM + "): Just a stub - " + "the pan and tilt angles of the camera's PTU" + "would have moved by the specified amounts.");
        return true;
    }

    @Override
    public boolean moveByPan(double panAngleDelta) {
        Logger.info("moveByPan(" + Math.toDegrees(panAngleDelta) + DEGREE_SYM + "): Just a stub - the pan angle of the camera's " + "PTU would have moved by the specified amount.");
        return true;
    }

    @Override
    public boolean moveByTilt(double tiltAngleDelta) {
        Logger.info("moveByTilt(" + Math.toDegrees(tiltAngleDelta) + DEGREE_SYM + "): Just a stub - the tilt angle of the camera's " + "PTU would have moved by the specified amount.");
        return true;
    }

    @Override
    public boolean stopMotion() {
        Logger.info("stopMotion(): Just a stub - had the camera's PTU been moving, it have stopped doing so, regardless of whether or not the desired move was completed.");
        return true;
    }
}

