/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.imaging.camera.composites;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.addons.sensors.imaging.camera.ApogyAddonsSensorsImagingCameraPackage;
import org.eclipse.apogy.addons.sensors.imaging.camera.CameraViewConfiguration;
import org.eclipse.apogy.addons.sensors.imaging.camera.ImageFilter;
import org.eclipse.apogy.common.emf.ApogyCommonEMFPackage;
import org.eclipse.apogy.common.emf.FeaturePathAdapter;
import org.eclipse.apogy.common.emf.impl.FeaturePathAdapterCustomImpl;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.EClassSettings;
import org.eclipse.apogy.common.emf.ui.NamedSetting;
import org.eclipse.apogy.common.emf.ui.emfforms.ApogyCommonEMFUiEMFFormsFacade;
import org.eclipse.apogy.common.emf.ui.wizards.ApogyEObjectWizard;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class FiltersListComposite
extends Composite {
    private final ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private final TreeViewer treeViewer;
    private final Composite emfFormsComposite;
    private final ScrolledComposite scrolledComposite;
    private final Button btnNew;
    private final Button btnDelete;
    private final Button btnUp;
    private final Button btnDown;
    private final Button btnVisible;
    private DataBindingContext m_bindingContext;
    private CameraViewConfiguration cameraViewConfiguration;
    private List<FeaturePathAdapter> featurePathAdapters;

    public FiltersListComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(4, false));
        this.setBackground(this.getDisplay().getSystemColor(1));
        this.setBackgroundMode(2);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FiltersListComposite.this.dispose();
            }
        });
        this.treeViewer = new TreeViewer((Composite)this);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FiltersListComposite.this.newSelection();
                FiltersListComposite.this.updateEMFForms();
                if (FiltersListComposite.this.btnVisible != null) {
                    FiltersListComposite.this.btnVisible.setVisible(FiltersListComposite.this.getSelectedFilter() != null);
                }
            }
        });
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.treeViewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.treeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
        Composite buttonComposite = new Composite((Composite)this, 0);
        buttonComposite.setLayoutData((Object)new GridData(4, 128, false, true, 1, 2));
        buttonComposite.setLayout((Layout)new GridLayout(1, false));
        this.btnNew = new Button(buttonComposite, 0);
        this.btnNew.setText("New");
        this.btnNew.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.btnNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NamedSetting namedSettings = ApogyCommonEMFUIFactory.eINSTANCE.createNamedSetting();
                namedSettings.setParent((EObject)FiltersListComposite.this.getCameraViewConfiguration().getFilterList());
                namedSettings.setContainingFeature((ETypedElement)ApogyAddonsSensorsImagingCameraPackage.Literals.FILTER_LIST__IMAGE_FILTERS);
                ApogyEObjectWizard wizard = new ApogyEObjectWizard(ApogyAddonsSensorsImagingCameraPackage.Literals.FILTER_LIST__IMAGE_FILTERS, (EObject)FiltersListComposite.this.getCameraViewConfiguration().getFilterList(), (EClassSettings)namedSettings, null);
                WizardDialog dialog = new WizardDialog(FiltersListComposite.this.getShell(), (IWizard)wizard);
                dialog.open();
                FiltersListComposite.this.treeViewer.refresh();
                FiltersListComposite.this.updateEMFForms();
            }
        });
        this.btnDelete = new Button(buttonComposite, 0);
        this.btnDelete.setText("Delete");
        this.btnDelete.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FiltersListComposite.this.getSelectedFilter() != null) {
                    ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)FiltersListComposite.this.getCameraViewConfiguration().getFilterList(), (EStructuralFeature)ApogyAddonsSensorsImagingCameraPackage.Literals.FILTER_LIST__IMAGE_FILTERS, (Object)FiltersListComposite.this.getSelectedFilter());
                }
            }
        });
        this.btnUp = new Button(buttonComposite, 0);
        this.btnUp.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnUp.setSize(74, 29);
        this.btnUp.setText("Up");
        this.btnUp.setEnabled(false);
        this.btnUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (FiltersListComposite.this.getSelectedFilter() != null) {
                    ImageFilter imageFilter = FiltersListComposite.this.getSelectedFilter();
                    int index = FiltersListComposite.this.getCameraViewConfiguration().getFilterList().getImageFilters().indexOf((Object)imageFilter);
                    if (index > 0) {
                        FiltersListComposite.this.getCameraViewConfiguration().getFilterList().getImageFilters().move(index - 1, index);
                        if (!FiltersListComposite.this.treeViewer.isBusy()) {
                            FiltersListComposite.this.treeViewer.refresh();
                        }
                    }
                }
            }
        });
        this.btnDown = new Button(buttonComposite, 0);
        this.btnDown.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnDown.setSize(74, 29);
        this.btnDown.setText("Down");
        this.btnDown.setEnabled(false);
        this.btnDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (FiltersListComposite.this.getSelectedFilter() != null) {
                    ImageFilter imageFilter = FiltersListComposite.this.getSelectedFilter();
                    int listSize = FiltersListComposite.this.getCameraViewConfiguration().getFilterList().getImageFilters().size();
                    int index = FiltersListComposite.this.getCameraViewConfiguration().getFilterList().getImageFilters().indexOf((Object)imageFilter);
                    if (index < listSize - 1) {
                        FiltersListComposite.this.getCameraViewConfiguration().getFilterList().getImageFilters().move(index + 1, index);
                        if (!FiltersListComposite.this.treeViewer.isBusy()) {
                            FiltersListComposite.this.treeViewer.refresh();
                        }
                    }
                }
            }
        });
        Label separator = new Label((Composite)this, 2);
        separator.setLayoutData((Object)new GridData(4, 4, false, true, 1, 2));
        Composite toggleVisibleComposite = new Composite((Composite)this, 0);
        toggleVisibleComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        toggleVisibleComposite.setLayout((Layout)new GridLayout(1, false));
        this.btnVisible = new Button(toggleVisibleComposite, 0);
        this.btnVisible.setText("Toggle Active");
        this.btnVisible.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 1));
        this.btnVisible.setVisible(false);
        this.btnVisible.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FiltersListComposite.this.getSelectedFilter() != null) {
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)FiltersListComposite.this.getSelectedFilter(), (EStructuralFeature)ApogyAddonsSensorsImagingCameraPackage.Literals.IMAGE_FILTER__ENABLED, (Object)(!FiltersListComposite.this.getSelectedFilter().isEnabled() ? 1 : 0));
                }
            }
        });
        this.scrolledComposite = new ScrolledComposite((Composite)this, 768);
        this.scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.emfFormsComposite = new Composite((Composite)this.scrolledComposite, 0);
        this.scrolledComposite.setContent((Control)this.emfFormsComposite);
        this.scrolledComposite.setMinSize(this.emfFormsComposite.computeSize(-1, -1));
        this.updateEMFForms();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (FiltersListComposite.this.cameraViewConfiguration != null) {
                    for (FeaturePathAdapter adapter : FiltersListComposite.this.getFeaturePathAdapter()) {
                        adapter.dispose();
                    }
                }
                if (FiltersListComposite.this.m_bindingContext != null) {
                    FiltersListComposite.this.m_bindingContext.dispose();
                }
            }
        });
    }

    private void updateEMFForms() {
        if (!this.emfFormsComposite.isDisposed()) {
            Control[] controlArray = this.emfFormsComposite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                if (!control.isDisposed()) {
                    control.dispose();
                }
                ++n2;
            }
            ApogyCommonEMFUiEMFFormsFacade.INSTANCE.createEMFForms(this.emfFormsComposite, (EObject)this.getSelectedFilter(), "No compatible selection");
            if (!this.scrolledComposite.isDisposed()) {
                this.scrolledComposite.setMinSize(this.emfFormsComposite.computeSize(-1, -1));
            }
        }
    }

    protected void newSelection() {
    }

    public ImageFilter getSelectedFilter() {
        Object object;
        if (this.treeViewer.getStructuredSelection() != null && this.treeViewer.getStructuredSelection().getFirstElement() != null && (object = this.treeViewer.getStructuredSelection().getFirstElement()) instanceof ImageFilter) {
            return (ImageFilter)object;
        }
        return null;
    }

    public CameraViewConfiguration getCameraViewConfiguration() {
        return this.cameraViewConfiguration;
    }

    public void setCameraViewConfiguration(CameraViewConfiguration cameraViewConfiguration) {
        if (this.m_bindingContext != null) {
            this.m_bindingContext.dispose();
        }
        if (this.cameraViewConfiguration != null) {
            for (FeaturePathAdapter adapter : this.getFeaturePathAdapter()) {
                adapter.dispose();
            }
        }
        this.cameraViewConfiguration = cameraViewConfiguration;
        if (cameraViewConfiguration != null) {
            this.treeViewer.setInput((Object)this.cameraViewConfiguration.getFilterList());
            for (FeaturePathAdapter adapter : this.getFeaturePathAdapter()) {
                adapter.init((EObject)this.cameraViewConfiguration);
            }
            this.m_bindingContext = this.customInitDataBindings();
            this.btnNew.setEnabled(true);
            this.btnDelete.setEnabled(true);
        } else {
            this.treeViewer.setInput(null);
            this.btnNew.setEnabled(false);
            this.btnDelete.setEnabled(false);
        }
    }

    private List<FeaturePathAdapter> getFeaturePathAdapter() {
        if (this.featurePathAdapters == null) {
            this.featurePathAdapters = new ArrayList<FeaturePathAdapter>();
            this.featurePathAdapters.add((FeaturePathAdapter)new FeaturePathAdapterCustomImpl(){

                public List<? extends EStructuralFeature> getFeatureList() {
                    ArrayList<Object> list = new ArrayList<Object>();
                    list.add(ApogyAddonsSensorsImagingCameraPackage.Literals.CAMERA_VIEW_CONFIGURATION__FILTER_LIST);
                    list.add(ApogyAddonsSensorsImagingCameraPackage.Literals.FILTER_LIST__IMAGE_FILTERS);
                    list.add(ApogyCommonEMFPackage.Literals.NAMED__NAME);
                    return list;
                }

                public void notifyChanged(Notification msg) {
                    FiltersListComposite.this.treeViewer.refresh();
                }
            });
            this.featurePathAdapters.add((FeaturePathAdapter)new FeaturePathAdapterCustomImpl(){

                public List<? extends EStructuralFeature> getFeatureList() {
                    ArrayList<Object> list = new ArrayList<Object>();
                    list.add(ApogyAddonsSensorsImagingCameraPackage.Literals.CAMERA_VIEW_CONFIGURATION__FILTER_LIST);
                    list.add(ApogyAddonsSensorsImagingCameraPackage.Literals.FILTER_LIST__IMAGE_FILTERS);
                    list.add(ApogyAddonsSensorsImagingCameraPackage.Literals.IMAGE_FILTER__ENABLED);
                    return list;
                }

                public void notifyChanged(Notification msg) {
                    FiltersListComposite.this.treeViewer.refresh();
                }
            });
        }
        return this.featurePathAdapters;
    }

    protected AdapterFactoryContentProvider getContentProvider() {
        return new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory){

            public Object[] getElements(Object object) {
                if (FiltersListComposite.this.cameraViewConfiguration != null && FiltersListComposite.this.cameraViewConfiguration.getFilterList() != null && FiltersListComposite.this.cameraViewConfiguration.getFilterList().getImageFilters() != null) {
                    return FiltersListComposite.this.cameraViewConfiguration.getFilterList().getImageFilters().toArray();
                }
                return null;
            }

            public Object[] getChildren(Object object) {
                return null;
            }
        };
    }

    protected AdapterFactoryLabelProvider getLabelProvider() {
        return new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory){

            public String getText(Object object) {
                if (object instanceof ImageFilter) {
                    ImageFilter filter = (ImageFilter)object;
                    String label = filter.getName();
                    if (filter.isEnabled()) {
                        label = String.valueOf(label) + " <enabled>";
                    }
                    return label;
                }
                return "";
            }

            public Image getImage(Object object) {
                return null;
            }
        };
    }

    protected DataBindingContext customInitDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        IViewerObservableValue observeSingleSelectionViewer = ViewerProperties.singleSelection().observe((Viewer)this.treeViewer);
        ISWTObservableValue observeBtnUpObserveWidget = WidgetProperties.enabled().observe((Widget)this.btnUp);
        bindingContext.bindValue((IObservableValue)observeBtnUpObserveWidget, (IObservableValue)observeSingleSelectionViewer, null, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(Object.class, Boolean.class){

            public Object convert(Object fromObject) {
                if (fromObject != null) {
                    return true;
                }
                return false;
            }
        }));
        ISWTObservableValue observeBtnDownObserveWidget = WidgetProperties.enabled().observe((Widget)this.btnDown);
        bindingContext.bindValue((IObservableValue)observeBtnDownObserveWidget, (IObservableValue)observeSingleSelectionViewer, null, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(Object.class, Boolean.class){

            public Object convert(Object fromObject) {
                if (fromObject != null) {
                    return true;
                }
                return false;
            }
        }));
        return bindingContext;
    }
}

