/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.imaging.camera.impl;

import org.eclipse.apogy.addons.sensors.fov.RectangularFrustrumFieldOfView;
import org.eclipse.apogy.addons.sensors.imaging.AbstractCamera;
import org.eclipse.apogy.addons.sensors.imaging.AzimuthDirection;
import org.eclipse.apogy.addons.sensors.imaging.ElevationDirection;
import org.eclipse.apogy.addons.sensors.imaging.ImageSnapshot;
import org.eclipse.apogy.addons.sensors.imaging.ImagingUtilities;
import org.eclipse.apogy.addons.sensors.imaging.camera.OverlayAlignment;
import org.eclipse.apogy.addons.sensors.imaging.camera.impl.AzimuthElevationFOVOverlayImpl;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.images.EImagesUtilities;

public class AzimuthElevationFOVOverlayCustomImpl
extends AzimuthElevationFOVOverlayImpl {
    protected double azimuth = 0.0;
    protected double elevation = 0.0;

    @Override
    public void changeAzimuth(double azimuth) {
        this.azimuth = azimuth;
    }

    @Override
    public void changeElevation(double elevation) {
        this.elevation = elevation;
    }

    @Override
    public AbstractEImage applyOverlay(AbstractCamera camera, AbstractEImage cameraImage, OverlayAlignment overlayAlignment, int overlayWidth, int overlayHeight) {
        RectangularFrustrumFieldOfView fov = camera.getFieldOfView();
        double horizontalFOVAngle = Math.toDegrees(fov.getHorizontalFieldOfViewAngle());
        double verticalFOVAngle = Math.toDegrees(fov.getVerticalFieldOfViewAngle());
        AbstractEImage overlayImage = ImagingUtilities.INSTANCE.getAzimuthElevationOverlay(overlayWidth, overlayHeight, this.azimuth, this.elevation, horizontalFOVAngle, verticalFOVAngle, this.getAzimuthDirection(), this.getElevationDirection(), this.getAngleInterval(), this.getFontName(), this.getFontSize(), this.getColorOfPositive(), this.getColorOfNegative(), this.getLineWidth());
        AbstractEImage result = EImagesUtilities.INSTANCE.applyOverlay(cameraImage, overlayImage, false);
        return result;
    }

    @Override
    public String getToolTipText(AbstractCamera camera, ImageSnapshot imageSnapshot, int mouseButton, int x, int y) {
        String text = null;
        if (imageSnapshot != null) {
            double hDelta = Math.toDegrees(imageSnapshot.convertToHorizontalAngle(x));
            double vDelta = Math.toDegrees(imageSnapshot.convertToVerticalAngle(y));
            double hAngle = 0.0;
            double vAngle = 0.0;
            hAngle = this.getAzimuthDirection() == AzimuthDirection.POSITIVE_TOWARD_RIGHT ? this.azimuth - hDelta : this.azimuth + hDelta;
            vAngle = this.getElevationDirection() == ElevationDirection.POSITIVE_DOWN ? this.elevation - vDelta : this.elevation + vDelta;
            text = String.valueOf(this.angleFormat.format(hAngle)) + "\u00b0, " + this.angleFormat.format(vAngle) + "\u00b0";
        }
        return text;
    }
}

