/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.bindings.ui.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.apogy.common.emf.AbstractFeatureSpecifier;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.topology.bindings.ApogyCommonTopologyBindingsPackage;
import org.eclipse.apogy.common.topology.bindings.BindingsList;
import org.eclipse.apogy.common.topology.bindings.EnumerationCase;
import org.eclipse.apogy.common.topology.bindings.EnumerationSwitchBinding;
import org.eclipse.apogy.common.topology.bindings.ui.ApogyCommonTopologyBindingsUIFacade;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;

public class EnumerationCaseWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.common.topology.bindings.ui.wizards.EnumerationCaseWizardPage";
    private final AdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private final EnumerationSwitchBinding enumerationSwitchBinding;
    private final EnumerationCase enumerationCase;
    private Tree availableEEnumLiteralTree;
    private TreeViewer availableEEnumLiteralTreeViewer;
    private Tree selectedEEnumLiteralTree;
    private TreeViewer selectedEEnumLiteralTreeViewer;
    private Button btnAdd;
    private Button btnRemove;

    public EnumerationCaseWizardPage(EnumerationSwitchBinding enumerationSwitchBinding, EnumerationCase enumerationCase) {
        super(WIZARD_PAGE_ID);
        this.setTitle("Enumeration Case");
        this.setDescription("Defined the Enumeration Case.");
        this.enumerationSwitchBinding = enumerationSwitchBinding;
        this.enumerationCase = enumerationCase;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        container.setLayout((Layout)new GridLayout(3, false));
        this.setControl((Control)container);
        Composite left = new Composite(container, 0);
        left.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        left.setLayout((Layout)new GridLayout(1, false));
        Label lblAvailableEEnumLiteral = new Label(left, 0);
        lblAvailableEEnumLiteral.setAlignment(0x1000000);
        lblAvailableEEnumLiteral.setLayoutData((Object)new GridData(0x1000000, 128, true, false));
        lblAvailableEEnumLiteral.setText("Available Literals");
        this.availableEEnumLiteralTreeViewer = new TreeViewer(left, 68352);
        this.availableEEnumLiteralTree = this.availableEEnumLiteralTreeViewer.getTree();
        GridData gd_availableEEnumLiteralTreeViewer = new GridData(4, 4, true, true, 1, 1);
        this.availableEEnumLiteralTree.setLayoutData((Object)gd_availableEEnumLiteralTreeViewer);
        this.availableEEnumLiteralTree.setLinesVisible(true);
        this.availableEEnumLiteralTreeViewer.setContentProvider((IContentProvider)new AvailableEEnumLiteralContentProvider(this.enumerationSwitchBinding, this.enumerationCase));
        this.availableEEnumLiteralTreeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory));
        this.availableEEnumLiteralTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    EnumerationCaseWizardPage.this.btnAdd.setEnabled(true);
                } else {
                    EnumerationCaseWizardPage.this.btnAdd.setEnabled(false);
                }
            }
        });
        this.availableEEnumLiteralTreeViewer.setInput((Object)this.enumerationSwitchBinding);
        Composite center = new Composite(container, 0);
        center.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        center.setLayout((Layout)new GridLayout(1, false));
        this.btnAdd = new Button(center, 0);
        this.btnAdd.setSize(74, 29);
        this.btnAdd.setText("->");
        this.btnAdd.setToolTipText("Adds the selected Literal(s).");
        this.btnAdd.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnAdd.setEnabled(false);
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                List<EEnumLiteral> toAdd = EnumerationCaseWizardPage.this.getSelectedAvailableEEnumLiteral();
                ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)EnumerationCaseWizardPage.this.enumerationCase, (EStructuralFeature)ApogyCommonTopologyBindingsPackage.Literals.ENUMERATION_CASE__ENUMERATION_LITERALS, toAdd, true);
                if (!EnumerationCaseWizardPage.this.selectedEEnumLiteralTreeViewer.isBusy()) {
                    EnumerationCaseWizardPage.this.selectedEEnumLiteralTreeViewer.refresh();
                }
                EnumerationCaseWizardPage.this.validate();
                if (!EnumerationCaseWizardPage.this.availableEEnumLiteralTreeViewer.isBusy()) {
                    EnumerationCaseWizardPage.this.availableEEnumLiteralTreeViewer.refresh(true);
                }
            }
        });
        this.btnRemove = new Button(center, 0);
        this.btnRemove.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnRemove.setSize(74, 29);
        this.btnRemove.setText("<-");
        this.btnRemove.setToolTipText("Removes the selected Literal(s).");
        this.btnRemove.setEnabled(false);
        this.btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                List<EEnumLiteral> toRemove = EnumerationCaseWizardPage.this.getSelectedEEnumLiteral();
                ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)EnumerationCaseWizardPage.this.enumerationCase, (EStructuralFeature)ApogyCommonTopologyBindingsPackage.Literals.ENUMERATION_CASE__ENUMERATION_LITERALS, toRemove, true);
                if (!EnumerationCaseWizardPage.this.selectedEEnumLiteralTreeViewer.isBusy()) {
                    EnumerationCaseWizardPage.this.selectedEEnumLiteralTreeViewer.refresh();
                }
                EnumerationCaseWizardPage.this.validate();
                if (!EnumerationCaseWizardPage.this.availableEEnumLiteralTreeViewer.isBusy()) {
                    EnumerationCaseWizardPage.this.availableEEnumLiteralTreeViewer.refresh(true);
                }
            }
        });
        Composite right = new Composite(container, 0);
        right.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        right.setLayout((Layout)new GridLayout(1, false));
        Label lblCaseEEnumLiteral = new Label(right, 0);
        lblCaseEEnumLiteral.setAlignment(0x1000000);
        lblCaseEEnumLiteral.setLayoutData((Object)new GridData(0x1000000, 128, true, false));
        lblCaseEEnumLiteral.setText("Selected Literals");
        this.selectedEEnumLiteralTreeViewer = new TreeViewer(right, 68352);
        this.selectedEEnumLiteralTree = this.selectedEEnumLiteralTreeViewer.getTree();
        GridData gd_selectedEEnumLiteralTreeViewer = new GridData(4, 4, true, true, 1, 1);
        this.selectedEEnumLiteralTree.setLayoutData((Object)gd_selectedEEnumLiteralTreeViewer);
        this.selectedEEnumLiteralTree.setLinesVisible(true);
        this.selectedEEnumLiteralTreeViewer.setContentProvider((IContentProvider)new EnumerationCaseLiteralContentProvider());
        this.selectedEEnumLiteralTreeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory));
        this.selectedEEnumLiteralTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    EnumerationCaseWizardPage.this.btnRemove.setEnabled(true);
                } else {
                    EnumerationCaseWizardPage.this.btnRemove.setEnabled(false);
                }
            }
        });
        this.selectedEEnumLiteralTreeViewer.setInput((Object)this.enumerationCase);
        this.validate();
    }

    public List<EEnumLiteral> getSelectedAvailableEEnumLiteral() {
        return ((IStructuredSelection)this.availableEEnumLiteralTreeViewer.getSelection()).toList();
    }

    public List<EEnumLiteral> getSelectedEEnumLiteral() {
        return ((IStructuredSelection)this.selectedEEnumLiteralTreeViewer.getSelection()).toList();
    }

    private void validate() {
        this.setErrorMessage(null);
        if (this.enumerationCase.getEnumerationLiterals().isEmpty()) {
            this.setErrorMessage("The Enumeration Case contains no Literals !");
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    private EEnum resolveEENum(EnumerationSwitchBinding enumerationSwitchBinding) {
        AbstractFeatureSpecifier abstractFeatureSpecifier;
        EEnum eEnum = null;
        if (enumerationSwitchBinding.getFeatureNode() instanceof AbstractFeatureSpecifier && (abstractFeatureSpecifier = (AbstractFeatureSpecifier)enumerationSwitchBinding.getFeatureNode()).getStructuralFeature() != null && abstractFeatureSpecifier.getStructuralFeature().getEType() instanceof EEnum) {
            eEnum = (EEnum)abstractFeatureSpecifier.getStructuralFeature().getEType();
        }
        return eEnum;
    }

    public class AvailableEEnumLiteralContentProvider
    implements ITreeContentProvider {
        private final EnumerationCase enumerationCase;
        private final EEnum eEnum;

        public AvailableEEnumLiteralContentProvider(EnumerationSwitchBinding enumerationSwitchBinding, EnumerationCase enumerationCase) {
            this.enumerationCase = enumerationCase;
            this.eEnum = EnumerationCaseWizardPage.this.resolveEENum(enumerationSwitchBinding);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof EnumerationSwitchBinding) {
                EnumerationSwitchBinding bindingsList = (EnumerationSwitchBinding)inputElement;
                return this.filter(bindingsList).toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof EnumerationSwitchBinding) {
                EnumerationSwitchBinding bindingsList = (EnumerationSwitchBinding)parentElement;
                return this.filter(bindingsList).toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof BindingsList) {
                EnumerationSwitchBinding bindingsList = (EnumerationSwitchBinding)element;
                return !bindingsList.getCases().isEmpty();
            }
            return false;
        }

        private List<EEnumLiteral> filter(EnumerationSwitchBinding enumerationSwitchBinding) {
            ArrayList<EEnumLiteral> filtered = new ArrayList<EEnumLiteral>();
            if (this.eEnum != null) {
                EList allEEnumLiteral = this.eEnum.getELiterals();
                for (EEnumLiteral eEnumLiteral : allEEnumLiteral) {
                    if (ApogyCommonTopologyBindingsUIFacade.INSTANCE.isEEnumLiteralInUse(enumerationSwitchBinding, eEnumLiteral)) continue;
                    filtered.add(eEnumLiteral);
                }
                filtered.removeAll((Collection<?>)this.enumerationCase.getEnumerationLiterals());
            }
            return filtered;
        }
    }

    public class EnumerationCaseLiteralContentProvider
    implements ITreeContentProvider {
        public Object[] getChildren(Object parent) {
            if (parent instanceof EnumerationCase) {
                EnumerationCase enumerationCase = (EnumerationCase)parent;
                return enumerationCase.getEnumerationLiterals().toArray();
            }
            return null;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof EnumerationCase) {
                EnumerationCase enumerationCase = (EnumerationCase)inputElement;
                return enumerationCase.getEnumerationLiterals().toArray();
            }
            return null;
        }

        public Object getParent(Object arg0) {
            return null;
        }

        public boolean hasChildren(Object parent) {
            if (parent instanceof EnumerationCase) {
                EnumerationCase enumerationCase = (EnumerationCase)parent;
                return !enumerationCase.getEnumerationLiterals().isEmpty();
            }
            return false;
        }
    }
}

