/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.widgets.ui;

import org.eclipse.swt.graphics.Color;

public class Range
implements Comparable<Range> {
    private final double minimum;
    private final double maximum;
    private final Color color;

    public Range(double min, double max, Color color) {
        this.minimum = min;
        this.maximum = max;
        this.color = color;
    }

    public double getRange() {
        return this.maximum - this.minimum;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    public int compareTo(Range r) {
        if (this.getRange() > r.getRange()) {
            return -1;
        }
        if (this.getRange() < r.getRange()) {
            return 1;
        }
        return 0;
    }

    protected void finalize() throws Throwable {
        this.color.dispose();
        super.finalize();
    }
}

