/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.surface.orbit.ui.jme3.scene_objects;

import com.jme3.asset.AssetManager;
import com.jme3.asset.plugins.FileLocator;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.jme3.JME3RenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.eclipse.apogy.common.topology.ui.jme3.scene_objects.DefaultJME3SceneObject;
import org.eclipse.apogy.core.environment.earth.surface.orbit.ui.EarthOrbitModelPassTool;
import org.eclipse.apogy.core.environment.earth.surface.orbit.ui.EarthOrbitModelPassToolNode;
import org.eclipse.apogy.core.environment.earth.surface.orbit.ui.scene_objects.EarthOrbitModelPassToolNodeSceneObject;
import org.eclipse.apogy.core.environment.orbit.earth.VisibilityPass;
import org.eclipse.apogy.core.environment.orbit.earth.VisibilityPassSpacecraftPosition;
import org.eclipse.apogy.core.environment.orbit.earth.VisibilityPassSpacecraftPositionHistory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class EarthOrbitModelPassToolNodeJME3Object
extends DefaultJME3SceneObject<EarthOrbitModelPassToolNode>
implements IPropertyChangeListener,
EarthOrbitModelPassToolNodeSceneObject {
    public static final ColorRGBA DEFAULT_GRID_COLOR = new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f);
    public static final float DISPLAY_RADIUS = 15000.0f;
    private EarthOrbitModelPassTool earthOrbitModelPassTool;
    private Adapter adapter;
    private AssetManager assetManager = this.jme3Application.getAssetManager();
    private Geometry trajectoryGeometry = null;

    public EarthOrbitModelPassToolNodeJME3Object(EarthOrbitModelPassToolNode node, JME3RenderEngineDelegate jme3RenderEngineDelegate) {
        super((Node)node, jme3RenderEngineDelegate);
        this.assetManager.registerLocator("/", FileLocator.class);
        this.earthOrbitModelPassTool = node.getEarthOrbitModelPassTool();
        Job job = new Job("EarthOrbitModelPassToolNodeJME3Object initialize."){

            protected IStatus run(IProgressMonitor monitor) {
                EarthOrbitModelPassToolNodeJME3Object.this.jme3Application.enqueue((Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        EarthOrbitModelPassToolNodeJME3Object.this.createGeometry();
                        ((EarthOrbitModelPassToolNode)EarthOrbitModelPassToolNodeJME3Object.this.getTopologyNode()).getEarthOrbitModelPassTool().eAdapters().add((Object)EarthOrbitModelPassToolNodeJME3Object.this.getAdapter());
                        return null;
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void updateGeometry(float tpf) {
        if (this.trajectoryGeometry != null) {
            this.getAttachmentNode().detachChild((Spatial)this.trajectoryGeometry);
        }
        this.trajectoryGeometry = this.createPassTrajectoryGeometry();
        this.getAttachmentNode().attachChild((Spatial)this.trajectoryGeometry);
    }

    public void dispose() {
        if (this.getTopologyNode() != null && ((EarthOrbitModelPassToolNode)this.getTopologyNode()).getEarthOrbitModelPassTool() != null) {
            ((EarthOrbitModelPassToolNode)this.getTopologyNode()).getEarthOrbitModelPassTool().eAdapters().remove((Object)this.getAdapter());
        }
        super.dispose();
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return null;
            }
        });
    }

    public List<Geometry> getGeometries() {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        geometries.add(this.trajectoryGeometry);
        return geometries;
    }

    private void createGeometry() {
        this.trajectoryGeometry = this.createPassTrajectoryGeometry();
        this.getAttachmentNode().attachChild((Spatial)this.trajectoryGeometry);
    }

    private Geometry createPassTrajectoryGeometry() {
        Mesh mesh;
        VisibilityPass visibilityPass = this.earthOrbitModelPassTool.getDisplayedPass();
        Geometry geometry = null;
        if (visibilityPass == null) {
            mesh = new Mesh();
            mesh.setMode(Mesh.Mode.Lines);
            geometry = new Geometry("PassTrajectory", mesh);
        } else {
            mesh = new Mesh();
            mesh.setMode(Mesh.Mode.Lines);
            geometry = new Geometry("PassTrajectory", mesh);
            ArrayList<Vector3f> verticesList = new ArrayList<Vector3f>();
            ArrayList<Integer> indexesList = new ArrayList<Integer>();
            VisibilityPassSpacecraftPositionHistory history = visibilityPass.getPositionHistory();
            int index = 0;
            double azimuth = 0.0;
            double elevation = 0.0;
            for (VisibilityPassSpacecraftPosition position : history.getPositions()) {
                azimuth = position.getAzimuth();
                elevation = position.getElevation();
                double r = Math.cos(elevation) * 15000.0;
                float x = (float)(r * Math.cos(-azimuth));
                float y = (float)(r * Math.sin(-azimuth));
                float z = (float)(15000.0 * Math.sin(elevation));
                Vector3f p0 = new Vector3f(x, y, z);
                verticesList.add(p0);
                if (index > 0) {
                    indexesList.add(index - 1);
                    indexesList.add(index);
                }
                ++index;
            }
            mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((float[])JME3Utilities.convertToFloatArray(verticesList)));
            mesh.setBuffer(VertexBuffer.Type.Index, 2, BufferUtils.createIntBuffer((int[])JME3Utilities.convertToIntArray(indexesList)));
            mesh.updateBound();
            mesh.updateCounts();
        }
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setColor("Color", DEFAULT_GRID_COLOR.clone());
        geometry.setMaterial(mat);
        geometry.setShadowMode(RenderQueue.ShadowMode.Off);
        return geometry;
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof EarthOrbitModelPassTool) {
                        int featureId = msg.getFeatureID(EarthOrbitModelPassTool.class);
                        switch (featureId) {
                            case 16: {
                                EarthOrbitModelPassToolNodeJME3Object.this.requestUpdate();
                                break;
                            }
                            case 6: {
                                boolean newVisible = msg.getNewBooleanValue();
                                EarthOrbitModelPassToolNodeJME3Object.this.setVisible(newVisible);
                            }
                        }
                    }
                }
            };
        }
        return this.adapter;
    }
}

