/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.surface.orbit.ui.impl;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import org.eclipse.apogy.common.emf.TimeSource;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.topology.GroupNode;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.core.ApogyCorePackage;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;
import org.eclipse.apogy.core.environment.earth.surface.ApogyEarthSurfaceEnvironmentFacade;
import org.eclipse.apogy.core.environment.earth.surface.EarthSky;
import org.eclipse.apogy.core.environment.earth.surface.EarthSurfaceWorksite;
import org.eclipse.apogy.core.environment.earth.surface.orbit.ui.ApogyEarthSurfaceOrbitEnvironmentUIFactory;
import org.eclipse.apogy.core.environment.earth.surface.orbit.ui.ApogyEarthSurfaceOrbitEnvironmentUIPackage;
import org.eclipse.apogy.core.environment.earth.surface.orbit.ui.EarthOrbitModelPassToolNode;
import org.eclipse.apogy.core.environment.earth.surface.orbit.ui.impl.EarthOrbitModelPassToolImpl;
import org.eclipse.apogy.core.environment.orbit.earth.ApogyCoreEnvironmentOrbitEarthFacade;
import org.eclipse.apogy.core.environment.orbit.earth.ApogyCoreEnvironmentOrbitEarthFactory;
import org.eclipse.apogy.core.environment.orbit.earth.ConstantElevationMask;
import org.eclipse.apogy.core.environment.orbit.earth.EarthOrbitModel;
import org.eclipse.apogy.core.environment.orbit.earth.ElevationMask;
import org.eclipse.apogy.core.environment.orbit.earth.GroundStation;
import org.eclipse.apogy.core.environment.orbit.earth.SpacecraftsVisibilitySet;
import org.eclipse.apogy.core.environment.orbit.earth.TLE;
import org.eclipse.apogy.core.environment.orbit.earth.VisibilityPass;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EarthOrbitModelPassToolCustomImpl
extends EarthOrbitModelPassToolImpl {
    private static final Logger Logger = LoggerFactory.getLogger(EarthOrbitModelPassToolImpl.class);
    private Adapter spacecraftsVisibilitySetAdapter;

    @Override
    public void setLookAheadPeriod(long newLookAheadPeriod) {
        super.setLookAheadPeriod(newLookAheadPeriod);
        this.runUpdateInJob();
    }

    @Override
    public EarthOrbitModel getEarthOrbitModel() {
        EarthOrbitModel tmp = super.getEarthOrbitModel();
        if (tmp == null) {
            try {
                TLE tle = ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.loadTLE("platform:/plugin/com.neptec.ogr.simulator/data/ISS.tle");
                tmp = ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createTLEEarthOrbitModel(tle);
                tmp.setName("ISS");
                tmp.setDescription("The ISS.");
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return tmp;
    }

    @Override
    public void setEarthOrbitModel(EarthOrbitModel newEarthOrbitModel) {
        super.setEarthOrbitModel(newEarthOrbitModel);
        this.runUpdateInJob();
    }

    @Override
    public SpacecraftsVisibilitySet getSpacecraftsVisibilitySet() {
        SpacecraftsVisibilitySet tmp = super.getSpacecraftsVisibilitySet();
        if (tmp == null) {
            tmp = ApogyCoreEnvironmentOrbitEarthFactory.eINSTANCE.createSpacecraftsVisibilitySet();
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyEarthSurfaceOrbitEnvironmentUIPackage.Literals.EARTH_ORBIT_MODEL_PASS_TOOL__SPACECRAFTS_VISIBILITY_SET, (Object)tmp);
            tmp.eAdapters().add((Object)new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    int featureId = msg.getFeatureID(SpacecraftsVisibilitySet.class);
                    if (featureId == 2) {
                        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)EarthOrbitModelPassToolCustomImpl.this, (EStructuralFeature)ApogyCorePackage.Literals.UPDATABLE__UPDATING, (Object)msg.getNewBooleanValue(), true);
                    }
                }
            });
        }
        return tmp;
    }

    public void setActive(boolean newActive) {
        super.setActive(newActive);
        if (newActive) {
            this.runUpdateInJob();
        }
    }

    @Override
    public void setActiveTimeSource(TimeSource newActiveTimeSource) {
        super.setActiveTimeSource(newActiveTimeSource);
        this.runUpdateInJob();
    }

    @Override
    public void setActiveEarthSurfaceWorksite(EarthSurfaceWorksite newActiveEarthSurfaceWorksite) {
        if (this.getActiveEarthSurfaceWorksite() != newActiveEarthSurfaceWorksite) {
            this.detachToolNode();
            super.setActiveEarthSurfaceWorksite(ApogyEarthSurfaceEnvironmentFacade.INSTANCE.getActiveEarthSurfaceWorksite());
            this.attachToolNode();
            this.runUpdateInJob();
        }
    }

    @Override
    public void initialise() {
        EarthOrbitModelPassToolNode toolNode = ApogyEarthSurfaceOrbitEnvironmentUIFactory.eINSTANCE.createEarthOrbitModelPassToolNode();
        if (this.getName() != null) {
            toolNode.setDescription("Node associated with the EarthOrbitModelPassTool named <" + this.getName() + ">");
            toolNode.setNodeId("Earth_Orbit_Model_Pass_Tool_" + this.getName().replaceAll(" ", "_"));
        }
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyEarthSurfaceOrbitEnvironmentUIPackage.Literals.EARTH_ORBIT_MODEL_PASS_TOOL__EARTH_ORBIT_MODEL_PASS_TOOL_NODE, (Object)toolNode, true);
        this.getSpacecraftsVisibilitySet().eAdapters().add((Object)this.getSpacecraftsVisibilitySetAdapter());
        super.initialise();
        this.runUpdateInJob();
    }

    public void setRootNode(Node newRootNode) {
        super.setRootNode(newRootNode);
        this.attachToolNode();
        this.runUpdateInJob();
    }

    public void variablesInstantiated() {
        super.variablesInstantiated();
        this.attachToolNode();
        this.runUpdateInJob();
    }

    @Override
    public void dispose() {
        this.getSpacecraftsVisibilitySet().eAdapters().remove((Object)this.getSpacecraftsVisibilitySetAdapter());
        this.detachToolNode();
        super.dispose();
    }

    @Override
    public void update() throws Exception {
        if (this.isAutoUpdateEnabled() && !this.isUpdating()) {
            this.updatePasses();
        }
    }

    @Override
    public boolean getDefaultAutoUpdateEnabled() {
        return true;
    }

    @Override
    public void updateTime(Date newTime) {
        VisibilityPass nextPass = this.getApplicableVisibilityPass(newTime);
        this.updateDisplayedPass(nextPass);
        if (this.isAutoUpdateEnabled() && this.getDisplayedPass() == null) {
            boolean updadeNeeded = false;
            if (this.getLastPassesUpdateTime() != null) {
                long updatePeriodEndTime = this.getLastPassesUpdateTime().getTime() + this.getLookAheadPeriod() * 1000L;
                if (newTime.getTime() > updatePeriodEndTime) {
                    updadeNeeded = true;
                }
            } else {
                updadeNeeded = true;
            }
            if (updadeNeeded) {
                this.runUpdateInJob();
            }
        }
    }

    protected void runUpdateInJob() {
        Job job = new Job(this.getJobName()){

            protected IStatus run(IProgressMonitor arg0) {
                try {
                    if (EarthOrbitModelPassToolCustomImpl.this.isAutoUpdateEnabled()) {
                        EarthOrbitModelPassToolCustomImpl.this.update();
                    }
                }
                catch (Exception e) {
                    Logger.error(e.getMessage(), (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    protected String getJobName() {
        String jobName = "EarthOrbitModelPassTool";
        if (this.getName() != null) {
            jobName = String.valueOf(jobName) + " <" + this.getName() + ">";
        }
        jobName = String.valueOf(jobName) + "- Update";
        return jobName;
    }

    protected void updatePasses() {
        if (this.getEarthOrbitModel() != null) {
            GroundStation groundStation = this.resolveGroundStation();
            TimeSource timeSource = this.getActiveTimeSource();
            if (groundStation != null && timeSource != null) {
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyEarthSurfaceOrbitEnvironmentUIPackage.Literals.EARTH_ORBIT_MODEL_PASS_TOOL__DISPLAYED_PASS, null, true);
                try {
                    Date startDate = new Date(timeSource.getTime().getTime());
                    Date endDate = new Date(startDate.getTime() + this.getLookAheadPeriod() * 1000L * 2L);
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyEarthSurfaceOrbitEnvironmentUIPackage.Literals.EARTH_ORBIT_MODEL_PASS_TOOL__LAST_PASSES_UPDATE_TIME, (Object)startDate, false);
                    SpacecraftsVisibilitySet spacecraftsVisibilitySet = this.getSpacecraftsVisibilitySet();
                    spacecraftsVisibilitySet.getGroundStations().clear();
                    spacecraftsVisibilitySet.getGroundStations().add((Object)groundStation);
                    spacecraftsVisibilitySet.getOrbitModels().clear();
                    spacecraftsVisibilitySet.getOrbitModels().add((Object)this.getEarthOrbitModel());
                    spacecraftsVisibilitySet.setStartTime(startDate);
                    spacecraftsVisibilitySet.setEndTime(endDate);
                    spacecraftsVisibilitySet.setAutoUpdateEnabled(true);
                    spacecraftsVisibilitySet.update();
                }
                catch (Exception e) {
                    Logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    protected GroundStation resolveGroundStation() {
        GeographicCoordinates geographicCoordinates;
        EarthSurfaceWorksite earthSurfaceWorksite = this.getActiveEarthSurfaceWorksite();
        if (earthSurfaceWorksite != null && (geographicCoordinates = earthSurfaceWorksite.getGeographicalCoordinates()) != null) {
            GroundStation groundStation = ApogyCoreEnvironmentOrbitEarthFactory.eINSTANCE.createGroundStation();
            groundStation.setName(earthSurfaceWorksite.getName());
            groundStation.setLatitude(geographicCoordinates.getLatitude());
            groundStation.setLongitude(geographicCoordinates.getLongitude());
            groundStation.setElevation(geographicCoordinates.getElevation());
            ConstantElevationMask constantElevationMask = ApogyCoreEnvironmentOrbitEarthFactory.eINSTANCE.createConstantElevationMask();
            constantElevationMask.setConstantElevation(Math.toRadians(0.0));
            groundStation.setElevationMask((ElevationMask)constantElevationMask);
            return groundStation;
        }
        return null;
    }

    protected VisibilityPass getApplicableVisibilityPass(Date currentTime) {
        VisibilityPass visibilityPass = null;
        if (!this.getSpacecraftsVisibilitySet().getPasses().isEmpty()) {
            SortedSet passes = ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.getVisibilityPassSortedByStartDate((List)this.getSpacecraftsVisibilitySet().getPasses());
            long now = currentTime.getTime();
            Iterator it = passes.iterator();
            while (it.hasNext() && visibilityPass == null) {
                VisibilityPass pass = (VisibilityPass)it.next();
                if (pass.getStartTime().getTime() <= now && pass.getEndTime().getTime() >= now) {
                    visibilityPass = pass;
                    continue;
                }
                if (pass.getStartTime().getTime() < now) continue;
                visibilityPass = pass;
            }
        }
        return visibilityPass;
    }

    private void updateDisplayedPass(VisibilityPass newDisplayedPass) {
        if (newDisplayedPass != this.getDisplayedPass()) {
            Logger.info("Updating next pass to <" + newDisplayedPass + ">.");
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyEarthSurfaceOrbitEnvironmentUIPackage.Literals.EARTH_ORBIT_MODEL_PASS_TOOL__DISPLAYED_PASS, (Object)newDisplayedPass, true);
        }
    }

    protected void attachToolNode() {
        if (this.getEarthOrbitModelPassToolNode() != null) {
            EarthSky earthSky;
            this.detachToolNode();
            if (this.getActiveEarthSurfaceWorksite() != null && (earthSky = this.getActiveEarthSurfaceWorksite().getEarthSky()) != null && earthSky.getSkyNode() != null) {
                earthSky.getSkyNode().getChildren().add((Object)this.getEarthOrbitModelPassToolNode());
            }
        }
    }

    protected void detachToolNode() {
        if (this.getEarthOrbitModelPassToolNode() != null && this.getEarthOrbitModelPassToolNode().getParent() instanceof GroupNode) {
            GroupNode parent = (GroupNode)this.getEarthOrbitModelPassToolNode().getParent();
            parent.getChildren().remove((Object)this.getEarthOrbitModelPassToolNode());
        }
    }

    private Adapter getSpacecraftsVisibilitySetAdapter() {
        if (this.spacecraftsVisibilitySetAdapter == null) {
            this.spacecraftsVisibilitySetAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof SpacecraftsVisibilitySet) {
                        int featureId = msg.getFeatureID(SpacecraftsVisibilitySet.class);
                        switch (featureId) {
                            case 8: {
                                VisibilityPass pass = null;
                                if (EarthOrbitModelPassToolCustomImpl.this.getActiveTimeSource() != null) {
                                    pass = EarthOrbitModelPassToolCustomImpl.this.getApplicableVisibilityPass(EarthOrbitModelPassToolCustomImpl.this.getActiveTimeSource().getTime());
                                }
                                EarthOrbitModelPassToolCustomImpl.this.updateDisplayedPass(pass);
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.spacecraftsVisibilitySetAdapter;
    }
}

