/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.surface.orbit.ui.impl;

import java.util.Date;
import org.eclipse.apogy.common.emf.TimeSource;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.environment.ApogyCoreEnvironmentFacade;
import org.eclipse.apogy.core.environment.earth.surface.ApogyEarthSurfaceEnvironmentFacade;
import org.eclipse.apogy.core.environment.earth.surface.EarthSurfaceWorksite;
import org.eclipse.apogy.core.environment.earth.surface.orbit.ui.ApogyEarthSurfaceOrbitEnvironmentUIPackage;
import org.eclipse.apogy.core.environment.earth.surface.orbit.ui.impl.EarthOrbitModelToolImpl;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public abstract class EarthOrbitModelToolCustomImpl
extends EarthOrbitModelToolImpl {
    private Adapter activeEarthSurfaceWorksiteAdapter;
    private Adapter activeTimeSourceAdapter;
    private Adapter timeSourceAdapter;

    @Override
    public void setActiveTimeSource(TimeSource newActiveTimeSource) {
        if (this.getActiveTimeSource() != null) {
            this.getActiveTimeSource().eAdapters().remove((Object)this.getTimeSourceAdapter());
        }
        super.setActiveTimeSource(newActiveTimeSource);
        if (newActiveTimeSource != null) {
            newActiveTimeSource.eAdapters().add((Object)this.getTimeSourceAdapter());
        }
    }

    public void initialise() {
        super.initialise();
        this.updateActiveEarthSurfaceWorksite(ApogyEarthSurfaceEnvironmentFacade.INSTANCE.getActiveEarthSurfaceWorksite());
        ApogyEarthSurfaceEnvironmentFacade.INSTANCE.eAdapters().add((Object)this.getActiveEarthSurfaceWorksiteAdapter());
        this.setActiveTimeSource(ApogyCoreEnvironmentFacade.INSTANCE.getActiveTimeSource());
        ApogyCoreEnvironmentFacade.INSTANCE.eAdapters().add((Object)this.getActiveTimeSourceAdapter());
    }

    public void dispose() {
        if (this.getActiveTimeSource() != null) {
            this.getActiveTimeSource().eAdapters().remove((Object)this.getTimeSourceAdapter());
        }
        ApogyEarthSurfaceEnvironmentFacade.INSTANCE.eAdapters().remove((Object)this.getActiveEarthSurfaceWorksiteAdapter());
        ApogyCoreEnvironmentFacade.INSTANCE.eAdapters().remove((Object)this.getActiveTimeSourceAdapter());
        super.dispose();
    }

    private void updateActiveEarthSurfaceWorksite(EarthSurfaceWorksite newEarthSurfaceWorksite) {
        if (this.getActiveEarthSurfaceWorksite() != newEarthSurfaceWorksite) {
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyEarthSurfaceOrbitEnvironmentUIPackage.Literals.EARTH_ORBIT_MODEL_TOOL__ACTIVE_EARTH_SURFACE_WORKSITE, (Object)ApogyEarthSurfaceEnvironmentFacade.INSTANCE.getActiveEarthSurfaceWorksite(), true);
        }
    }

    private Adapter getActiveEarthSurfaceWorksiteAdapter() {
        if (this.activeEarthSurfaceWorksiteAdapter == null) {
            this.activeEarthSurfaceWorksiteAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof ApogyEarthSurfaceEnvironmentFacade) {
                        int featureId = msg.getFeatureID(ApogyEarthSurfaceEnvironmentFacade.class);
                        switch (featureId) {
                            case 0: {
                                EarthOrbitModelToolCustomImpl.this.updateActiveEarthSurfaceWorksite(ApogyEarthSurfaceEnvironmentFacade.INSTANCE.getActiveEarthSurfaceWorksite());
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.activeEarthSurfaceWorksiteAdapter;
    }

    private Adapter getActiveTimeSourceAdapter() {
        if (this.activeTimeSourceAdapter == null) {
            this.activeTimeSourceAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof ApogyCoreEnvironmentFacade) {
                        int featureId = msg.getFeatureID(ApogyCoreEnvironmentFacade.class);
                        switch (featureId) {
                            case 2: {
                                TimeSource newTimeSource = (TimeSource)msg.getNewValue();
                                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)EarthOrbitModelToolCustomImpl.this, (EStructuralFeature)ApogyEarthSurfaceOrbitEnvironmentUIPackage.Literals.EARTH_ORBIT_MODEL_TOOL__ACTIVE_TIME_SOURCE, (Object)newTimeSource);
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.activeTimeSourceAdapter;
    }

    private Adapter getTimeSourceAdapter() {
        if (this.timeSourceAdapter == null) {
            this.timeSourceAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof TimeSource) {
                        int featureId = msg.getFeatureID(TimeSource.class);
                        switch (featureId) {
                            case 2: {
                                Date newTime = (Date)msg.getNewValue();
                                if (newTime == null) break;
                                EarthOrbitModelToolCustomImpl.this.updateTime(newTime);
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.timeSourceAdapter;
    }
}

