/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.ui.parts;

import java.util.Collections;
import javax.inject.Inject;
import org.eclipse.apogy.core.environment.earth.ui.ApogyEarthEnvironmentUIFactory;
import org.eclipse.apogy.core.environment.earth.ui.EarthUIFacade;
import org.eclipse.apogy.core.environment.earth.ui.EarthViewConfiguration;
import org.eclipse.apogy.core.environment.earth.ui.EarthViewConfigurationReference;
import org.eclipse.apogy.core.environment.earth.ui.composites.EarthViewComposite;
import org.eclipse.apogy.core.invocator.InvocatorSession;
import org.eclipse.apogy.core.invocator.ui.ApogyCoreInvocatorUIFacade;
import org.eclipse.apogy.core.invocator.ui.parts.AbstractSessionBasedPart;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EarthViewPart
extends AbstractSessionBasedPart {
    private static final Logger Logger = LoggerFactory.getLogger(EarthViewPart.class);
    public static final String EarthViewConfigurationID = "EarthViewConfiguration";
    protected String partName = "Earth View";
    private EarthViewConfiguration earthViewConfiguration;
    protected EarthViewComposite earthViewComposite;
    private EarthViewComposite.EarthViewMode earthViewMode = EarthViewComposite.EarthViewMode.ROUND;
    @Inject
    ECommandService commandService;
    @Inject
    EHandlerService handlerService;

    protected void newInvocatorSession(InvocatorSession invocatorSession) {
        this.earthViewComposite.setEarthViewConfigurationList(EarthUIFacade.INSTANCE.getActiveEarthViewConfigurationList());
        if (invocatorSession != null) {
            EarthViewConfigurationReference ref = (EarthViewConfigurationReference)ApogyCoreInvocatorUIFacade.INSTANCE.readFromPersistedState(this.mPart, EarthViewConfigurationID);
            if (ref != null) {
                this.earthViewConfiguration = ref.getEarthViewConfiguration();
            } else {
                Logger.warn("No Earth View Configuration could be read back, setting it to null. ");
            }
            this.earthViewComposite.setEarthViewConfiguration(this.earthViewConfiguration);
        }
    }

    protected void createContentComposite(Composite parent, int style) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.earthViewComposite = new EarthViewComposite(parent, 2048){

            @Override
            protected void newEarthViewConfigurationSelected(EarthViewConfiguration newEarthViewConfiguration) {
                EarthViewPart.this.earthViewConfiguration = newEarthViewConfiguration;
                EarthViewPart.this.selectionService.setSelection((Object)newEarthViewConfiguration);
                if (newEarthViewConfiguration != null) {
                    EarthViewPart.this.mPart.setLabel(String.valueOf(EarthViewPart.this.partName) + " - " + newEarthViewConfiguration.getName());
                }
                ParameterizedCommand command = EarthViewPart.this.commandService.createCommand("org.eclipse.apogy.core.environment.earth.ui.command.updateearthviewtoolbar", Collections.emptyMap());
                EarthViewPart.this.handlerService.executeHandler(command);
            }
        };
        GridData gd_earthViewComposite = new GridData(4, 4, true, true);
        this.earthViewComposite.setLayoutData(gd_earthViewComposite);
        this.earthViewComposite.setEarthViewMode(this.earthViewMode);
    }

    public void userPersistState(MPart mPart) {
        try {
            if (this.earthViewConfiguration != null) {
                EarthViewConfigurationReference ref = ApogyEarthEnvironmentUIFactory.eINSTANCE.createEarthViewConfigurationReference();
                ref.setEarthViewConfiguration(this.earthViewConfiguration);
                ApogyCoreInvocatorUIFacade.INSTANCE.saveToPersistedState(mPart, EarthViewConfigurationID, (EObject)ref);
            }
            mPart.setLabel(this.partName);
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
    }

    public void setEarthViewMode(EarthViewComposite.EarthViewMode mode) {
        if (this.earthViewComposite != null && !this.earthViewComposite.isDisposed()) {
            this.earthViewComposite.setEarthViewMode(mode);
        }
        this.earthViewMode = mode;
    }

    public EarthViewComposite.EarthViewMode getEarthViewMode() {
        return this.earthViewMode;
    }
}

