/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.ui.utils;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.ogc.kml.KMLAbstractContainer;
import gov.nasa.worldwind.ogc.kml.KMLAbstractFeature;
import gov.nasa.worldwind.ogc.kml.KMLDocument;
import gov.nasa.worldwind.render.Polyline;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.vecmath.Color3f;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;

public class WorldWindUtils {
    public static Position convertToPosition(GeographicCoordinates geographicCoordinates) {
        Angle latitude = Angle.fromRadiansLatitude((double)geographicCoordinates.getLatitude());
        Angle longitude = Angle.fromRadiansLongitude((double)geographicCoordinates.getLongitude());
        double elevation = geographicCoordinates.getElevation();
        Position position = new Position(latitude, longitude, elevation);
        return position;
    }

    public static List<Polyline> createPolyLineFromGeographicCoordinatesListNoWrapAround(List<GeographicCoordinates> coordinatesList) {
        ArrayList<Polyline> polylines = new ArrayList<Polyline>();
        LinkedList<Position> positions = new LinkedList<Position>();
        for (GeographicCoordinates coord : coordinatesList) {
            Position position = WorldWindUtils.convertToPosition(coord);
            if (positions.size() > 0) {
                double currentLongitude = position.longitude.getDegrees();
                double lastLongitude = ((Position)positions.getLast()).longitude.getDegrees();
                if (Math.signum(currentLongitude) != Math.signum(lastLongitude) && Math.abs(currentLongitude) > 90.0 && Math.abs(lastLongitude) > 90.0) {
                    Polyline polyline = new Polyline(positions);
                    polylines.add(polyline);
                    positions.clear();
                }
            }
            positions.add(position);
        }
        if (!positions.isEmpty()) {
            Polyline polyline = new Polyline(positions);
            polylines.add(polyline);
        }
        return polylines;
    }

    public static Color convertFrom(Color3f color3f) {
        return new Color(color3f.x, color3f.y, color3f.z);
    }

    private static void getAllKMLAbstractFeatureOfType(Class<?> kmlAbstractFeatureClass, KMLAbstractFeature root, List<KMLAbstractFeature> featureList) {
        if (kmlAbstractFeatureClass.isAssignableFrom(root.getClass())) {
            featureList.add(root);
        }
        if (root instanceof KMLAbstractContainer) {
            KMLAbstractContainer container = (KMLAbstractContainer)root;
            for (KMLAbstractFeature feature : container.getFeatures()) {
                WorldWindUtils.getAllKMLAbstractFeatureOfType(kmlAbstractFeatureClass, feature, featureList);
            }
        }
    }

    public static List<KMLAbstractFeature> getAllKMLAbstractFeatureOfType(Class<?> kmlAbstractFeatureClass, KMLDocument kmlDocument) {
        ArrayList<KMLAbstractFeature> features = new ArrayList<KMLAbstractFeature>();
        WorldWindUtils.getAllKMLAbstractFeatureOfType(kmlAbstractFeatureClass, (KMLAbstractFeature)kmlDocument, features);
        return features;
    }
}

