/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.orbit.earth.ui.composites;

import java.util.Date;
import org.eclipse.apogy.core.environment.orbit.earth.ui.composites.SpacecraftsVisibilitySetComposite;
import org.eclipse.apogy.core.environment.orbit.earth.ui.composites.ViewerElement;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public class SpacecraftVisibilitySetViewerComparator
extends ViewerComparator {
    public static final int DESCENDING = 1;
    private SpacecraftsVisibilitySetComposite.SpacecraftsVisibilitySetColumns column = SpacecraftsVisibilitySetComposite.SpacecraftsVisibilitySetColumns.GROUND_STATION;
    private int direction = 1;

    public int getDirection() {
        return this.direction;
    }

    public void setColumn(SpacecraftsVisibilitySetComposite.SpacecraftsVisibilitySetColumns column) {
        if (this.column == column) {
            this.direction = 1 - this.direction;
        } else {
            this.column = column;
            this.direction = 1;
        }
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        ViewerElement viewerElement1 = (ViewerElement)e1;
        ViewerElement viewerElement2 = (ViewerElement)e2;
        int rc = 0;
        switch (this.column) {
            case GROUND_STATION: {
                try {
                    String s1 = viewerElement1.groundStation.getName();
                    String s2 = viewerElement2.groundStation.getName();
                    if (s1 == null) {
                        s1 = "";
                    }
                    if (s2 == null) {
                        s2 = "";
                    }
                    rc = s1.compareTo(s2);
                }
                catch (Throwable s1) {}
                break;
            }
            case SPACECRAFT: {
                try {
                    String s1 = viewerElement1.pass.getOrbitModel().getName();
                    String s2 = viewerElement2.pass.getOrbitModel().getName();
                    if (s1 == null) {
                        s1 = "";
                    }
                    if (s2 == null) {
                        s2 = "";
                    }
                    rc = s1.compareTo(s2);
                }
                catch (Throwable s1) {}
                break;
            }
            case START_DATE: {
                try {
                    Date date1 = viewerElement1.pass.getStartTime();
                    Date date2 = viewerElement2.pass.getStartTime();
                    rc = date1.compareTo(date2);
                }
                catch (Throwable date1) {}
                break;
            }
            case END_DATE: {
                try {
                    Date date1 = viewerElement1.pass.getEndTime();
                    Date date2 = viewerElement2.pass.getEndTime();
                    rc = date1.compareTo(date2);
                }
                catch (Throwable throwable) {}
                break;
            }
            case DURATION: {
                if (viewerElement1.pass.getDuration() > viewerElement2.pass.getDuration()) {
                    rc = 1;
                    break;
                }
                if (!(viewerElement1.pass.getDuration() < viewerElement2.pass.getDuration())) break;
                rc = -1;
                break;
            }
        }
        if (this.direction == 1) {
            rc = -rc;
        }
        return rc;
    }
}

