/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.orbit.earth.ui.composites;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import org.eclipse.apogy.core.environment.orbit.earth.VisibilityPassSpacecraftPosition;
import org.eclipse.apogy.core.environment.orbit.earth.VisibilityPassSpacecraftPositionHistory;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.experimental.chart.swt.ChartComposite;
import org.jfree.ui.RectangleInsets;

public class VisibilityPassSpacecraftPositionHistoryAnglesComposite
extends Composite {
    private VisibilityPassSpacecraftPositionHistory positionHistory = null;
    private TimeSeriesCollection alongAngleDataSet = null;
    private TimeSeriesCollection crossAngleDataSet = null;
    private TimeSeries alongTrackAngleTimeSeries = null;
    private TimeSeries crossTrackAngleTimeSeries = null;
    private JFreeChart chart;

    public VisibilityPassSpacecraftPositionHistoryAnglesComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        new ChartComposite((Composite)this, 0, this.getChart(), true);
    }

    public VisibilityPassSpacecraftPositionHistory getPositionHistory() {
        return this.positionHistory;
    }

    public void setPositionHistory(VisibilityPassSpacecraftPositionHistory positionHistory) {
        this.getAlongTrackAngleTimeSeries().clear();
        this.getCrossTrackAngleTimeSeries().clear();
        this.positionHistory = positionHistory;
        if (positionHistory != null) {
            this.populateAlongTrackTimeSeries(this.getAlongTrackAngleTimeSeries(), positionHistory);
            this.populateCrossTrackTimeSeries(this.getCrossTrackAngleTimeSeries(), positionHistory);
        }
    }

    protected JFreeChart getChart() {
        if (this.chart == null) {
            String chartTitle = "Angles vs Time";
            String chartXAxisLabel = "Time (s)";
            String chartYAxisLabel = "Along Track Angle (deg)";
            this.chart = ChartFactory.createTimeSeriesChart((String)chartTitle, (String)chartXAxisLabel, (String)chartYAxisLabel, (XYDataset)this.getAlongAngleDataSet(), (boolean)true, (boolean)true, (boolean)false);
            this.chart.setBackgroundPaint((Paint)Color.white);
            XYPlot plot = (XYPlot)this.chart.getPlot();
            NumberAxis axis2 = new NumberAxis("Cross Track Angle (deg)");
            axis2.setAutoRangeIncludesZero(false);
            plot.setRangeAxis(1, (ValueAxis)axis2);
            plot.setDataset(1, (XYDataset)this.getCrossAngleDataSet());
            plot.mapDatasetToRangeAxis(1, 1);
            plot.setBackgroundPaint((Paint)Color.white);
            plot.setDomainGridlinePaint((Paint)Color.black);
            plot.setRangeGridlinePaint((Paint)Color.black);
            plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
            plot.setDomainCrosshairVisible(true);
            plot.setRangeCrosshairVisible(true);
            plot.setDomainMinorGridlinesVisible(false);
            plot.setRangeMinorGridlinesVisible(false);
            plot.setDomainGridlinesVisible(true);
            plot.setRangeGridlinesVisible(true);
            XYItemRenderer xyItemRenderer = plot.getRenderer();
            if (xyItemRenderer instanceof XYLineAndShapeRenderer) {
                XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)xyItemRenderer;
                renderer.setBaseShapesVisible(false);
                renderer.setBaseShapesFilled(false);
                renderer.setSeriesStroke(0, (Stroke)new BasicStroke(2.0f));
                renderer.setSeriesPaint(0, (Paint)Color.BLUE);
            }
            StandardXYItemRenderer renderer2 = new StandardXYItemRenderer();
            renderer2.setSeriesPaint(0, (Paint)Color.RED);
            renderer2.setSeriesStroke(0, (Stroke)new BasicStroke(2.0f));
            plot.setRenderer(1, (XYItemRenderer)renderer2);
            plot.getRangeAxis().setAutoRange(true);
            plot.getDomainAxis().setAutoRange(true);
        }
        return this.chart;
    }

    protected TimeSeriesCollection getAlongAngleDataSet() {
        if (this.alongAngleDataSet == null) {
            this.alongAngleDataSet = new TimeSeriesCollection();
            this.alongAngleDataSet.addSeries(this.getAlongTrackAngleTimeSeries());
        }
        return this.alongAngleDataSet;
    }

    protected TimeSeriesCollection getCrossAngleDataSet() {
        if (this.crossAngleDataSet == null) {
            this.crossAngleDataSet = new TimeSeriesCollection();
            this.crossAngleDataSet.addSeries(this.getCrossTrackAngleTimeSeries());
        }
        return this.crossAngleDataSet;
    }

    public TimeSeries getAlongTrackAngleTimeSeries() {
        if (this.alongTrackAngleTimeSeries == null) {
            this.alongTrackAngleTimeSeries = new TimeSeries((Comparable)((Object)"Along Track Angle (deg)"));
            if (this.getPositionHistory() != null) {
                this.populateAlongTrackTimeSeries(this.alongTrackAngleTimeSeries, this.getPositionHistory());
            }
        }
        return this.alongTrackAngleTimeSeries;
    }

    public TimeSeries getCrossTrackAngleTimeSeries() {
        if (this.crossTrackAngleTimeSeries == null) {
            this.crossTrackAngleTimeSeries = new TimeSeries((Comparable)((Object)"Cross Track Angle (deg)"));
            if (this.getPositionHistory() != null) {
                this.populateCrossTrackTimeSeries(this.crossTrackAngleTimeSeries, this.getPositionHistory());
            }
        }
        return this.crossTrackAngleTimeSeries;
    }

    protected void populateAlongTrackTimeSeries(TimeSeries alongTrackTimeSeries, VisibilityPassSpacecraftPositionHistory positionHistory) {
        for (VisibilityPassSpacecraftPosition position : positionHistory.getPositions()) {
            double akongTrackAngle = Math.toDegrees(position.getSpacecraftAlongTrackAngle());
            alongTrackTimeSeries.addOrUpdate((RegularTimePeriod)new Millisecond(position.getTime()), akongTrackAngle);
        }
    }

    protected void populateCrossTrackTimeSeries(TimeSeries crossTrackTimeSeries, VisibilityPassSpacecraftPositionHistory positionHistory) {
        for (VisibilityPassSpacecraftPosition position : positionHistory.getPositions()) {
            double crossTrackAngle = Math.toDegrees(position.getSpacecraftCrossTrackAngle());
            crossTrackTimeSeries.addOrUpdate((RegularTimePeriod)new Millisecond(position.getTime()), crossTrackAngle);
        }
    }
}

