/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.orbit.earth.ui.composites;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import org.eclipse.apogy.core.environment.orbit.earth.VisibilityPassSpacecraftPosition;
import org.eclipse.apogy.core.environment.orbit.earth.VisibilityPassSpacecraftPositionHistory;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.experimental.chart.swt.ChartComposite;
import org.jfree.ui.RectangleInsets;

public class VisibilityPassSpacecraftPositionHistoryRangeComposite
extends Composite {
    private VisibilityPassSpacecraftPositionHistory positionHistory = null;
    private TimeSeriesCollection rangeDataSet = null;
    private TimeSeriesCollection rangeRateDataSet = null;
    private TimeSeries rangeTimeSeries = null;
    private TimeSeries rangeRateTimeSeries = null;
    private JFreeChart chart;

    public VisibilityPassSpacecraftPositionHistoryRangeComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        new ChartComposite((Composite)this, 0, this.getChart(), true);
    }

    public VisibilityPassSpacecraftPositionHistory getPositionHistory() {
        return this.positionHistory;
    }

    public void setPositionHistory(VisibilityPassSpacecraftPositionHistory positionHistory) {
        this.getRangeTimeSeries().clear();
        this.getRangeRateTimeSeries().clear();
        this.positionHistory = positionHistory;
        if (positionHistory != null) {
            this.populateRangeTimeSeries(this.getRangeTimeSeries(), positionHistory);
            this.populateRangeRateTimeSeries(this.getRangeRateTimeSeries(), positionHistory);
        }
    }

    protected JFreeChart getChart() {
        if (this.chart == null) {
            String chartTitle = "Range and Range Rate vs Time";
            String chartXAxisLabel = "Time (s)";
            String chartYAxisLabel = "Range (km)";
            this.chart = ChartFactory.createTimeSeriesChart((String)chartTitle, (String)chartXAxisLabel, (String)chartYAxisLabel, (XYDataset)this.getRangeDataSet(), (boolean)true, (boolean)true, (boolean)false);
            this.chart.setBackgroundPaint((Paint)Color.white);
            XYPlot plot = (XYPlot)this.chart.getPlot();
            NumberAxis axis2 = new NumberAxis("Range Rate (km/s)");
            axis2.setAutoRangeIncludesZero(false);
            plot.setRangeAxis(1, (ValueAxis)axis2);
            plot.setDataset(1, (XYDataset)this.getRangeRateDataSet());
            plot.mapDatasetToRangeAxis(1, 1);
            plot.setBackgroundPaint((Paint)Color.white);
            plot.setDomainGridlinePaint((Paint)Color.black);
            plot.setRangeGridlinePaint((Paint)Color.black);
            plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
            plot.setDomainCrosshairVisible(true);
            plot.setRangeCrosshairVisible(true);
            plot.setDomainMinorGridlinesVisible(false);
            plot.setRangeMinorGridlinesVisible(false);
            plot.setDomainGridlinesVisible(true);
            plot.setRangeGridlinesVisible(true);
            XYItemRenderer xyItemRenderer = plot.getRenderer();
            if (xyItemRenderer instanceof XYLineAndShapeRenderer) {
                XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)xyItemRenderer;
                renderer.setBaseShapesVisible(false);
                renderer.setBaseShapesFilled(false);
                renderer.setSeriesStroke(0, (Stroke)new BasicStroke(2.0f));
                renderer.setSeriesPaint(0, (Paint)Color.BLUE);
            }
            StandardXYItemRenderer renderer2 = new StandardXYItemRenderer();
            renderer2.setSeriesPaint(0, (Paint)Color.RED);
            renderer2.setSeriesStroke(0, (Stroke)new BasicStroke(2.0f));
            plot.setRenderer(1, (XYItemRenderer)renderer2);
            plot.getRangeAxis().setAutoRange(true);
            plot.getDomainAxis().setAutoRange(true);
        }
        return this.chart;
    }

    protected TimeSeriesCollection getRangeDataSet() {
        if (this.rangeDataSet == null) {
            this.rangeDataSet = new TimeSeriesCollection();
            this.rangeDataSet.addSeries(this.getRangeTimeSeries());
        }
        return this.rangeDataSet;
    }

    protected TimeSeriesCollection getRangeRateDataSet() {
        if (this.rangeRateDataSet == null) {
            this.rangeRateDataSet = new TimeSeriesCollection();
            this.rangeRateDataSet.addSeries(this.getRangeRateTimeSeries());
        }
        return this.rangeRateDataSet;
    }

    public TimeSeries getRangeTimeSeries() {
        if (this.rangeTimeSeries == null) {
            this.rangeTimeSeries = new TimeSeries((Comparable)((Object)"Range (km)"));
            if (this.getPositionHistory() != null) {
                this.populateRangeTimeSeries(this.rangeTimeSeries, this.getPositionHistory());
            }
        }
        return this.rangeTimeSeries;
    }

    public TimeSeries getRangeRateTimeSeries() {
        if (this.rangeRateTimeSeries == null) {
            this.rangeRateTimeSeries = new TimeSeries((Comparable)((Object)"Range Rate (km/s)"));
            if (this.getPositionHistory() != null) {
                this.populateRangeRateTimeSeries(this.rangeRateTimeSeries, this.getPositionHistory());
            }
        }
        return this.rangeRateTimeSeries;
    }

    protected void populateRangeTimeSeries(TimeSeries rangeTimeSeries, VisibilityPassSpacecraftPositionHistory positionHistory) {
        for (VisibilityPassSpacecraftPosition position : positionHistory.getPositions()) {
            double rangeKM = position.getRange() * 0.001;
            rangeTimeSeries.addOrUpdate((RegularTimePeriod)new Millisecond(position.getTime()), rangeKM);
        }
    }

    protected void populateRangeRateTimeSeries(TimeSeries rangeRateTimeSeries, VisibilityPassSpacecraftPositionHistory positionHistory) {
        for (VisibilityPassSpacecraftPosition position : positionHistory.getPositions()) {
            double rangeRateKMS = position.getRangeRate() * 0.001;
            rangeRateTimeSeries.addOrUpdate((RegularTimePeriod)new Millisecond(position.getTime()), rangeRateKMS);
        }
    }
}

