/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.orbit.earth.ui.impl;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Cone;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfaceCircle;
import javax.vecmath.Color3f;
import org.eclipse.apogy.addons.sensors.fov.ConicalFieldOfView;
import org.eclipse.apogy.addons.sensors.fov.DistanceRange;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.ApogyCorePackage;
import org.eclipse.apogy.core.environment.earth.EarthSurfaceLocation;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;
import org.eclipse.apogy.core.environment.earth.ui.utils.WorldWindUtils;
import org.eclipse.apogy.core.environment.orbit.earth.ConstantElevationMask;
import org.eclipse.apogy.core.environment.orbit.earth.ElevationMask;
import org.eclipse.apogy.core.environment.orbit.earth.GroundStation;
import org.eclipse.apogy.core.environment.orbit.earth.ui.impl.AbstractGroundStationWorldWindLayerImpl;
import org.eclipse.apogy.core.environment.orbit.earth.ui.utils.MultiEObjectsAdapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGroundStationWorldWindLayerCustomImpl
extends AbstractGroundStationWorldWindLayerImpl {
    private static final Logger Logger = LoggerFactory.getLogger(AbstractGroundStationWorldWindLayerImpl.class);
    private MultiEObjectsAdapter groundStationAdapter = null;

    @Override
    public void setGroundStation(GroundStation newGroundStation) {
        this.getGroundStationAdapter().unregisterFromAllObjects();
        super.setGroundStation(newGroundStation);
        if (newGroundStation != null) {
            this.getGroundStationAdapter().registerToEObject((EObject)newGroundStation);
        }
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void setReferenceAltitude(double newReferenceAltitude) {
        super.setReferenceAltitude(newReferenceAltitude);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void setShowVisibilityCircle(boolean newShowVisibilityCircle) {
        super.setShowVisibilityCircle(newShowVisibilityCircle);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void setShowVisibilityCone(boolean newShowVisibilityCone) {
        super.setShowVisibilityCone(newShowVisibilityCone);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void setShowOutline(boolean newShowOutline) {
        super.setShowOutline(newShowOutline);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void setName(String newName) {
        super.setName(newName);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public boolean getDefaultAutoUpdateEnabled() {
        return true;
    }

    public EarthSurfaceLocation getEarthSurfaceLocation() {
        return this.getGroundStation();
    }

    public void dispose() {
        this.getGroundStationAdapter().unregisterFromAllObjects();
        super.dispose();
    }

    protected void updateRenderableLayer() {
        if (!this.isUpdating() && this.eContainer() != null) {
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyCorePackage.Literals.UPDATABLE__UPDATING, (Object)true, true);
            RenderableLayer layer = this.getRenderableLayer();
            layer.removeAllRenderables();
            if (this.isVisible() && !this.isDisposed() && this.getGroundStation() != null) {
                AbstractGroundStationWorldWindLayerCustomImpl.super.addRenderable(layer);
                GroundStation coord = this.getGroundStation();
                Angle latitude = Angle.fromRadiansLatitude((double)coord.getLatitude());
                Angle longitude = Angle.fromRadiansLongitude((double)coord.getLongitude());
                double elevation = coord.getElevation();
                Position position = new Position(latitude, longitude, elevation);
                if (this.getGroundStation().getElevationMask() instanceof ConstantElevationMask) {
                    double h;
                    double r;
                    ConstantElevationMask cFOV = (ConstantElevationMask)this.getGroundStation().getElevationMask();
                    double refAltitude = this.getReferenceAltitude() * 1000.0;
                    double radius = this.computeGroundCircle(cFOV, refAltitude);
                    BasicShapeAttributes fovAttributes = new BasicShapeAttributes();
                    fovAttributes.setDrawInterior(true);
                    fovAttributes.setOutlineOpacity(0.95);
                    fovAttributes.setDrawOutline(this.isShowOutline());
                    Material interiorMat = new Material(WorldWindUtils.convertFrom((Color3f)this.getColor()));
                    fovAttributes.setInteriorMaterial(interiorMat);
                    fovAttributes.setDrawInterior(true);
                    fovAttributes.setInteriorOpacity(this.getOpacity());
                    Material outlineMat = new Material(WorldWindUtils.convertFrom((Color3f)this.getColor()));
                    fovAttributes.setOutlineMaterial(outlineMat);
                    if (this.isShowVisibilityCircle()) {
                        SurfaceCircle visibilityCircle = new SurfaceCircle((ShapeAttributes)fovAttributes, (LatLon)position, radius, 36);
                        visibilityCircle.setVisible(true);
                        layer.addRenderable((Renderable)visibilityCircle);
                    }
                    if (this.isShowVisibilityCone() && cFOV.getConstantElevation() > 0.0 && (r = (h = this.getReferenceAltitude() * 1000.0) / Math.tan(cFOV.getConstantElevation())) > 0.0) {
                        double northSouthRadius = r;
                        double verticalRadius = h;
                        double eastWestRadius = r;
                        Angle heading = Angle.fromDegrees((double)0.0);
                        Angle tilt = Angle.fromDegrees((double)180.0);
                        Angle roll = Angle.fromDegrees((double)0.0);
                        Cone cone = new Cone(new Position(latitude, longitude, elevation + verticalRadius), northSouthRadius, verticalRadius, eastWestRadius, heading, tilt, roll);
                        cone.setAttributes((ShapeAttributes)fovAttributes);
                        layer.addRenderable((Renderable)cone);
                    }
                }
            }
            this.getRenderableLayer().firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, (Object)this);
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyCorePackage.Literals.UPDATABLE__UPDATING, (Object)false, true);
        }
    }

    protected double computeGroundCircle(ConstantElevationMask constantElevationMask, double range) {
        double radius = 0.0;
        double A = 1.5707963267948966 + constantElevationMask.getConstantElevation();
        double a = 6378137.0 + range;
        double b = 6378137.0;
        double B = Math.asin(b / a * Math.sin(A));
        double C = Math.PI - A - B;
        radius = C * 6378137.0;
        return radius;
    }

    protected MultiEObjectsAdapter getGroundStationAdapter() {
        if (this.groundStationAdapter == null) {
            this.groundStationAdapter = new MultiEObjectsAdapter(){

                @Override
                public void registerToEObject(EObject eObject) {
                    if (eObject instanceof GroundStation) {
                        GroundStation newGroundStation = (GroundStation)eObject;
                        super.registerToEObject((EObject)newGroundStation);
                        if (newGroundStation.getElevationMask() != null) {
                            newGroundStation.getElevationMask().eAdapters().add((Object)this);
                        }
                    } else {
                        eObject.eAdapters().add((Object)this);
                    }
                }

                public void notifyChanged(Notification msg) {
                    block40: {
                        block44: {
                            block43: {
                                block42: {
                                    block41: {
                                        block39: {
                                            if (!(msg.getNotifier() instanceof GroundStation)) break block39;
                                            int featureId = msg.getFeatureID(GroundStation.class);
                                            switch (featureId) {
                                                case 3: {
                                                    if (AbstractGroundStationWorldWindLayerCustomImpl.this.isAutoUpdateEnabled()) {
                                                        try {
                                                            AbstractGroundStationWorldWindLayerCustomImpl.this.update();
                                                        }
                                                        catch (Exception e) {
                                                            Logger.error(e.getMessage(), (Throwable)e);
                                                        }
                                                        break;
                                                    }
                                                    break block40;
                                                }
                                                case 6: {
                                                    if (msg.getOldValue() instanceof ElevationMask) {
                                                        ((ElevationMask)msg.getOldValue()).eAdapters().remove((Object)this);
                                                    }
                                                    if (msg.getNewValue() instanceof ElevationMask) {
                                                        ((ElevationMask)msg.getNewValue()).eAdapters().add((Object)this);
                                                    }
                                                    if (AbstractGroundStationWorldWindLayerCustomImpl.this.isAutoUpdateEnabled()) {
                                                        try {
                                                            AbstractGroundStationWorldWindLayerCustomImpl.this.update();
                                                        }
                                                        catch (Exception e) {
                                                            Logger.error(e.getMessage(), (Throwable)e);
                                                        }
                                                        break;
                                                    }
                                                    break block40;
                                                }
                                                case 0: 
                                                case 1: 
                                                case 2: {
                                                    if (AbstractGroundStationWorldWindLayerCustomImpl.this.isAutoUpdateEnabled()) {
                                                        try {
                                                            AbstractGroundStationWorldWindLayerCustomImpl.this.update();
                                                        }
                                                        catch (Exception e) {
                                                            Logger.error(e.getMessage(), (Throwable)e);
                                                        }
                                                        break;
                                                    }
                                                    break block40;
                                                }
                                            }
                                            break block40;
                                        }
                                        if (!(msg.getNotifier() instanceof ElevationMask)) break block41;
                                        if (AbstractGroundStationWorldWindLayerCustomImpl.this.isAutoUpdateEnabled()) {
                                            try {
                                                AbstractGroundStationWorldWindLayerCustomImpl.this.update();
                                            }
                                            catch (Exception e) {
                                                Logger.error(e.getMessage(), (Throwable)e);
                                            }
                                        }
                                        break block40;
                                    }
                                    if (!(msg.getNotifier() instanceof GeographicCoordinates)) break block42;
                                    if (AbstractGroundStationWorldWindLayerCustomImpl.this.isAutoUpdateEnabled()) {
                                        try {
                                            AbstractGroundStationWorldWindLayerCustomImpl.this.update();
                                        }
                                        catch (Exception e) {
                                            Logger.error(e.getMessage(), (Throwable)e);
                                        }
                                    }
                                    break block40;
                                }
                                if (!(msg.getNotifier() instanceof DistanceRange)) break block43;
                                if (AbstractGroundStationWorldWindLayerCustomImpl.this.isAutoUpdateEnabled()) {
                                    try {
                                        AbstractGroundStationWorldWindLayerCustomImpl.this.update();
                                    }
                                    catch (Exception e) {
                                        Logger.error(e.getMessage(), (Throwable)e);
                                    }
                                }
                                break block40;
                            }
                            if (!(msg.getNotifier() instanceof ConicalFieldOfView)) break block44;
                            int featureId = msg.getFeatureID(ConicalFieldOfView.class);
                            switch (featureId) {
                                case 3: {
                                    if (msg.getOldValue() instanceof DistanceRange) {
                                        AbstractGroundStationWorldWindLayerCustomImpl.this.getGroundStationAdapter().unregisterFromEObject((EObject)((DistanceRange)msg.getOldValue()));
                                    }
                                    if (msg.getNewValue() instanceof DistanceRange) {
                                        AbstractGroundStationWorldWindLayerCustomImpl.this.getGroundStationAdapter().registerToEObject((EObject)((DistanceRange)msg.getNewValue()));
                                    }
                                    if (AbstractGroundStationWorldWindLayerCustomImpl.this.isAutoUpdateEnabled()) {
                                        try {
                                            AbstractGroundStationWorldWindLayerCustomImpl.this.update();
                                        }
                                        catch (Exception e) {
                                            Logger.error(e.getMessage(), (Throwable)e);
                                        }
                                        break;
                                    }
                                    break block40;
                                }
                                default: {
                                    if (AbstractGroundStationWorldWindLayerCustomImpl.this.isAutoUpdateEnabled()) {
                                        try {
                                            AbstractGroundStationWorldWindLayerCustomImpl.this.update();
                                        }
                                        catch (Exception e) {
                                            Logger.error(e.getMessage(), (Throwable)e);
                                        }
                                        break;
                                    }
                                    break block40;
                                }
                            }
                            break block40;
                        }
                        if (AbstractGroundStationWorldWindLayerCustomImpl.this.isAutoUpdateEnabled()) {
                            try {
                                AbstractGroundStationWorldWindLayerCustomImpl.this.update();
                            }
                            catch (Exception e) {
                                Logger.error(e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                }
            };
        }
        return this.groundStationAdapter;
    }
}

