/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.orbit.earth.ui.utils;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.ExtrudedPolygon;
import gov.nasa.worldwind.render.Polygon;
import gov.nasa.worldwind.render.Polyline;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;
import org.eclipse.apogy.core.environment.orbit.SpacecraftState;
import org.eclipse.apogy.core.environment.orbit.earth.ApogyCoreEnvironmentOrbitEarthFacade;
import org.eclipse.apogy.core.environment.orbit.earth.Corridor;
import org.eclipse.apogy.core.environment.orbit.earth.CorridorPoint;
import org.eclipse.apogy.core.environment.orbit.earth.OreKitBackedSpacecraftState;

public class WorldWindUtils {
    public static Position convertToPosition(GeographicCoordinates geographicCoordinates) {
        Angle latitude = Angle.fromRadiansLatitude((double)geographicCoordinates.getLatitude());
        Angle longitude = Angle.fromRadiansLongitude((double)geographicCoordinates.getLongitude());
        double elevation = geographicCoordinates.getElevation();
        Position position = new Position(latitude, longitude, elevation);
        return position;
    }

    public static List<Polyline> createPolyLineFromGeographicCoordinatesListNoWrapAround(List<GeographicCoordinates> coordinatesList) {
        ArrayList<Polyline> polylines = new ArrayList<Polyline>();
        LinkedList<Position> positions = new LinkedList<Position>();
        for (GeographicCoordinates coord : coordinatesList) {
            Position position = WorldWindUtils.convertToPosition(coord);
            if (positions.size() > 0) {
                double currentLongitude = position.longitude.getDegrees();
                double lastLongitude = ((Position)positions.getLast()).longitude.getDegrees();
                if (Math.signum(currentLongitude) != Math.signum(lastLongitude) && Math.abs(currentLongitude) > 90.0 && Math.abs(lastLongitude) > 90.0) {
                    Polyline polyline = new Polyline(positions);
                    polylines.add(polyline);
                    positions.clear();
                }
            }
            positions.add(position);
        }
        if (!positions.isEmpty()) {
            Polyline polyline = new Polyline(positions);
            polylines.add(polyline);
        }
        return polylines;
    }

    public static Polyline createPolyLine(List<SpacecraftState> spacecraftStates) throws Exception {
        LinkedList<Position> positions = new LinkedList<Position>();
        for (SpacecraftState ss : spacecraftStates) {
            if (!(ss instanceof OreKitBackedSpacecraftState)) continue;
            GeographicCoordinates coord = ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.convertToGeographicCoordinates((OreKitBackedSpacecraftState)ss);
            Position position = WorldWindUtils.convertToPosition(coord);
            positions.add(position);
        }
        Polyline polyline = new Polyline(positions);
        return polyline;
    }

    public static List<Polyline> createPolyLineWithNoWrapAround(List<SpacecraftState> spacecraftStates) throws Exception {
        ArrayList<Polyline> polylines = new ArrayList<Polyline>();
        LinkedList<Position> positions = new LinkedList<Position>();
        for (SpacecraftState ss : spacecraftStates) {
            if (ss instanceof OreKitBackedSpacecraftState) {
                GeographicCoordinates coord = ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.convertToGeographicCoordinates((OreKitBackedSpacecraftState)ss);
                Position position = WorldWindUtils.convertToPosition(coord);
                if (positions.size() > 0) {
                    double currentLongitude = position.longitude.getDegrees();
                    double lastLongitude = ((Position)positions.getLast()).longitude.getDegrees();
                    if (Math.signum(currentLongitude) != Math.signum(lastLongitude) && Math.abs(currentLongitude) > 90.0 && Math.abs(lastLongitude) > 90.0) {
                        Polyline polyline = new Polyline(positions);
                        polylines.add(polyline);
                        positions.clear();
                    }
                }
                positions.add(position);
            }
            if (positions.isEmpty()) continue;
            Polyline polyline = new Polyline(positions);
            polylines.add(polyline);
        }
        return polylines;
    }

    public static List<Polygon> createPolygons(Corridor corridor) {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        if (corridor.getPoints().size() > 1) {
            int index = 1;
            int maxIndex = corridor.getPoints().size() - 1;
            CorridorPoint p0 = (CorridorPoint)corridor.getPoints().get(0);
            while (index < maxIndex) {
                CorridorPoint p1 = (CorridorPoint)corridor.getPoints().get(index);
                Position p0Left = WorldWindUtils.convertToPosition(p0.getLeft());
                Position p0Right = WorldWindUtils.convertToPosition(p0.getRight());
                Position p1Left = WorldWindUtils.convertToPosition(p1.getLeft());
                Position p1Right = WorldWindUtils.convertToPosition(p1.getRight());
                ArrayList<Position> polygon0List = new ArrayList<Position>();
                polygon0List.add(p0Left);
                polygon0List.add(p0Right);
                polygon0List.add(p1Right);
                polygon0List.add(p1Left);
                Polygon polygon0 = new Polygon(polygon0List);
                polygons.add(polygon0);
                p0 = p1;
                ++index;
            }
        }
        return polygons;
    }

    public static List<ExtrudedPolygon> createExtrudedPolygons(Corridor corridor, double height) {
        ArrayList<ExtrudedPolygon> polygons = new ArrayList<ExtrudedPolygon>();
        if (corridor.getPoints().size() > 1) {
            int index = 1;
            int maxIndex = corridor.getPoints().size() - 1;
            CorridorPoint p0 = (CorridorPoint)corridor.getPoints().get(0);
            while (index <= maxIndex) {
                CorridorPoint p1 = (CorridorPoint)corridor.getPoints().get(index);
                Position p0Left = WorldWindUtils.convertToPosition(p0.getLeft());
                Position p0Right = WorldWindUtils.convertToPosition(p0.getRight());
                Position p1Left = WorldWindUtils.convertToPosition(p1.getLeft());
                Position p1Right = WorldWindUtils.convertToPosition(p1.getRight());
                ArrayList<Position> polygon0List = new ArrayList<Position>();
                polygon0List.add(p0Left);
                polygon0List.add(p0Right);
                polygon0List.add(p1Right);
                polygon0List.add(p1Left);
                ExtrudedPolygon polygon0 = new ExtrudedPolygon(polygon0List, Double.valueOf(height));
                polygons.add(polygon0);
                p0 = p1;
                ++index;
            }
        }
        return polygons;
    }
}

