/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.orbit.earth;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum EphemerisType implements Enumerator
{
    DEFAULT(0, "DEFAULT", "DEFAULT"),
    SGP(1, "SGP", "SGP"),
    SGP4(2, "SGP4", "SGP4"),
    SDP4(3, "SDP4", "SDP4"),
    SGP8(4, "SGP8", "SGP8"),
    SDP8(5, "SDP8", "SDP8");

    public static final int DEFAULT_VALUE = 0;
    public static final int SGP_VALUE = 1;
    public static final int SGP4_VALUE = 2;
    public static final int SDP4_VALUE = 3;
    public static final int SGP8_VALUE = 4;
    public static final int SDP8_VALUE = 5;
    private static final EphemerisType[] VALUES_ARRAY;
    public static final List<EphemerisType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EphemerisType[]{DEFAULT, SGP, SGP4, SDP4, SGP8, SDP8};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EphemerisType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EphemerisType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EphemerisType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EphemerisType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EphemerisType get(int value) {
        switch (value) {
            case 0: {
                return DEFAULT;
            }
            case 1: {
                return SGP;
            }
            case 2: {
                return SGP4;
            }
            case 3: {
                return SDP4;
            }
            case 4: {
                return SGP8;
            }
            case 5: {
                return SDP8;
            }
        }
        return null;
    }

    private EphemerisType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

