/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.orbit.earth.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.vecmath.Matrix3d;
import org.apache.commons.math3.geometry.euclidean.threed.Line;
import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.ApogyCommonMathFactory;
import org.eclipse.apogy.common.math.Matrix3x3;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.core.environment.earth.ApogyEarthFacade;
import org.eclipse.apogy.core.environment.earth.EarthSurfaceLocation;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;
import org.eclipse.apogy.core.environment.orbit.ApogyCoreEnvironmentOrbitFactory;
import org.eclipse.apogy.core.environment.orbit.Orbit;
import org.eclipse.apogy.core.environment.orbit.SpacecraftState;
import org.eclipse.apogy.core.environment.orbit.TimedStampedAngularCoordinates;
import org.eclipse.apogy.core.environment.orbit.TimedStampedPVACoordinates;
import org.eclipse.apogy.core.environment.orbit.earth.ApogyCoreEnvironmentOrbitEarthFacade;
import org.eclipse.apogy.core.environment.orbit.earth.ApogyCoreEnvironmentOrbitEarthFactory;
import org.eclipse.apogy.core.environment.orbit.earth.CartesianEarthOrbit;
import org.eclipse.apogy.core.environment.orbit.earth.ConstantElevationMask;
import org.eclipse.apogy.core.environment.orbit.earth.EarthOrbit;
import org.eclipse.apogy.core.environment.orbit.earth.EarthOrbitModel;
import org.eclipse.apogy.core.environment.orbit.earth.EarthOrbitPropagator;
import org.eclipse.apogy.core.environment.orbit.earth.Eclipse;
import org.eclipse.apogy.core.environment.orbit.earth.EclipseEvent;
import org.eclipse.apogy.core.environment.orbit.earth.EclipseEventType;
import org.eclipse.apogy.core.environment.orbit.earth.ElevationMask;
import org.eclipse.apogy.core.environment.orbit.earth.GroundStation;
import org.eclipse.apogy.core.environment.orbit.earth.KeplerianEarthOrbit;
import org.eclipse.apogy.core.environment.orbit.earth.OreKitBackedSpacecraftState;
import org.eclipse.apogy.core.environment.orbit.earth.TLE;
import org.eclipse.apogy.core.environment.orbit.earth.TLEEarthOrbitModel;
import org.eclipse.apogy.core.environment.orbit.earth.VisibilityPass;
import org.eclipse.apogy.core.environment.orbit.earth.VisibilityPassSpacecraftPosition;
import org.eclipse.apogy.core.environment.orbit.earth.VisibilityPassSpacecraftPositionHistory;
import org.eclipse.apogy.core.environment.orbit.earth.impl.ApogyCoreEnvironmentOrbitEarthFacadeImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.orekit.bodies.BodyShape;
import org.orekit.bodies.CelestialBody;
import org.orekit.bodies.CelestialBodyFactory;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.errors.OrekitException;
import org.orekit.errors.PropagationException;
import org.orekit.frames.FactoryManagedFrame;
import org.orekit.frames.Frame;
import org.orekit.frames.FramesFactory;
import org.orekit.frames.LOFType;
import org.orekit.frames.LocalOrbitalFrame;
import org.orekit.frames.TopocentricFrame;
import org.orekit.frames.Transform;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.orbits.KeplerianOrbit;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.events.DateDetector;
import org.orekit.propagation.events.EclipseDetector;
import org.orekit.propagation.events.ElevationDetector;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.sampling.OrekitFixedStepHandler;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScalesFactory;
import org.orekit.time.TimeStamped;
import org.orekit.time.UTCScale;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApogyCoreEnvironmentOrbitEarthFacadeCustomImpl
extends ApogyCoreEnvironmentOrbitEarthFacadeImpl {
    private static final Logger Logger = LoggerFactory.getLogger(ApogyCoreEnvironmentOrbitEarthFacadeImpl.class);

    @Override
    public double getMu() {
        return 3.986004415E14;
    }

    @Override
    public AbsoluteDate createAbsoluteDate(Date date) {
        try {
            UTCScale utcScale = TimeScalesFactory.getUTC();
            return new AbsoluteDate(date, (TimeScale)utcScale);
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public Date createDate(AbsoluteDate absoluteDate) {
        try {
            UTCScale utcScale = TimeScalesFactory.getUTC();
            Date date = absoluteDate.toDate((TimeScale)utcScale);
            return date;
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
            return null;
        }
    }

    @Override
    public GeographicCoordinates getSpacecraftEarthSubPoint(OreKitBackedSpacecraftState oreKitBackedSpacecraftState) throws Exception {
        org.orekit.propagation.SpacecraftState currentState = oreKitBackedSpacecraftState.getOreKitSpacecraftState();
        OneAxisEllipsoid earth = new OneAxisEllipsoid(6378137.0, 0.0033528106647474805, (Frame)FramesFactory.getITRF((IERSConventions)IERSConventions.IERS_2010, (boolean)false));
        AbsoluteDate date = currentState.getDate();
        TimeStampedPVCoordinates pvInert = currentState.getPVCoordinates();
        Transform t = currentState.getFrame().getTransformTo(earth.getBodyFrame(), date);
        Vector3D p = t.transformPosition(pvInert.getPosition());
        Line centerLine = new Line(p, new Vector3D(0.0, 0.0, 0.0));
        GeodeticPoint centerPoint = earth.getIntersectionPoint(centerLine, p, earth.getBodyFrame(), date);
        GeographicCoordinates geographicCoordinates = ApogyEarthFacade.INSTANCE.createGeographicCoordinates(centerPoint.getLongitude(), centerPoint.getLatitude(), 0.0);
        return geographicCoordinates;
    }

    @Override
    public double getSpacecraftElevationAngle(SpacecraftState spacecraftState, EarthSurfaceLocation earthSurfaceLocation) throws Exception {
        OreKitBackedSpacecraftState oss = (OreKitBackedSpacecraftState)spacecraftState;
        GeodeticPoint location = new GeodeticPoint(earthSurfaceLocation.getLatitude(), earthSurfaceLocation.getLongitude(), earthSurfaceLocation.getElevation());
        FactoryManagedFrame earthFrame = FramesFactory.getITRF((IERSConventions)IERSConventions.IERS_2010, (boolean)true);
        OneAxisEllipsoid earth = new OneAxisEllipsoid(6378137.0, 0.0033528106647474805, (Frame)earthFrame);
        TopocentricFrame loc = new TopocentricFrame((BodyShape)earth, location, "location");
        FactoryManagedFrame inertialFrame = FramesFactory.getEME2000();
        LocalOrbitalFrame lof = new LocalOrbitalFrame((Frame)inertialFrame, LOFType.QSW, (PVCoordinatesProvider)oss.getOreKitSpacecraftState().getOrbit(), "QSW");
        PVCoordinates pv = lof.getTransformTo((Frame)loc, oss.getOreKitSpacecraftState().getDate()).transformPVCoordinates(PVCoordinates.ZERO);
        double l = Math.sqrt(pv.getPosition().getX() * pv.getPosition().getX() + pv.getPosition().getY() * pv.getPosition().getY());
        double elevation = Math.atan2(pv.getPosition().getZ(), l);
        return elevation;
    }

    @Override
    public double getSpacecraftAzimuthAngle(SpacecraftState spacecraftState, EarthSurfaceLocation earthSurfaceLocation) throws Exception {
        OreKitBackedSpacecraftState oss = (OreKitBackedSpacecraftState)spacecraftState;
        GeodeticPoint location = new GeodeticPoint(earthSurfaceLocation.getLatitude(), earthSurfaceLocation.getLongitude(), earthSurfaceLocation.getElevation());
        FactoryManagedFrame earthFrame = FramesFactory.getITRF((IERSConventions)IERSConventions.IERS_2010, (boolean)true);
        OneAxisEllipsoid earth = new OneAxisEllipsoid(6378137.0, 0.0033528106647474805, (Frame)earthFrame);
        TopocentricFrame loc = new TopocentricFrame((BodyShape)earth, location, "location");
        FactoryManagedFrame inertialFrame = FramesFactory.getEME2000();
        LocalOrbitalFrame lof = new LocalOrbitalFrame((Frame)inertialFrame, LOFType.QSW, (PVCoordinatesProvider)oss.getOreKitSpacecraftState().getOrbit(), "QSW");
        PVCoordinates pv = lof.getTransformTo((Frame)loc, oss.getOreKitSpacecraftState().getDate()).transformPVCoordinates(PVCoordinates.ZERO);
        double azimuth = Math.atan2(pv.getPosition().getX(), pv.getPosition().getY());
        return azimuth;
    }

    @Override
    public double getRange(SpacecraftState spacecraftState, EarthSurfaceLocation earthSurfaceLocation) throws Exception {
        OreKitBackedSpacecraftState oss = (OreKitBackedSpacecraftState)spacecraftState;
        GeodeticPoint location = new GeodeticPoint(earthSurfaceLocation.getLatitude(), earthSurfaceLocation.getLongitude(), earthSurfaceLocation.getElevation());
        FactoryManagedFrame earthFrame = FramesFactory.getITRF((IERSConventions)IERSConventions.IERS_2010, (boolean)true);
        OneAxisEllipsoid earth = new OneAxisEllipsoid(6378137.0, 0.0033528106647474805, (Frame)earthFrame);
        TopocentricFrame loc = new TopocentricFrame((BodyShape)earth, location, "location");
        FactoryManagedFrame inertialFrame = FramesFactory.getEME2000();
        LocalOrbitalFrame lof = new LocalOrbitalFrame((Frame)inertialFrame, LOFType.QSW, (PVCoordinatesProvider)oss.getOreKitSpacecraftState().getOrbit(), "QSW");
        PVCoordinates pv = lof.getTransformTo((Frame)loc, oss.getOreKitSpacecraftState().getDate()).transformPVCoordinates(PVCoordinates.ZERO);
        double range = pv.getPosition().getNorm();
        return range;
    }

    @Override
    public SpacecraftState createSpacecraftState(Orbit orbit, org.orekit.propagation.SpacecraftState oreKitSpacecraftState) {
        OreKitBackedSpacecraftState ss = ApogyCoreEnvironmentOrbitEarthFactory.eINSTANCE.createOreKitBackedSpacecraftState();
        TimedStampedPVACoordinates timedStampedPVACoordinates = this.createTimedStampedPVACoordinates(oreKitSpacecraftState.getPVCoordinates());
        ss.setCoordinates(timedStampedPVACoordinates);
        Date date = this.createDate(oreKitSpacecraftState.getDate());
        ss.setTime(date);
        ss.setOreKitSpacecraftState(oreKitSpacecraftState);
        return ss;
    }

    @Override
    public OreKitBackedSpacecraftState createOreKitBackedSpacecraftState(Orbit orbit, org.orekit.propagation.SpacecraftState oreKitSpacecraftState) {
        OreKitBackedSpacecraftState ss = ApogyCoreEnvironmentOrbitEarthFactory.eINSTANCE.createOreKitBackedSpacecraftState();
        TimedStampedPVACoordinates timedStampedPVACoordinates = this.createTimedStampedPVACoordinates(oreKitSpacecraftState.getPVCoordinates());
        ss.setCoordinates(timedStampedPVACoordinates);
        Date date = this.createDate(oreKitSpacecraftState.getDate());
        ss.setTime(date);
        ss.setOreKitSpacecraftState(oreKitSpacecraftState);
        return ss;
    }

    @Override
    public TimedStampedPVACoordinates createTimedStampedPVACoordinates(TimeStampedPVCoordinates oreKitTimeStampedPVCoordinates) {
        TimedStampedPVACoordinates coord = ApogyCoreEnvironmentOrbitFactory.eINSTANCE.createTimedStampedPVACoordinates();
        Date date = this.createDate(oreKitTimeStampedPVCoordinates.getDate());
        coord.setTime(date);
        Tuple3d position = ApogyCommonMathFacade.INSTANCE.createTuple3d(oreKitTimeStampedPVCoordinates.getPosition().getX(), oreKitTimeStampedPVCoordinates.getPosition().getY(), oreKitTimeStampedPVCoordinates.getPosition().getZ());
        coord.setPosition(position);
        Tuple3d velocity = ApogyCommonMathFacade.INSTANCE.createTuple3d(oreKitTimeStampedPVCoordinates.getVelocity().getX(), oreKitTimeStampedPVCoordinates.getVelocity().getY(), oreKitTimeStampedPVCoordinates.getVelocity().getZ());
        coord.setVelocity(velocity);
        Tuple3d acceleration = ApogyCommonMathFacade.INSTANCE.createTuple3d(oreKitTimeStampedPVCoordinates.getAcceleration().getX(), oreKitTimeStampedPVCoordinates.getAcceleration().getY(), oreKitTimeStampedPVCoordinates.getAcceleration().getZ());
        coord.setAcceleration(acceleration);
        Tuple3d angularVelocity = ApogyCommonMathFacade.INSTANCE.createTuple3d(oreKitTimeStampedPVCoordinates.getAngularVelocity().getX(), oreKitTimeStampedPVCoordinates.getAngularVelocity().getY(), oreKitTimeStampedPVCoordinates.getAngularVelocity().getZ());
        coord.setAngularVelocity(angularVelocity);
        return coord;
    }

    @Override
    public TimedStampedAngularCoordinates createTimedStampedAngularCoordinates(TimeStampedAngularCoordinates oreKitTimeStampedAngularCoordinates) {
        TimedStampedAngularCoordinates timedStampedAngularCoordinates = ApogyCoreEnvironmentOrbitFactory.eINSTANCE.createTimedStampedAngularCoordinates();
        Date date = this.createDate(oreKitTimeStampedAngularCoordinates.getDate());
        timedStampedAngularCoordinates.setTime(date);
        Tuple3d angularAcceleration = ApogyCommonMathFacade.INSTANCE.createTuple3d(oreKitTimeStampedAngularCoordinates.getRotationAcceleration().getX(), oreKitTimeStampedAngularCoordinates.getRotationAcceleration().getY(), oreKitTimeStampedAngularCoordinates.getRotationAcceleration().getZ());
        timedStampedAngularCoordinates.setAngularAcceleration(angularAcceleration);
        Matrix3x3 rotationMatrix = this.createMatrix3x3(oreKitTimeStampedAngularCoordinates.getRotation());
        timedStampedAngularCoordinates.setRotation(rotationMatrix);
        return timedStampedAngularCoordinates;
    }

    @Override
    public Matrix3x3 createMatrix3x3(Rotation rotation) {
        Matrix3x3 matrix3x3 = ApogyCommonMathFactory.eINSTANCE.createMatrix3x3();
        Matrix3d rot = new Matrix3d();
        double[][] m = rotation.getMatrix();
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                rot.setElement(i, j, m[i][j]);
                ++j;
            }
            ++i;
        }
        return matrix3x3;
    }

    @Override
    public Rotation createRotation(Matrix3x3 matrix3x3) {
        Matrix3d rot = matrix3x3.asMatrix3d();
        double[][] m = new double[][]{{0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}};
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                m[i][j] = rot.getElement(i, j);
                ++j;
            }
            ++i;
        }
        Rotation rotation = new Rotation((double[][])m, 1.0E-10);
        return rotation;
    }

    @Override
    public KeplerianEarthOrbit createKeplerianOrbit(EarthOrbitPropagator earthOrbitPropagator) throws Exception {
        if (earthOrbitPropagator.getInitialOrbit() instanceof EarthOrbit) {
            EarthOrbit eo = (EarthOrbit)earthOrbitPropagator.getInitialOrbit();
            KeplerianOrbit ko = new KeplerianOrbit(eo.getOreKitOrbit());
            return this.createKeplerianOrbit(ko);
        }
        throw new Exception("Unsupported EarthOrbitPropagator type <" + earthOrbitPropagator + "> !");
    }

    @Override
    public CartesianEarthOrbit createCartesianEarthOrbit(EarthOrbitPropagator earthOrbitPropagator) throws Exception {
        KeplerianEarthOrbit keo = this.createKeplerianOrbit(earthOrbitPropagator);
        KeplerianOrbit ko = keo.getOreKitKeplerianOrbit();
        CartesianOrbit co = new CartesianOrbit((org.orekit.orbits.Orbit)ko);
        return this.createCartesianEarthOrbit(co);
    }

    @Override
    public KeplerianEarthOrbit createKeplerianOrbit(KeplerianOrbit oreKitKeplerianOrbit) {
        KeplerianEarthOrbit keo = ApogyCoreEnvironmentOrbitEarthFactory.eINSTANCE.createKeplerianEarthOrbit();
        keo.setTime(this.createDate(oreKitKeplerianOrbit.getDate()));
        keo.setEccentricity(oreKitKeplerianOrbit.getE());
        keo.setInclination(oreKitKeplerianOrbit.getI());
        keo.setMeanAnomaly(oreKitKeplerianOrbit.getMeanAnomaly());
        keo.setTrueAnomaly(oreKitKeplerianOrbit.getTrueAnomaly());
        keo.setPerigeeArgument(oreKitKeplerianOrbit.getPerigeeArgument());
        keo.setRightAscentionOfAscendingNode(oreKitKeplerianOrbit.getRightAscensionOfAscendingNode());
        keo.setSemiMajorAxis(oreKitKeplerianOrbit.getA());
        return keo;
    }

    @Override
    public CartesianEarthOrbit createCartesianEarthOrbit(CartesianOrbit oreKitCartesianOrbit) {
        CartesianEarthOrbit ceo = ApogyCoreEnvironmentOrbitEarthFactory.eINSTANCE.createCartesianEarthOrbit();
        TimedStampedPVACoordinates pva = this.createTimedStampedPVACoordinates(oreKitCartesianOrbit.getPVCoordinates());
        ceo.setPvaCoordinates(pva);
        ceo.setTime(this.createDate(oreKitCartesianOrbit.getDate()));
        return ceo;
    }

    @Override
    public GeographicCoordinates convertToGeographicCoordinates(OreKitBackedSpacecraftState oreKitBackedSpacecraftState) throws Exception {
        GeographicCoordinates geographicCoordinates = null;
        OneAxisEllipsoid earth = new OneAxisEllipsoid(6378137.0, 0.0033528106647474805, (Frame)FramesFactory.getITRF((IERSConventions)IERSConventions.IERS_2010, (boolean)false));
        org.orekit.propagation.SpacecraftState currentState = oreKitBackedSpacecraftState.getOreKitSpacecraftState();
        AbsoluteDate date = currentState.getDate();
        TimeStampedPVCoordinates pvInert = currentState.getPVCoordinates();
        Transform t = currentState.getFrame().getTransformTo(earth.getBodyFrame(), date);
        Vector3D p = t.transformPosition(pvInert.getPosition());
        GeodeticPoint center = earth.transform(p, earth.getBodyFrame(), date);
        geographicCoordinates = ApogyEarthFacade.INSTANCE.createGeographicCoordinates(center.getLongitude(), center.getLatitude(), center.getAltitude());
        return geographicCoordinates;
    }

    @Override
    public List<SpacecraftState> getSpacecraftStates(Propagator propagator, final Date startDate, final Date endDate, double timeInterval) throws Exception {
        double duration = (double)(endDate.getTime() - startDate.getTime()) * 0.001;
        final ArrayList<SpacecraftState> states = new ArrayList<SpacecraftState>();
        propagator.setMasterMode(timeInterval, new OrekitFixedStepHandler(){

            public void init(org.orekit.propagation.SpacecraftState spacecraftState, AbsoluteDate arg1) throws PropagationException {
            }

            public void handleStep(org.orekit.propagation.SpacecraftState spacecraftState, boolean arg1) throws PropagationException {
                try {
                    Date date = ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createDate(spacecraftState.getDate());
                    if (date.getTime() >= startDate.getTime() && endDate.getTime() >= date.getTime()) {
                        EarthOrbit orbit = null;
                        if (spacecraftState.getOrbit() instanceof KeplerianOrbit) {
                            orbit = ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createKeplerianOrbit((KeplerianOrbit)spacecraftState.getOrbit());
                        } else if (spacecraftState.getOrbit() instanceof CartesianOrbit) {
                            orbit = ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createCartesianEarthOrbit((CartesianOrbit)spacecraftState.getOrbit());
                        }
                        OreKitBackedSpacecraftState ss = ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createOreKitBackedSpacecraftState(orbit, spacecraftState);
                        states.add(ss);
                    }
                }
                catch (PropagationException pe) {
                    throw pe;
                }
                catch (Exception e) {
                    throw new PropagationException((Throwable)e, null, new Object[]{this});
                }
            }
        });
        AbsoluteDate startAbsoluteDate = ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createAbsoluteDate(startDate);
        try {
            propagator.propagate(new AbsoluteDate(startAbsoluteDate, duration));
            AbsoluteDate absoluteDateEndDate = ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createAbsoluteDate(endDate);
            SpacecraftState endState = ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createSpacecraftState(null, propagator.propagate(absoluteDateEndDate));
            states.add(endState);
        }
        catch (PropagationException e1) {
            Logger.error("Error occured during execution.", (Throwable)e1);
            throw e1;
        }
        return states;
    }

    @Override
    public List<VisibilityPass> getTargetPasses(final EarthOrbitModel earthOrbitModel, final EarthSurfaceLocation earthSurfaceLocation, Date startDate, Date endDate, ElevationMask elevationMask) throws Exception {
        final ArrayList<VisibilityPass> passes = new ArrayList<VisibilityPass>();
        GeodeticPoint target = new GeodeticPoint(earthSurfaceLocation.getLatitude(), earthSurfaceLocation.getLongitude(), earthSurfaceLocation.getElevation());
        FactoryManagedFrame earthFrame = FramesFactory.getITRF((IERSConventions)IERSConventions.IERS_2010, (boolean)true);
        OneAxisEllipsoid earth = new OneAxisEllipsoid(6378137.0, 0.0033528106647474805, (Frame)earthFrame);
        String name = "?";
        if (earthSurfaceLocation.getName() != null) {
            name = earthSurfaceLocation.getName();
        }
        TopocentricFrame targetFrame = new TopocentricFrame((BodyShape)earth, target, name);
        EventHandler<ElevationDetector> eventHandler = new EventHandler<ElevationDetector>(){
            VisibilityPass lastPass = null;

            public EventHandler.Action eventOccurred(org.orekit.propagation.SpacecraftState s, ElevationDetector detector, boolean increasing) throws OrekitException {
                if (increasing) {
                    if (this.lastPass == null) {
                        this.lastPass = ApogyCoreEnvironmentOrbitEarthFactory.eINSTANCE.createVisibilityPass();
                        this.lastPass.setStartTime(ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createDate(s.getDate()));
                        this.lastPass.setSurfaceLocation(earthSurfaceLocation);
                        this.lastPass.setOrbitModel(earthOrbitModel);
                    }
                } else if (this.lastPass != null) {
                    this.lastPass.setEndTime(ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createDate(s.getDate()));
                    passes.add(this.lastPass);
                    this.lastPass.getPositionHistory().updateHistory();
                    this.lastPass = null;
                }
                return EventHandler.Action.CONTINUE;
            }

            public org.orekit.propagation.SpacecraftState resetState(ElevationDetector detector, org.orekit.propagation.SpacecraftState oldState) throws OrekitException {
                return oldState;
            }
        };
        double convergenceThreshold = 0.001;
        ElevationDetector detector = null;
        if (elevationMask instanceof ConstantElevationMask) {
            double elevation = ((ConstantElevationMask)elevationMask).getConstantElevation();
            detector = (ElevationDetector)new ElevationDetector(1.0, convergenceThreshold, targetFrame).withConstantElevation(elevation).withHandler((EventHandler)eventHandler);
        } else {
            detector = (ElevationDetector)new ElevationDetector(1.0, convergenceThreshold, targetFrame).withElevationMask(elevationMask.getOreKitElevationMask()).withHandler((EventHandler)eventHandler);
        }
        Propagator propagator = earthOrbitModel.getOreKitPropagator();
        propagator.setSlaveMode();
        propagator.addEventDetector((EventDetector)detector);
        AbsoluteDate startAbsoluteDate = INSTANCE.createAbsoluteDate(startDate);
        AbsoluteDate endAbsoluteDate = INSTANCE.createAbsoluteDate(endDate);
        propagator.propagate(startAbsoluteDate, endAbsoluteDate);
        return passes;
    }

    @Override
    public List<VisibilityPass> getTargetPasses(EarthOrbitModel earthOrbitModel, List<EarthSurfaceLocation> earthSurfaceLocations, Date startDate, Date endDate, ElevationMask elevationMask, IProgressMonitor monitor) throws Exception {
        double convergenceThreshold = 0.001;
        FactoryManagedFrame earthFrame = FramesFactory.getITRF((IERSConventions)IERSConventions.IERS_2010, (boolean)true);
        OneAxisEllipsoid earth = new OneAxisEllipsoid(6378137.0, 0.0033528106647474805, (Frame)earthFrame);
        Propagator propagator = earthOrbitModel.getOreKitPropagator();
        propagator.setSlaveMode();
        ArrayList<EarthSurfaceLocationEventHandler> earthSurfaceLocationEventHandlers = new ArrayList<EarthSurfaceLocationEventHandler>();
        for (EarthSurfaceLocation earthSurfaceLocation : earthSurfaceLocations) {
            GeodeticPoint target = new GeodeticPoint(earthSurfaceLocation.getLatitude(), earthSurfaceLocation.getLongitude(), earthSurfaceLocation.getElevation());
            String name = "?";
            if (earthSurfaceLocation.getName() != null) {
                name = earthSurfaceLocation.getName();
            }
            TopocentricFrame targetFrame = new TopocentricFrame((BodyShape)earth, target, name);
            EarthSurfaceLocationEventHandler eventHandler = new EarthSurfaceLocationEventHandler(earthOrbitModel, earthSurfaceLocation);
            earthSurfaceLocationEventHandlers.add(eventHandler);
            ElevationDetector detector = null;
            if (elevationMask instanceof ConstantElevationMask) {
                double elevation = ((ConstantElevationMask)elevationMask).getConstantElevation();
                detector = (ElevationDetector)new ElevationDetector(1.0, convergenceThreshold, targetFrame).withConstantElevation(elevation).withHandler((EventHandler)eventHandler);
            } else {
                detector = (ElevationDetector)new ElevationDetector(1.0, convergenceThreshold, targetFrame).withElevationMask(elevationMask.getOreKitElevationMask()).withHandler((EventHandler)eventHandler);
            }
            propagator.addEventDetector((EventDetector)detector);
        }
        if (monitor != null) {
            monitor.beginTask("Get Target Passes for EarthSurfaceLocation.", 100);
            DateDetector dateDetector = this.createTimeProgressDateDetector(startDate, endDate, 100, monitor);
            propagator.addEventDetector((EventDetector)dateDetector);
        }
        AbsoluteDate startAbsoluteDate = ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createAbsoluteDate(startDate);
        AbsoluteDate endAbsoluteDate = ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createAbsoluteDate(endDate);
        propagator.propagate(startAbsoluteDate, endAbsoluteDate);
        ArrayList<VisibilityPass> passes = new ArrayList<VisibilityPass>();
        for (EarthSurfaceLocationEventHandler handler : earthSurfaceLocationEventHandlers) {
            passes.addAll(handler.getFoundPasses());
        }
        if (monitor != null) {
            monitor.done();
        }
        return passes;
    }

    @Override
    public List<VisibilityPass> getGroundStationPasses(final EarthOrbitModel earthOrbitModel, final GroundStation groundStation, Date startDate, Date endDate) throws Exception {
        final ArrayList<VisibilityPass> passes = new ArrayList<VisibilityPass>();
        GeodeticPoint target = new GeodeticPoint(groundStation.getLatitude(), groundStation.getLongitude(), groundStation.getElevation());
        FactoryManagedFrame earthFrame = FramesFactory.getITRF((IERSConventions)IERSConventions.IERS_2010, (boolean)true);
        OneAxisEllipsoid earth = new OneAxisEllipsoid(6378137.0, 0.0033528106647474805, (Frame)earthFrame);
        String name = "?";
        if (groundStation.getName() != null) {
            name = groundStation.getName();
        }
        TopocentricFrame targetFrame = new TopocentricFrame((BodyShape)earth, target, name);
        EventHandler<ElevationDetector> eventHandler = new EventHandler<ElevationDetector>(){
            VisibilityPass lastPass = null;

            public EventHandler.Action eventOccurred(org.orekit.propagation.SpacecraftState s, ElevationDetector detector, boolean increasing) throws OrekitException {
                if (increasing) {
                    if (this.lastPass == null) {
                        this.lastPass = ApogyCoreEnvironmentOrbitEarthFactory.eINSTANCE.createVisibilityPass();
                        this.lastPass.setSurfaceLocation(groundStation);
                        this.lastPass.setStartTime(ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createDate(s.getDate()));
                        this.lastPass.setOrbitModel(earthOrbitModel);
                    }
                } else if (this.lastPass != null) {
                    this.lastPass.setEndTime(ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createDate(s.getDate()));
                    passes.add(this.lastPass);
                    this.lastPass.getPositionHistory().updateHistory();
                    this.lastPass = null;
                }
                return EventHandler.Action.CONTINUE;
            }

            public org.orekit.propagation.SpacecraftState resetState(ElevationDetector detector, org.orekit.propagation.SpacecraftState oldState) throws OrekitException {
                return oldState;
            }
        };
        double convergenceThreshold = 0.001;
        ElevationDetector detector = null;
        if (groundStation.getElevationMask() instanceof ConstantElevationMask) {
            double elevation = ((ConstantElevationMask)groundStation.getElevationMask()).getConstantElevation();
            detector = (ElevationDetector)new ElevationDetector(1.0, convergenceThreshold, targetFrame).withConstantElevation(elevation).withHandler((EventHandler)eventHandler);
        } else {
            detector = (ElevationDetector)new ElevationDetector(1.0, convergenceThreshold, targetFrame).withElevationMask(groundStation.getElevationMask().getOreKitElevationMask()).withHandler((EventHandler)eventHandler);
        }
        Propagator propagator = earthOrbitModel.getOreKitPropagator();
        propagator.setSlaveMode();
        propagator.addEventDetector((EventDetector)detector);
        AbsoluteDate startAbsoluteDate = ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createAbsoluteDate(startDate);
        AbsoluteDate endAbsoluteDate = ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createAbsoluteDate(endDate);
        propagator.propagate(startAbsoluteDate, endAbsoluteDate);
        return passes;
    }

    @Override
    public List<VisibilityPass> getGroundStationPasses(EarthOrbitModel earthOrbitModel, List<GroundStation> groundStations, Date startDate, Date endDate, IProgressMonitor monitor) throws Exception {
        double convergenceThreshold = 0.001;
        FactoryManagedFrame earthFrame = FramesFactory.getITRF((IERSConventions)IERSConventions.IERS_2010, (boolean)true);
        OneAxisEllipsoid earth = new OneAxisEllipsoid(6378137.0, 0.0033528106647474805, (Frame)earthFrame);
        Propagator propagator = earthOrbitModel.getOreKitPropagator();
        propagator.setSlaveMode();
        ArrayList<EarthSurfaceLocationEventHandler> earthSurfaceLocationEventHandlers = new ArrayList<EarthSurfaceLocationEventHandler>();
        for (GroundStation groundStation : groundStations) {
            GeodeticPoint target = new GeodeticPoint(groundStation.getLatitude(), groundStation.getLongitude(), groundStation.getElevation());
            String name = "?";
            if (groundStation.getName() != null) {
                name = groundStation.getName();
            }
            TopocentricFrame targetFrame = new TopocentricFrame((BodyShape)earth, target, name);
            EarthSurfaceLocationEventHandler eventHandler = new EarthSurfaceLocationEventHandler(earthOrbitModel, groundStation);
            earthSurfaceLocationEventHandlers.add(eventHandler);
            ElevationDetector detector = null;
            if (groundStation.getElevationMask() instanceof ConstantElevationMask) {
                double elevation = ((ConstantElevationMask)groundStation.getElevationMask()).getConstantElevation();
                detector = (ElevationDetector)new ElevationDetector(1.0, convergenceThreshold, targetFrame).withConstantElevation(elevation).withHandler((EventHandler)eventHandler);
            } else {
                detector = (ElevationDetector)new ElevationDetector(1.0, convergenceThreshold, targetFrame).withElevationMask(groundStation.getElevationMask().getOreKitElevationMask()).withHandler((EventHandler)eventHandler);
            }
            propagator.addEventDetector((EventDetector)detector);
        }
        if (monitor != null) {
            monitor.beginTask("Get Target Passes for GroundStation.", 100);
            DateDetector dateDetector = this.createTimeProgressDateDetector(startDate, endDate, 100, monitor);
            propagator.addEventDetector((EventDetector)dateDetector);
        }
        AbsoluteDate startAbsoluteDate = ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createAbsoluteDate(startDate);
        AbsoluteDate endAbsoluteDate = ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createAbsoluteDate(endDate);
        propagator.propagate(startAbsoluteDate, endAbsoluteDate);
        ArrayList<VisibilityPass> passes = new ArrayList<VisibilityPass>();
        for (EarthSurfaceLocationEventHandler handler : earthSurfaceLocationEventHandlers) {
            passes.addAll(handler.getFoundPasses());
        }
        if (monitor != null) {
            monitor.done();
        }
        return passes;
    }

    @Override
    public List<Eclipse> getEclipses(EarthOrbitModel earthOrbitModel, Date startDate, Date endDate) throws Exception {
        final ArrayList<Eclipse> eclipses = new ArrayList<Eclipse>();
        CelestialBody earth = CelestialBodyFactory.getEarth();
        CelestialBody sun = CelestialBodyFactory.getSun();
        EventHandler<EclipseDetector> eventHandler = new EventHandler<EclipseDetector>(){
            Eclipse latestEclipse = null;

            public EventHandler.Action eventOccurred(org.orekit.propagation.SpacecraftState ss, EclipseDetector eclipseDetector, boolean increasing) throws OrekitException {
                if (this.latestEclipse == null) {
                    this.latestEclipse = ApogyCoreEnvironmentOrbitEarthFactory.eINSTANCE.createEclipse();
                    eclipses.add(this.latestEclipse);
                }
                if (eclipseDetector.getTotalEclipse()) {
                    if (increasing) {
                        EclipseEvent umbraExit = ApogyCoreEnvironmentOrbitEarthFactory.eINSTANCE.createEclipseEvent();
                        umbraExit.setTime(ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createDate(ss.getDate()));
                        umbraExit.setType(EclipseEventType.UMBRA_EXIT);
                        this.setGeographicCoordinates(umbraExit, ss);
                        this.latestEclipse.setUmbraExit(umbraExit);
                    } else {
                        EclipseEvent umbraEntry = ApogyCoreEnvironmentOrbitEarthFactory.eINSTANCE.createEclipseEvent();
                        umbraEntry.setTime(ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createDate(ss.getDate()));
                        umbraEntry.setType(EclipseEventType.UMBRA_ENTRY);
                        this.setGeographicCoordinates(umbraEntry, ss);
                        this.latestEclipse.setUmbraEntry(umbraEntry);
                    }
                } else if (increasing) {
                    EclipseEvent penumbraExit = ApogyCoreEnvironmentOrbitEarthFactory.eINSTANCE.createEclipseEvent();
                    penumbraExit.setTime(ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createDate(ss.getDate()));
                    penumbraExit.setType(EclipseEventType.PENUMBRA_EXIT);
                    this.setGeographicCoordinates(penumbraExit, ss);
                    this.latestEclipse.setPenumbraExit(penumbraExit);
                    this.latestEclipse = null;
                } else {
                    EclipseEvent penumbraEntry = ApogyCoreEnvironmentOrbitEarthFactory.eINSTANCE.createEclipseEvent();
                    penumbraEntry.setTime(ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createDate(ss.getDate()));
                    penumbraEntry.setType(EclipseEventType.PENUMBRA_ENTRY);
                    this.setGeographicCoordinates(penumbraEntry, ss);
                    this.latestEclipse.setPenumbraEntry(penumbraEntry);
                }
                return EventHandler.Action.CONTINUE;
            }

            public org.orekit.propagation.SpacecraftState resetState(EclipseDetector arg0, org.orekit.propagation.SpacecraftState oldState) throws OrekitException {
                return oldState;
            }

            private void setGeographicCoordinates(EclipseEvent eclipseEvent, org.orekit.propagation.SpacecraftState ss) {
                try {
                    OreKitBackedSpacecraftState oreKitBackedSpacecraftState = ApogyCoreEnvironmentOrbitEarthFactory.eINSTANCE.createOreKitBackedSpacecraftState();
                    oreKitBackedSpacecraftState.setOreKitSpacecraftState(ss);
                    GeographicCoordinates geographicCoordinates = ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.convertToGeographicCoordinates(oreKitBackedSpacecraftState);
                    eclipseEvent.setElevation(geographicCoordinates.getElevation());
                    eclipseEvent.setLatitude(geographicCoordinates.getLatitude());
                    eclipseEvent.setLongitude(geographicCoordinates.getLongitude());
                }
                catch (Throwable t) {
                    Logger.error(t.getMessage(), t);
                }
            }
        };
        EclipseDetector umbraDetector = (EclipseDetector)new EclipseDetector((PVCoordinatesProvider)sun, 6.96E8, (PVCoordinatesProvider)earth, 6378137.0).withUmbra().withHandler((EventHandler)eventHandler);
        EclipseDetector penumbraDetector = (EclipseDetector)new EclipseDetector((PVCoordinatesProvider)sun, 6.96E8, (PVCoordinatesProvider)earth, 6378137.0).withPenumbra().withHandler((EventHandler)eventHandler);
        Propagator propagator = earthOrbitModel.getOreKitPropagator();
        propagator.setSlaveMode();
        propagator.addEventDetector((EventDetector)umbraDetector);
        propagator.addEventDetector((EventDetector)penumbraDetector);
        AbsoluteDate startAbsoluteDate = ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createAbsoluteDate(startDate);
        AbsoluteDate endAbsoluteDate = ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createAbsoluteDate(endDate);
        propagator.propagate(startAbsoluteDate, endAbsoluteDate);
        return eclipses;
    }

    @Override
    public SortedSet<VisibilityPass> getVisibilityPassSortedByStartDate(List<VisibilityPass> passes) {
        TreeSet<VisibilityPass> sortedSet = new TreeSet<VisibilityPass>(new VisibilityPassStartDateComparator());
        sortedSet.addAll(passes);
        return sortedSet;
    }

    @Override
    public SortedSet<VisibilityPass> getVisibilityPassSortedByDuration(List<VisibilityPass> passes) {
        TreeSet<VisibilityPass> sortedSet = new TreeSet<VisibilityPass>(new VisibilityPassDurationComparator());
        sortedSet.addAll(passes);
        return sortedSet;
    }

    @Override
    public SortedSet<VisibilityPassSpacecraftPosition> getVisibilityPassSpacecraftPositionSortedByElevation(List<VisibilityPassSpacecraftPosition> positions) {
        TreeSet<VisibilityPassSpacecraftPosition> sortedSet = new TreeSet<VisibilityPassSpacecraftPosition>(new VisibilityPassSpacecraftPositionElevationComparator());
        sortedSet.addAll(positions);
        return sortedSet;
    }

    @Override
    public SortedSet<VisibilityPassSpacecraftPosition> getVisibilityPassSpacecraftPositionSortedBySpacecraftCrossTrackAngle(List<VisibilityPassSpacecraftPosition> positions) {
        TreeSet<VisibilityPassSpacecraftPosition> sortedSet = new TreeSet<VisibilityPassSpacecraftPosition>(new VisibilityPassSpacecraftPositionSpacecraftCrossTrackAngleComparator());
        sortedSet.addAll(positions);
        return sortedSet;
    }

    @Override
    public TLE loadTLE(String urlString) throws Exception {
        TLE tle = null;
        URL url = new URL(urlString);
        File tempFile = this.copyURLContent(url);
        FileInputStream fis = new FileInputStream(tempFile);
        BufferedReader br = new BufferedReader(new InputStreamReader(fis));
        String[] lines = new String[2];
        int i = 0;
        String line = null;
        while ((line = br.readLine()) != null && i < 2) {
            lines[i] = line;
            ++i;
        }
        br.close();
        tle = ApogyCoreEnvironmentOrbitEarthFactory.eINSTANCE.createTLE();
        tle.setFirstLine(lines[0]);
        tle.setSecondLine(lines[1]);
        return tle;
    }

    @Override
    public void exportTLE(TLE tle, String urlString) throws Exception {
        URL url = new URL(urlString);
        File tempFile = new File(url.getPath());
        BufferedWriter writer = new BufferedWriter(new FileWriter(tempFile));
        writer.write(String.valueOf(tle.getLine1()) + "\n" + tle.getLine2());
        writer.close();
    }

    @Override
    public TLEEarthOrbitModel createTLEEarthOrbitModel(TLE tle) throws Exception {
        TLEEarthOrbitModel propagator = ApogyCoreEnvironmentOrbitEarthFactory.eINSTANCE.createTLEEarthOrbitModel();
        propagator.setTle(tle);
        return propagator;
    }

    @Override
    public String exportAsCSV(VisibilityPassSpacecraftPositionHistory visibilityPassSpacecraftPositionHistory, boolean includeHeader) {
        StringBuffer buffer = new StringBuffer();
        if (includeHeader) {
            buffer.append("Time, Azimuth (deg),Elevation (deg),Range (km), Range Rate (m/s), Target Along Track Angle (deg), Target Cross Track Angle (deg), S/C Latitude (deg), S/C Longitude (deg), S/C Altitude (km) \n");
        }
        for (VisibilityPassSpacecraftPosition position : visibilityPassSpacecraftPositionHistory.getPositions()) {
            buffer.append(String.valueOf(position.getTime().toString()) + ",");
            buffer.append(String.valueOf(Double.toString(Math.toDegrees(position.getAzimuth()))) + ",");
            buffer.append(String.valueOf(Double.toString(Math.toDegrees(position.getElevation()))) + ",");
            buffer.append(String.valueOf(Double.toString(position.getRange() * 0.001)) + ",");
            buffer.append(String.valueOf(Double.toString(position.getRangeRate())) + ",");
            buffer.append(String.valueOf(Double.toString(Math.toDegrees(position.getSpacecraftAlongTrackAngle()))) + ",");
            buffer.append(String.valueOf(Double.toString(Math.toDegrees(position.getSpacecraftCrossTrackAngle()))) + ",");
            buffer.append(String.valueOf(Double.toString(Math.toDegrees(position.getSpacecraftCoordinates().getLatitude()))) + ",");
            buffer.append(String.valueOf(Double.toString(Math.toDegrees(position.getSpacecraftCoordinates().getLongitude()))) + ",");
            buffer.append(String.valueOf(Double.toString(position.getSpacecraftCoordinates().getElevation() * 0.001)) + ",");
            buffer.append("\n");
        }
        return buffer.toString();
    }

    private String getFileName(URL url) {
        String fileName = url.getFile();
        int startIndex = fileName.lastIndexOf(File.separator);
        int endIndex = fileName.lastIndexOf(".");
        if (startIndex > 0 && endIndex > 0) {
            fileName = fileName.substring(startIndex + 1, endIndex);
        }
        return fileName;
    }

    private String getFileExtension(URL url) {
        String fileExtension = url.getFile();
        int index = fileExtension.lastIndexOf(".");
        if (index > 0) {
            fileExtension = fileExtension.substring(index);
        }
        return fileExtension;
    }

    private File copyURLContent(URL url) {
        File tempFile = null;
        try {
            String fileName = this.getFileName(url);
            String fileExtension = this.getFileExtension(url);
            tempFile = File.createTempFile(fileName, fileExtension);
            url.openConnection();
            InputStream reader = url.openStream();
            FileOutputStream writer = new FileOutputStream(tempFile);
            byte[] buffer = new byte[153600];
            int bytesRead = 0;
            while ((bytesRead = reader.read(buffer)) > 0) {
                writer.write(buffer, 0, bytesRead);
                buffer = new byte[153600];
            }
            writer.close();
            reader.close();
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
        if (tempFile != null) {
            tempFile.deleteOnExit();
        }
        return tempFile;
    }

    protected DateDetector createTimeProgressDateDetector(Date startDate, Date endDate, int totalWorkUnits, IProgressMonitor monitor) {
        long duration = endDate.getTime() - startDate.getTime();
        long timeIncrement = Math.round(1.0 * (double)duration / (double)totalWorkUnits);
        AbsoluteDate absoluteStartDate = this.createAbsoluteDate(startDate);
        TimeProgressEventHandler handler = new TimeProgressEventHandler(monitor);
        DateDetector dateDetector = (DateDetector)new DateDetector(1.0, 1.0, new TimeStamped[]{absoluteStartDate}).withHandler((EventHandler)handler);
        long time = startDate.getTime() + timeIncrement;
        while (time < endDate.getTime()) {
            Date date = new Date(time);
            AbsoluteDate absoluteDate = this.createAbsoluteDate(date);
            dateDetector.addEventDate(absoluteDate);
            time += timeIncrement;
        }
        return dateDetector;
    }

    private class EarthSurfaceLocationEventHandler
    implements EventHandler<ElevationDetector> {
        private final EarthSurfaceLocation earthSurfaceLocation;
        private final EarthOrbitModel earthOrbitModel;
        private VisibilityPass lastPass = null;
        private final List<VisibilityPass> passes = new ArrayList<VisibilityPass>();

        public EarthSurfaceLocationEventHandler(EarthOrbitModel earthOrbitModel, EarthSurfaceLocation earthSurfaceLocation) {
            this.earthOrbitModel = earthOrbitModel;
            this.earthSurfaceLocation = earthSurfaceLocation;
        }

        public List<VisibilityPass> getFoundPasses() {
            return this.passes;
        }

        public EventHandler.Action eventOccurred(org.orekit.propagation.SpacecraftState s, ElevationDetector detector, boolean increasing) throws OrekitException {
            if (increasing) {
                if (this.lastPass == null) {
                    this.lastPass = ApogyCoreEnvironmentOrbitEarthFactory.eINSTANCE.createVisibilityPass();
                    this.lastPass.setStartTime(ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createDate(s.getDate()));
                    this.lastPass.setSurfaceLocation(this.earthSurfaceLocation);
                    this.lastPass.setOrbitModel(this.earthOrbitModel);
                }
            } else if (this.lastPass != null) {
                this.lastPass.setEndTime(ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createDate(s.getDate()));
                this.passes.add(this.lastPass);
                this.lastPass.getPositionHistory().updateHistory();
                this.lastPass = null;
            }
            return EventHandler.Action.CONTINUE;
        }

        public org.orekit.propagation.SpacecraftState resetState(ElevationDetector arg0, org.orekit.propagation.SpacecraftState oldState) throws OrekitException {
            return oldState;
        }
    }

    private class TimeProgressEventHandler
    implements EventHandler<DateDetector> {
        private final IProgressMonitor monitor;

        public TimeProgressEventHandler(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public EventHandler.Action eventOccurred(org.orekit.propagation.SpacecraftState arg0, DateDetector arg1, boolean increasing) throws OrekitException {
            this.monitor.worked(1);
            return EventHandler.Action.CONTINUE;
        }

        public org.orekit.propagation.SpacecraftState resetState(DateDetector arg0, org.orekit.propagation.SpacecraftState oldState) throws OrekitException {
            return oldState;
        }
    }

    private class VisibilityPassDurationComparator
    implements Comparator<VisibilityPass> {
        private VisibilityPassDurationComparator() {
        }

        @Override
        public int compare(VisibilityPass arg0, VisibilityPass arg1) {
            long startTime1;
            double duration1;
            double duration0 = arg0.getDuration();
            if (duration0 > (duration1 = arg1.getDuration())) {
                return 1;
            }
            if (duration0 < duration1) {
                return -1;
            }
            long startTime0 = arg0.getStartTime().getTime();
            if (startTime0 > (startTime1 = arg1.getStartTime().getTime())) {
                return 1;
            }
            if (startTime0 < startTime1) {
                return -1;
            }
            return 0;
        }
    }

    private class VisibilityPassSpacecraftPositionElevationComparator
    implements Comparator<VisibilityPassSpacecraftPosition> {
        private VisibilityPassSpacecraftPositionElevationComparator() {
        }

        @Override
        public int compare(VisibilityPassSpacecraftPosition arg0, VisibilityPassSpacecraftPosition arg1) {
            if (arg0.getElevation() > arg1.getElevation()) {
                return 1;
            }
            if (arg0.getElevation() < arg1.getElevation()) {
                return -1;
            }
            return 0;
        }
    }

    private class VisibilityPassSpacecraftPositionSpacecraftCrossTrackAngleComparator
    implements Comparator<VisibilityPassSpacecraftPosition> {
        private VisibilityPassSpacecraftPositionSpacecraftCrossTrackAngleComparator() {
        }

        @Override
        public int compare(VisibilityPassSpacecraftPosition arg0, VisibilityPassSpacecraftPosition arg1) {
            if (arg0.getSpacecraftCrossTrackAngle() > arg1.getSpacecraftCrossTrackAngle()) {
                return 1;
            }
            if (arg0.getSpacecraftCrossTrackAngle() < arg1.getSpacecraftCrossTrackAngle()) {
                return -1;
            }
            return 0;
        }
    }

    private class VisibilityPassStartDateComparator
    implements Comparator<VisibilityPass> {
        private VisibilityPassStartDateComparator() {
        }

        @Override
        public int compare(VisibilityPass arg0, VisibilityPass arg1) {
            double duration1;
            long startTime1;
            long startTime0 = arg0.getStartTime().getTime();
            if (startTime0 > (startTime1 = arg1.getStartTime().getTime())) {
                return 1;
            }
            if (startTime0 < startTime1) {
                return -1;
            }
            double duration0 = arg0.getDuration();
            if (duration0 > (duration1 = arg1.getDuration())) {
                return 1;
            }
            if (duration0 < duration1) {
                return -1;
            }
            return 0;
        }
    }
}

