/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.orbit.earth.impl;

import org.eclipse.apogy.core.environment.orbit.earth.EarthOrbit;
import org.eclipse.apogy.core.environment.orbit.earth.impl.KeplerianEarthOrbitPropagatorImpl;
import org.orekit.errors.PropagationException;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.analytical.KeplerianPropagator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeplerianEarthOrbitPropagatorCustomImpl
extends KeplerianEarthOrbitPropagatorImpl {
    private static final Logger Logger = LoggerFactory.getLogger(KeplerianEarthOrbitPropagatorImpl.class);

    @Override
    public KeplerianPropagator getOreKitKeplerianPropagator() {
        KeplerianPropagator kepler = null;
        if (this.getInitialOrbit() instanceof EarthOrbit) {
            EarthOrbit eo = (EarthOrbit)this.getInitialOrbit();
            try {
                kepler = new KeplerianPropagator(eo.getOreKitOrbit());
            }
            catch (PropagationException e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return kepler;
    }

    @Override
    public Propagator getOreKitPropagator() {
        return this.getOreKitKeplerianPropagator();
    }
}

