/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.orbit.earth.impl;

import java.util.Date;
import org.eclipse.apogy.core.environment.orbit.earth.ApogyCoreEnvironmentOrbitEarthFacade;
import org.eclipse.apogy.core.environment.orbit.earth.EphemerisType;
import org.eclipse.apogy.core.environment.orbit.earth.impl.TLEImpl;
import org.orekit.propagation.analytical.tle.TLE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TLECustomImpl
extends TLEImpl {
    private static final Logger Logger = LoggerFactory.getLogger(TLEImpl.class);

    @Override
    public void setFirstLine(String newFirstLine) {
        super.setFirstLine(newFirstLine);
        this.updateAllAttributes();
    }

    @Override
    public void setSecondLine(String newSecondLine) {
        super.setSecondLine(newSecondLine);
        this.updateAllAttributes();
    }

    @Override
    public String getLine1() {
        return this.getFirstLine();
    }

    @Override
    public String getLine2() {
        return this.getSecondLine();
    }

    protected void updateAllAttributes() {
        if (this.getLine1() != null && this.getLine1().length() > 0 && this.getLine2() != null && this.getLine2().length() > 0) {
            try {
                TLE tle = this.getOreKitTLE();
                this.setBStar(tle.getBStar());
                this.setEpoch(ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createDate(tle.getDate()));
                this.setEccentricity(tle.getE());
                this.setElementNumber(tle.getElementNumber());
                this.setEphemerisType(EphemerisType.get(tle.getEphemerisType()));
                this.setInclination(tle.getI());
                this.setMeanAnomaly(tle.getMeanAnomaly());
                this.setMeanMotion(tle.getMeanMotion());
                double revPerDay = tle.getMeanMotion() * 24.0 * 60.0 * 60.0 / (Math.PI * 2);
                this.setRevolutionPerDay(revPerDay);
                this.setMeanMotionFirstDerivative(tle.getMeanMotionFirstDerivative());
                this.setMeanMotionSecondDerivative(tle.getMeanMotionSecondDerivative());
                this.setArgumentOfPerigee(tle.getPerigeeArgument());
                this.setRightAscentionOfAscendingNode(tle.getRaan());
                this.setRevolutionNumberAtEpoch(tle.getRevolutionNumberAtEpoch());
                this.setSatelliteNumber(tle.getSatelliteNumber());
                return;
            }
            catch (Exception e) {
                Logger.error("Failed to parse TLE lines.", (Throwable)e);
            }
        }
        this.setBStar(0.0);
        this.setEpoch(new Date());
        this.setEccentricity(0.0);
        this.setElementNumber(0);
        this.setEphemerisType(EPHEMERIS_TYPE_EDEFAULT);
        this.setInclination(0.0);
        this.setMeanAnomaly(0.0);
        this.setMeanMotion(0.0);
        this.setRevolutionPerDay(0.0);
        this.setMeanMotionFirstDerivative(0.0);
        this.setMeanMotionSecondDerivative(0.0);
        this.setArgumentOfPerigee(0.0);
        this.setRightAscentionOfAscendingNode(0.0);
        this.setRevolutionNumberAtEpoch(0);
        this.setSatelliteNumber(0);
    }
}

