/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.orbit.earth.impl;

import java.util.Date;
import org.eclipse.apogy.core.environment.orbit.ApogyCoreEnvironmentOrbitFacade;
import org.eclipse.apogy.core.environment.orbit.SpacecraftState;
import org.eclipse.apogy.core.environment.orbit.earth.ApogyCoreEnvironmentOrbitEarthFacade;
import org.eclipse.apogy.core.environment.orbit.earth.impl.TLEEarthOrbitModelImpl;
import org.orekit.propagation.analytical.tle.TLE;
import org.orekit.propagation.analytical.tle.TLEPropagator;
import org.orekit.time.AbsoluteDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TLEEarthOrbitModelCustomImpl
extends TLEEarthOrbitModelImpl {
    private static final Logger Logger = LoggerFactory.getLogger(TLEEarthOrbitModelImpl.class);

    public TLEPropagator getOreKitPropagator() {
        try {
            return TLEPropagator.selectExtrapolator((TLE)this.getTle().getOreKitTLE());
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Date getFromValidDate() {
        if (this.getTle() != null && this.getTle().getEpoch() != null) {
            return new Date(this.getTle().getEpoch().getTime());
        }
        return null;
    }

    public Date getToValidDate() {
        if (this.getFromValidDate() != null) {
            return new Date(this.getFromValidDate().getTime() + this.getTleValidityPeriod());
        }
        return null;
    }

    public SpacecraftState propagate(Date targetDate) throws Exception {
        AbsoluteDate absoluteDate = ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createAbsoluteDate(targetDate);
        return ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createSpacecraftState(null, this.getOreKitPropagator().propagate(absoluteDate));
    }

    public boolean isDateInValidRange(Date date) {
        return ApogyCoreEnvironmentOrbitFacade.INSTANCE.isDateInValidRange(this.getFromValidDate(), this.getToValidDate(), date);
    }
}

