/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.impl;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFactory;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.images.ApogyCommonImagesFactory;
import org.eclipse.apogy.common.images.EImage;
import org.eclipse.apogy.common.images.EImagesUtilities;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.common.topology.GroupNode;
import org.eclipse.apogy.core.environment.surface.AbstractMapLayerNode;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentFacade;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentFactory;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentPackage;
import org.eclipse.apogy.core.environment.surface.CartesianTriangularMeshMapLayerNode;
import org.eclipse.apogy.core.environment.surface.ImageMapLayerPresentation;
import org.eclipse.apogy.core.environment.surface.MapLayerPresentation;
import org.eclipse.apogy.core.environment.surface.RectangularVolumeRegion;
import org.eclipse.apogy.core.environment.surface.impl.CartesianTriangularMeshMapLayerImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CartesianTriangularMeshMapLayerCustomImpl
extends CartesianTriangularMeshMapLayerImpl {
    private static final Logger Logger = LoggerFactory.getLogger(CartesianTriangularMeshMapLayerImpl.class);
    protected CartesianTriangularMesh emptyMesh = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianTriangularMesh();
    protected boolean textureImageIsDirty = true;
    private EContentAdapter meshTextureAdapter = null;

    protected CartesianTriangularMeshMapLayerCustomImpl() {
        this.eAdapters().add((Object)this.getMeshTextureAdapter());
    }

    @Override
    public AbstractEImage getTextureImage() {
        if (this.textureImageIsDirty) {
            this.textureImageIsDirty = false;
            AbstractEImage img = this.createMeshTextureImage();
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogySurfaceEnvironmentPackage.Literals.CARTESIAN_TRIANGULAR_MESH_MAP_LAYER__TEXTURE_IMAGE, (Object)img);
        }
        return super.getTextureImage();
    }

    @Override
    public AbstractMapLayerNode getAbstractMapLayerNode() {
        return this.getCartesianTriangularMeshMapLayerNode();
    }

    @Override
    public CartesianTriangularMeshMapLayerNode getCartesianTriangularMeshMapLayerNode() {
        CartesianTriangularMeshMapLayerNode node = super.getCartesianTriangularMeshMapLayerNode();
        if (node == null) {
            node = ApogySurfaceEnvironmentFactory.eINSTANCE.createCartesianTriangularMeshMapLayerNode();
            node.setAbstractMapLayer(this);
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogySurfaceEnvironmentPackage.Literals.CARTESIAN_TRIANGULAR_MESH_MAP_LAYER__CARTESIAN_TRIANGULAR_MESH_MAP_LAYER_NODE, (Object)node);
        }
        return node;
    }

    @Override
    public void forceUpdateTextureImage() {
        AbstractEImage img = this.createMeshTextureImage();
        this.setTextureImage(img);
        this.textureImageIsDirty = false;
    }

    @Override
    public void dispose() {
        AbstractMapLayerNode amln = this.getAbstractMapLayerNode();
        if (amln != null && amln.getParent() instanceof GroupNode) {
            GroupNode parent = (GroupNode)amln.getParent();
            parent.getChildren().remove((Object)amln);
            amln.setParent(null);
        }
    }

    protected List<ImageMapLayerPresentation> getImageMapLayerPresentation() {
        ArrayList<ImageMapLayerPresentation> list = new ArrayList<ImageMapLayerPresentation>();
        for (MapLayerPresentation mapLayerPresentation : this.getMapLayerPresentations()) {
            if (!(mapLayerPresentation instanceof ImageMapLayerPresentation)) continue;
            list.add((ImageMapLayerPresentation)mapLayerPresentation);
        }
        return list;
    }

    protected AbstractEImage createMeshTextureImage() {
        Logger.info("Updating Texture Image starts.");
        try {
            RectangularVolumeRegion meshRegion = ApogySurfaceEnvironmentFacade.INSTANCE.getRectangularVolumeRegion(this.getCurrentMesh());
            Matrix4d meshTransformMatrix = new Matrix4d();
            meshTransformMatrix.setIdentity();
            if (this.getMap().getTransformation() != null) {
                meshTransformMatrix.mul(this.getMap().getTransformation().asMatrix4d());
            }
            double bestResolution = 10000.0;
            HashMap<ImageMapLayerPresentation, Matrix4d> layerPresentationToTransformMap = new HashMap<ImageMapLayerPresentation, Matrix4d>();
            ArrayList<ImageMapLayerPresentation> imageMapLayerPresentationsToProcess = new ArrayList<ImageMapLayerPresentation>();
            List<ImageMapLayerPresentation> imageMapLayerPresentationList = this.getImageMapLayerPresentation();
            for (ImageMapLayerPresentation imageMapLayerPresentation : imageMapLayerPresentationList) {
                if (!imageMapLayerPresentation.isVisible() || imageMapLayerPresentation.getRegionImage() == null) continue;
                Logger.debug("Mesh Transform   : " + meshTransformMatrix);
                Logger.debug("Region Transform : " + imageMapLayerPresentation.getRegion().getTransformation().asMatrix4d());
                Matrix4d imageToMeshTransform = new Matrix4d(meshTransformMatrix);
                imageToMeshTransform.invert();
                imageToMeshTransform.mul(imageMapLayerPresentation.getRegion().getTransformation().asMatrix4d());
                if (!ApogySurfaceEnvironmentFacade.INSTANCE.intersects(meshRegion, imageMapLayerPresentation.getRegion(), ApogyCommonMathFacade.INSTANCE.createMatrix4x4(imageToMeshTransform))) continue;
                if (imageMapLayerPresentation.getResolution() < bestResolution) {
                    bestResolution = imageMapLayerPresentation.getResolution();
                }
                imageMapLayerPresentationsToProcess.add(imageMapLayerPresentation);
                layerPresentationToTransformMap.put(imageMapLayerPresentation, imageToMeshTransform);
            }
            Logger.debug("Layer To Processs : " + imageMapLayerPresentationsToProcess.size());
            Logger.debug("Best Resolution   : " + bestResolution + " m/pixel");
            int meshImageWidth = (int)Math.round(meshRegion.getXDimension() / bestResolution);
            int meshImageHeight = (int)Math.round(meshRegion.getYDimension() / bestResolution);
            Logger.debug("meshImageWidth : " + meshImageWidth);
            Logger.debug("meshImageHeight : " + meshImageHeight);
            if (meshImageHeight > 0 && meshImageWidth > 0) {
                AbstractEImage meshTextureImage = EImagesUtilities.INSTANCE.createTransparentImage(meshImageWidth, meshImageHeight);
                for (ImageMapLayerPresentation imageMapLayerPresentation : imageMapLayerPresentationsToProcess) {
                    Logger.debug("ImageMapLayerPresentation " + imageMapLayerPresentation.getName());
                    try {
                        Matrix4d imageToMeshTransform = new Matrix4d((Matrix4d)layerPresentationToTransformMap.get(imageMapLayerPresentation));
                        Tuple3d rotation = ApogyCommonMathFacade.INSTANCE.extractOrientation(ApogyCommonMathFacade.INSTANCE.createMatrix4x4(imageToMeshTransform));
                        double zRotationAngle = -rotation.getZ();
                        Vector3d translation = new Vector3d();
                        imageToMeshTransform.get(translation);
                        double xTranslation = translation.x / bestResolution;
                        double yTranslation = translation.y / bestResolution;
                        Logger.debug("Image To Mesh Transform : " + imageToMeshTransform);
                        Logger.debug("\t xTranslation   : " + xTranslation);
                        Logger.debug("\t yTranslation   : " + yTranslation);
                        Logger.debug("\t zRotationAngle : " + Math.toDegrees(zRotationAngle) + " deg");
                        double scaleFactor = imageMapLayerPresentation.getResolution() / bestResolution;
                        AbstractEImage scaledLayerImage = EImagesUtilities.INSTANCE.resize(imageMapLayerPresentation.getRegionImage(), scaleFactor);
                        Logger.debug("\t scaling factor : " + scaleFactor);
                        Logger.debug("\t layer image scaled : " + scaledLayerImage.getWidth() + " X " + scaledLayerImage.getHeight());
                        double Y = (double)meshImageHeight - ((double)scaledLayerImage.getHeight() + yTranslation);
                        AffineTransform translationTransform = new AffineTransform();
                        translationTransform.translate(xTranslation, Y);
                        AffineTransform rotationTranform = new AffineTransform();
                        rotationTranform.rotate(zRotationAngle, 0.0, scaledLayerImage.getHeight());
                        translationTransform.concatenate(rotationTranform);
                        BufferedImage bufferedImage = new BufferedImage(meshImageWidth, meshImageHeight, 2);
                        Graphics2D g = bufferedImage.createGraphics();
                        g.drawImage(scaledLayerImage.asBufferedImage(), translationTransform, null);
                        g.dispose();
                        EImage layerMeshImage = ApogyCommonImagesFactory.eINSTANCE.createEImage();
                        layerMeshImage.setImageContent(bufferedImage);
                        meshTextureImage = EImagesUtilities.INSTANCE.applyOverlay(meshTextureImage, (AbstractEImage)layerMeshImage, false);
                    }
                    catch (Throwable t) {
                        Logger.error(t.getMessage(), t);
                    }
                }
                Logger.info("Updating Texture Image completed.");
                return meshTextureImage;
            }
            Logger.warn("Updating Texture Image returned no image.");
            return null;
        }
        catch (Throwable t) {
            Logger.error("Updating Texture Image failed!", t);
            return null;
        }
    }

    private EContentAdapter getMeshTextureAdapter() {
        if (this.meshTextureAdapter == null) {
            this.meshTextureAdapter = new EContentAdapter(){

                public void notifyChanged(Notification notification) {
                    int featureId;
                    super.notifyChanged(notification);
                    boolean updateImage = false;
                    if (notification.getNotifier() instanceof CartesianTriangularMeshMapLayerCustomImpl) {
                        featureId = notification.getFeatureID(CartesianTriangularMeshMapLayerCustomImpl.class);
                        switch (featureId) {
                            case 5: {
                                updateImage = true;
                                break;
                            }
                        }
                    }
                    if (notification.getNotifier() instanceof MapLayerPresentation) {
                        featureId = notification.getFeatureID(MapLayerPresentation.class);
                        switch (featureId) {
                            case 2: {
                                updateImage = true;
                                break;
                            }
                        }
                    }
                    if (notification.getNotifier() instanceof ImageMapLayerPresentation) {
                        featureId = notification.getFeatureID(ImageMapLayerPresentation.class);
                        switch (featureId) {
                            case 0: 
                            case 1: {
                                break;
                            }
                            default: {
                                updateImage = true;
                            }
                        }
                    }
                    if (updateImage) {
                        AbstractEImage img = CartesianTriangularMeshMapLayerCustomImpl.this.createMeshTextureImage();
                        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)CartesianTriangularMeshMapLayerCustomImpl.this, (EStructuralFeature)ApogySurfaceEnvironmentPackage.Literals.CARTESIAN_TRIANGULAR_MESH_MAP_LAYER__TEXTURE_IMAGE, (Object)img);
                        CartesianTriangularMeshMapLayerCustomImpl.this.textureImageIsDirty = false;
                    }
                }
            };
        }
        return this.meshTextureAdapter;
    }
}

