/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.ui.composites;

import java.text.SimpleDateFormat;
import org.eclipse.apogy.common.databinding.converters.DateToStringConverter;
import org.eclipse.apogy.common.emf.ApogyCommonEMFPackage;
import org.eclipse.apogy.common.emf.TimeSource;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.environment.ApogyCoreEnvironmentPackage;
import org.eclipse.apogy.core.environment.ApogyEnvironment;
import org.eclipse.apogy.core.environment.ui.composites.ApogyEnvironmentTimeSourcesListComposite;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApogyEnvironmentTimeSourceComposite
extends Composite {
    private static final Logger Logger = LoggerFactory.getLogger(ApogyEnvironmentTimeSourceComposite.class);
    protected DataBindingContext bindingContext;
    private Adapter activeTimeSourceAdapter = null;
    protected ApogyEnvironment apogyEnvironment;
    protected ApogyEnvironmentTimeSourcesListComposite timeSourcesListComposite;
    protected Label currentTimeValueLabel;
    protected Combo activeTimeSourceCombo;

    public ApogyEnvironmentTimeSourceComposite(Composite parent, int style) {
        this(parent, style, null);
    }

    public ApogyEnvironmentTimeSourceComposite(Composite parent, int style, ApogyEnvironment apogyEnvironment) {
        super(parent, style);
        this.setApogyEnvironment(apogyEnvironment);
        this.setLayout((Layout)new FillLayout());
        Composite top = new Composite((Composite)this, 2048);
        top.setLayout((Layout)new GridLayout(1, false));
        Composite currentTimeComposite = new Composite(top, 0);
        GridData currentTimeCompositeGridData = new GridData(4, 128, true, false);
        currentTimeComposite.setLayoutData((Object)currentTimeCompositeGridData);
        currentTimeComposite.setLayout((Layout)new GridLayout(2, true));
        Label currentTimeLabel = new Label(currentTimeComposite, 0);
        currentTimeLabel.setText("Current Environment Time : ");
        this.currentTimeValueLabel = new Label(currentTimeComposite, 0);
        this.currentTimeValueLabel.setText("?");
        GridData currentTimeValueLabelGridData = new GridData(16384, 0x1000000, false, false);
        currentTimeValueLabelGridData.widthHint = 250;
        currentTimeValueLabelGridData.minimumWidth = 250;
        this.currentTimeValueLabel.setLayoutData((Object)currentTimeValueLabelGridData);
        Label activeTimeSourceLabel = new Label(currentTimeComposite, 0);
        activeTimeSourceLabel.setText("Active Time Source :");
        this.activeTimeSourceCombo = this.createActiveTimeSourceCombo(currentTimeComposite);
        GridData activeTimeSourceComboGridData = new GridData(16384, 0x1000000, false, false);
        activeTimeSourceComboGridData.widthHint = 250;
        activeTimeSourceComboGridData.minimumWidth = 250;
        this.activeTimeSourceCombo.setLayoutData((Object)activeTimeSourceComboGridData);
        this.timeSourcesListComposite = new ApogyEnvironmentTimeSourcesListComposite(top, 2048);
        GridData timeSourcesListCompositeGridData = new GridData(4, 4, false, false);
        timeSourcesListCompositeGridData.minimumWidth = 800;
        timeSourcesListCompositeGridData.widthHint = 800;
        timeSourcesListCompositeGridData.heightHint = 600;
        timeSourcesListCompositeGridData.minimumHeight = 600;
        this.timeSourcesListComposite.setLayoutData(timeSourcesListCompositeGridData);
    }

    public ApogyEnvironment getApogyEnvironment() {
        return this.apogyEnvironment;
    }

    public void setApogyEnvironment(ApogyEnvironment apogyEnvironment) {
        this.setApogyEnvironment(apogyEnvironment, true);
    }

    public void setApogyEnvironment(ApogyEnvironment apogyEnvironment, boolean update) {
        if (this.apogyEnvironment != null) {
            apogyEnvironment.eAdapters().remove((Object)this.getActiveTimeSourceAdapter());
        }
        this.apogyEnvironment = apogyEnvironment;
        if (apogyEnvironment != null) {
            apogyEnvironment.eAdapters().add((Object)this.getActiveTimeSourceAdapter());
            if (this.timeSourcesListComposite != null) {
                this.timeSourcesListComposite.setTimeSourcesList(apogyEnvironment.getTimeSourcesList());
            }
        }
        if (update && this.timeSourcesListComposite != null) {
            this.populateActiveTimeSourceCombo(this.activeTimeSourceCombo);
            this.timeSourcesListComposite.setTimeSourcesList(null);
            if (this.bindingContext != null) {
                this.bindingContext.dispose();
                this.bindingContext = null;
            }
            if (apogyEnvironment != null) {
                this.populateActiveTimeSourceCombo(this.activeTimeSourceCombo);
                this.timeSourcesListComposite.setTimeSourcesList(apogyEnvironment.getTimeSourcesList());
                this.setActiveTimeSource(apogyEnvironment.getActiveTimeSource());
                this.bindingContext = this.initDataBindings();
            }
        }
    }

    protected Combo createActiveTimeSourceCombo(Composite parent) {
        final Combo combo = new Combo(parent, 8);
        this.populateActiveTimeSourceCombo(combo);
        combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    int index = combo.getSelectionIndex();
                    if (ApogyEnvironmentTimeSourceComposite.this.getApogyEnvironment() != null && ApogyEnvironmentTimeSourceComposite.this.getApogyEnvironment().getTimeSourcesList() != null) {
                        TimeSource timeSource = (TimeSource)ApogyEnvironmentTimeSourceComposite.this.getApogyEnvironment().getTimeSourcesList().getTimeSources().get(index);
                        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)ApogyEnvironmentTimeSourceComposite.this.getApogyEnvironment(), (EStructuralFeature)ApogyCoreEnvironmentPackage.Literals.APOGY_ENVIRONMENT__ACTIVE_TIME_SOURCE, (Object)timeSource);
                    }
                }
                catch (Throwable t) {
                    Logger.error(t.getMessage(), t);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.getApogyEnvironment() != null && this.getApogyEnvironment().getActiveTimeSource() != null) {
            combo.select(this.getApogyEnvironment().getTimeSourcesList().getTimeSources().indexOf((Object)this.getApogyEnvironment().getActiveTimeSource()));
        }
        return combo;
    }

    protected void populateActiveTimeSourceCombo(Combo combo) {
        if (this.getApogyEnvironment() != null) {
            int size = this.getApogyEnvironment().getTimeSourcesList().getTimeSources().size();
            String[] items = new String[size];
            int i = 0;
            while (i < size) {
                String timeSourceText;
                TimeSource timeSource = (TimeSource)this.getApogyEnvironment().getTimeSourcesList().getTimeSources().get(i);
                items[i] = timeSourceText = this.getTimeSourceText(timeSource);
                ++i;
            }
            combo.setItems(items);
        }
    }

    protected String getTimeSourceText(TimeSource timeSource) {
        String text = timeSource.eClass().getName();
        return text;
    }

    protected void setActiveTimeSource(TimeSource activeTimeSource) {
        this.timeSourcesListComposite.setSelectedTimeSourceTab(activeTimeSource);
        if (this.activeTimeSourceCombo != null) {
            if (activeTimeSource != null) {
                this.activeTimeSourceCombo.select(this.getApogyEnvironment().getTimeSourcesList().getTimeSources().indexOf((Object)activeTimeSource));
            } else {
                this.activeTimeSourceCombo.select(-1);
            }
        }
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        IObservableValue currentTimeLabelValue = PojoProperties.value((String)"text").observe((Object)this.currentTimeValueLabel);
        IObservableValue currentTimeObserveValue = EMFProperties.value((FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCommonEMFPackage.Literals.TIMED__TIME})).observe((Object)this.getApogyEnvironment());
        UpdateValueStrategy currentTimeValueStrategy = new UpdateValueStrategy();
        currentTimeValueStrategy.setConverter((IConverter)new DateToStringConverter(new SimpleDateFormat("yyyy.MM.dd HH:mm:ss.SSS z")));
        bindingContext.bindValue(currentTimeLabelValue, currentTimeObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), currentTimeValueStrategy);
        return bindingContext;
    }

    protected Adapter getActiveTimeSourceAdapter() {
        if (this.activeTimeSourceAdapter == null) {
            this.activeTimeSourceAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    int featureId;
                    if (msg.getNotifier() instanceof ApogyEnvironment && (featureId = msg.getFeatureID(ApogyEnvironment.class)) == 11) {
                        TimeSource newActiveTimeSource = (TimeSource)msg.getNewValue();
                        ApogyEnvironmentTimeSourceComposite.this.setActiveTimeSource(newActiveTimeSource);
                    }
                }
            };
        }
        return this.activeTimeSourceAdapter;
    }
}

