/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.ui.composites;

import org.eclipse.apogy.common.emf.Disposable;
import org.eclipse.apogy.common.emf.TimeSource;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.EClassSettings;
import org.eclipse.apogy.common.emf.ui.NamedSetting;
import org.eclipse.apogy.common.emf.ui.composites.EObjectListComposite;
import org.eclipse.apogy.common.emf.ui.wizards.ApogyEObjectWizard;
import org.eclipse.apogy.core.environment.ApogyCoreEnvironmentPackage;
import org.eclipse.apogy.core.environment.TimeSourcesList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class TimeSourcesListComposite
extends Composite {
    private EObjectListComposite listComposite;
    private Button newBtn;
    private Button deleteBtn;
    private Button activateBtn;
    private TimeSourcesList timeSourcesList;

    public TimeSourcesListComposite(Composite parent, int style) {
        super(parent, 2048);
        this.setLayout((Layout)new GridLayout(2, false));
        this.listComposite = new EObjectListComposite(this, 0){
            private final AdapterFactoryLabelProvider adapterFactoryLabelProvider;
            {
                this.adapterFactoryLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE));
            }

            protected void newSelection(TreeSelection selection) {
                TimeSourcesListComposite.this.newSelection(selection);
            }

            protected StyledCellLabelProvider getLabelProvider() {
                return new StyledCellLabelProvider(){

                    public void update(ViewerCell cell) {
                        if (cell.getElement() instanceof TimeSource) {
                            TimeSource timeSource = (TimeSource)cell.getElement();
                            cell.setText(timeSource.getName());
                            cell.setImage(adapterFactoryLabelProvider.getColumnImage(cell.getElement(), 0));
                        }
                    }
                };
            }
        };
        this.listComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 4));
        this.newBtn = new Button((Composite)this, 0);
        this.newBtn.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.newBtn.setText("New");
        this.newBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NamedSetting namedSettings = ApogyCommonEMFUIFactory.eINSTANCE.createNamedSetting();
                namedSettings.setParent((EObject)TimeSourcesListComposite.this.timeSourcesList);
                namedSettings.setContainingFeature((ETypedElement)ApogyCoreEnvironmentPackage.Literals.TIME_SOURCES_LIST__TIME_SOURCES);
                ApogyEObjectWizard wizard = new ApogyEObjectWizard(ApogyCoreEnvironmentPackage.Literals.TIME_SOURCES_LIST__TIME_SOURCES, (EObject)TimeSourcesListComposite.this.timeSourcesList, (EClassSettings)namedSettings, null){

                    public boolean performFinish() {
                        boolean value = super.performFinish();
                        TimeSourcesListComposite.this.listComposite.refreshTreeViewer();
                        TimeSourcesListComposite.this.listComposite.setSelectedEObject(this.getCreatedEObject());
                        return value;
                    }
                };
                WizardDialog dialog = new WizardDialog(TimeSourcesListComposite.this.getShell(), (IWizard)wizard);
                dialog.open();
            }
        });
        this.deleteBtn = new Button((Composite)this, 0);
        this.deleteBtn.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.deleteBtn.setText("Delete");
        this.deleteBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimeSource selectedTimeSource = TimeSourcesListComposite.this.getSelectedTimeSource();
                if (TimeSourcesListComposite.this.timeSourcesList != null && TimeSourcesListComposite.this.timeSourcesList.getEnvironment() != null && TimeSourcesListComposite.this.timeSourcesList.getEnvironment().getActiveTimeSource() == selectedTimeSource) {
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)TimeSourcesListComposite.this.timeSourcesList.getEnvironment(), (EStructuralFeature)ApogyCoreEnvironmentPackage.Literals.APOGY_ENVIRONMENT__ACTIVE_TIME_SOURCE, null);
                }
                ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)TimeSourcesListComposite.this.timeSourcesList, (EStructuralFeature)ApogyCoreEnvironmentPackage.Literals.TIME_SOURCES_LIST__TIME_SOURCES, (Object)TimeSourcesListComposite.this.getSelectedTimeSource());
                if (selectedTimeSource instanceof Disposable) {
                    selectedTimeSource.dispose();
                }
                TimeSourcesListComposite.this.listComposite.refreshTreeViewer();
            }
        });
        new Label((Composite)this, 258);
        this.activateBtn = new Button((Composite)this, 0);
        this.activateBtn.setLayoutData((Object)new GridData(4, 128, false, true, 1, 1));
        this.activateBtn.setText("Activate");
        this.activateBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TimeSourcesListComposite.this.timeSourcesList != null && TimeSourcesListComposite.this.timeSourcesList.getEnvironment() != null) {
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)TimeSourcesListComposite.this.timeSourcesList.getEnvironment(), (EStructuralFeature)ApogyCoreEnvironmentPackage.Literals.APOGY_ENVIRONMENT__ACTIVE_TIME_SOURCE, (Object)TimeSourcesListComposite.this.listComposite.getSelectedEObject());
                }
            }
        });
    }

    public void setTimeSourcesList(TimeSourcesList timeSourcesList) {
        this.timeSourcesList = timeSourcesList;
        this.listComposite.setEObjectsList(timeSourcesList.getTimeSources(), (Object)timeSourcesList.getEnvironment().getActiveTimeSource());
    }

    protected void newSelection(TreeSelection selection) {
    }

    public TimeSource getSelectedTimeSource() {
        return this.listComposite.getSelectedEObject() == null ? null : (TimeSource)this.listComposite.getSelectedEObject();
    }
}

