/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.ui.parts;

import java.util.HashMap;
import javax.inject.Inject;
import org.eclipse.apogy.common.emf.TimeSource;
import org.eclipse.apogy.common.emf.ui.SelectionBasedTimeSource;
import org.eclipse.apogy.common.ui.composites.ClosableNoContentComposite;
import org.eclipse.apogy.core.environment.ApogyCoreEnvironmentPackage;
import org.eclipse.apogy.core.environment.ApogyEnvironment;
import org.eclipse.apogy.core.environment.ui.composites.ActiveTimeSourceComposite;
import org.eclipse.apogy.core.environment.ui.parts.AbstractApogyEnvironmentBasedPart;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ActiveTimeSourcePart
extends AbstractApogyEnvironmentBasedPart {
    private ApogyEnvironment environment;
    private Adapter activeTimeSourceAdapter;
    private ActiveTimeSourceComposite ActiveTimeSourceComposite;
    @Inject
    EHandlerService handlerService;
    @Inject
    ECommandService commandService;

    @Override
    protected void setCompositeContent(EObject eObject) {
        if (this.environment != eObject) {
            this.newEnvironment((ApogyEnvironment)eObject);
        }
        if (this.ActiveTimeSourceComposite == null) {
            this.createContentComposite(this.getActualComposite().getParent().getParent(), 0);
        }
        this.ActiveTimeSourceComposite.setTimeSource(((ApogyEnvironment)eObject).getActiveTimeSource());
    }

    @Override
    protected void newEnvironment(ApogyEnvironment environment) {
        if (this.environment != null) {
            this.environment.eAdapters().remove((Object)this.getActiveTimeSourceAdapter());
        }
        this.environment = environment;
        if (this.environment != null) {
            this.environment.eAdapters().add((Object)this.getActiveTimeSourceAdapter());
        }
    }

    protected void createContentComposite(Composite parent, int style) {
        Composite composite = new Composite(parent, 2048);
        composite.setLayout((Layout)new GridLayout(1, false));
        Button btnClose = new Button(composite, 0);
        ImageDescriptor image = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"icons/full/elcl16/close_view.png");
        btnClose.setImage(image.createImage());
        btnClose.setLayoutData((Object)new GridData(131072, 4, false, false, 1, 1));
        btnClose.addSelectionListener(this.getListener());
        this.ActiveTimeSourceComposite = new ActiveTimeSourceComposite(composite, 0);
        this.ActiveTimeSourceComposite.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        if (this.environment != null) {
            this.ActiveTimeSourceComposite.setTimeSource(this.environment.getActiveTimeSource());
        }
    }

    private Adapter getActiveTimeSourceAdapter() {
        if (this.activeTimeSourceAdapter == null) {
            this.activeTimeSourceAdapter = new AdapterImpl(){

                public void notifyChanged(Notification notification) {
                    if (notification.getFeature() == ApogyCoreEnvironmentPackage.Literals.APOGY_ENVIRONMENT__ACTIVE_TIME_SOURCE) {
                        if (notification.getNewValue() != null) {
                            ActiveTimeSourcePart.this.ActiveTimeSourceComposite.setTimeSource((TimeSource)notification.getNewValue());
                            if (notification.getNewValue() instanceof SelectionBasedTimeSource) {
                                ((SelectionBasedTimeSource)notification.getNewValue()).setSelectionService(ActiveTimeSourcePart.this.selectionService);
                            }
                        } else {
                            ActiveTimeSourcePart.this.ActiveTimeSourceComposite.setTimeSource(null);
                        }
                    }
                }
            };
        }
        return this.activeTimeSourceAdapter;
    }

    @Override
    protected void createNoContentComposite(Composite parent, int style) {
        if (this.ActiveTimeSourceComposite != null) {
            this.ActiveTimeSourceComposite.dispose();
        }
        new ClosableNoContentComposite(parent, 2048){

            protected String getMessage() {
                return "No active environment";
            }

            protected SelectionListener getSelectionListener() {
                return ActiveTimeSourcePart.this.getListener();
            }
        };
    }

    private SelectionListener getListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HashMap<String, String> parameters = new HashMap<String, String>(1);
                parameters.put("org.eclipse.apogy.core.environment.ui.commandparameter.toggleActiveTimeSource.show", "false");
                ParameterizedCommand command = ActiveTimeSourcePart.this.commandService.createCommand("org.eclipse.apogy.core.environment.ui.command.toggleActiveTimeSource", parameters);
                ActiveTimeSourcePart.this.handlerService.executeHandler(command);
            }
        };
    }

    @Override
    protected void dispose() {
        if (this.environment != null) {
            this.environment.eAdapters().remove((Object)this.getActiveTimeSourceAdapter());
        }
        super.dispose();
    }
}

