/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator.ui.composites;

import org.eclipse.apogy.common.emf.ApogyCommonEMFPackage;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorPackage;
import org.eclipse.apogy.core.invocator.Context;
import org.eclipse.apogy.core.invocator.Environment;
import org.eclipse.apogy.core.invocator.ui.wizards.NewContextWizard;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class ContextsListComposite
extends ScrolledComposite {
    private DataBindingContext m_bindingContext;
    private WritableValue<Environment> environmentBinder;
    private Environment environment;
    private final ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private Adapter activeContextAdapter;
    private final Button btnNew;
    private final Button btnDelete;
    private final TableViewer tableViewer;

    public ContextsListComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ContextsListComposite.this.adapterFactory.dispose();
                if (ContextsListComposite.this.environment != null) {
                    ContextsListComposite.this.environment.eAdapters().remove((Object)ContextsListComposite.this.getActiveContextAdapter());
                }
            }
        });
        this.setExpandHorizontal(true);
        this.setExpandVertical(true);
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.tableViewer = new TableViewer(composite, 67584);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(false);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 4));
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ContextsListComposite.this.newSelection(event.getSelection());
            }
        });
        TableColumn tblclmnName = new TableColumn(table, 0);
        tblclmnName.setText("Name");
        this.btnNew = new Button(composite, 0);
        this.btnNew.setText("New");
        this.btnNew.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.btnNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ContextsListComposite.this.getEnvironment().getVariablesList() != null && !ContextsListComposite.this.getEnvironment().getVariablesList().getVariables().isEmpty()) {
                    NewContextWizard newContextWizard = new NewContextWizard(ContextsListComposite.this.getEnvironment().getInvocatorSession());
                    WizardDialog dialog = new WizardDialog(ContextsListComposite.this.getShell(), (IWizard)newContextWizard);
                    dialog.open();
                } else {
                    MessageBox dialog = new MessageBox(ContextsListComposite.this.getShell());
                    dialog.setMessage("Variables list is empty");
                    dialog.open();
                }
            }
        });
        this.btnDelete = new Button(composite, 0);
        this.btnDelete.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.btnDelete.setText("Delete");
        this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ContextsListComposite.this.getEnvironment() != null && ContextsListComposite.this.getEnvironment().getActiveContext() == ContextsListComposite.this.getSelectedContext()) {
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)ContextsListComposite.this.getEnvironment(), (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.ENVIRONMENT__ACTIVE_CONTEXT, null);
                }
                ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)ContextsListComposite.this.getEnvironment().getContextsList(), (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.CONTEXTS_LIST__CONTEXTS, (Object)ContextsListComposite.this.getSelectedContext());
            }
        });
        Label label = new Label(composite, 258);
        label.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        Button btnActivate = new Button(composite, 0);
        btnActivate.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        btnActivate.setText("Activate");
        btnActivate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ContextsListComposite.this.environment.getActiveContext() != ContextsListComposite.this.getSelectedContext()) {
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)ContextsListComposite.this.environment, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.ENVIRONMENT__ACTIVE_CONTEXT, (Object)ContextsListComposite.this.getSelectedContext());
                }
            }
        });
        this.setContent((Control)composite);
        this.setMinSize(composite.computeSize(-1, -1));
        this.m_bindingContext = this.initDataBindingsCustom();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ContextsListComposite.this.m_bindingContext != null) {
                    ContextsListComposite.this.m_bindingContext.dispose();
                }
            }
        });
    }

    private Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        if (this.environment != null) {
            this.environment.eAdapters().remove((Object)this.getActiveContextAdapter());
        }
        this.environmentBinder.setValue((Object)environment);
        this.environment = environment;
        if (!this.tableViewer.isBusy()) {
            this.tableViewer.refresh();
        }
        TableColumn[] tableColumnArray = this.tableViewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.pack();
            ++n2;
        }
        if (this.environment != null) {
            this.environment.eAdapters().add((Object)this.getActiveContextAdapter());
        }
    }

    public Context getSelectedContext() {
        return (Context)this.tableViewer.getStructuredSelection().getFirstElement();
    }

    private DataBindingContext initDataBindingsCustom() {
        this.m_bindingContext = new DataBindingContext();
        if (this.environmentBinder == null) {
            this.environmentBinder = new WritableValue();
        }
        IObservableList environmentContextListContextsObserveValue = EMFProperties.list((FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCoreInvocatorPackage.Literals.ENVIRONMENT__CONTEXTS_LIST, ApogyCoreInvocatorPackage.Literals.CONTEXTS_LIST__CONTEXTS})).observeDetail(this.environmentBinder);
        ObservableListContentProvider contentProvider = new ObservableListContentProvider();
        this.tableViewer.setContentProvider((IContentProvider)contentProvider);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(Properties.observeEach((IObservableSet)contentProvider.getKnownElements(), (IValueProperty[])new IValueProperty[]{EMFProperties.value((EStructuralFeature)ApogyCoreInvocatorPackage.Literals.ENVIRONMENT__ACTIVE_CONTEXT), EMFProperties.value((EStructuralFeature)ApogyCommonEMFPackage.Literals.NAMED__NAME)})){
            private AdapterFactoryLabelProvider adapterLabelProvider;
            private static final int NAME_COLUMN_ID = 0;

            public String getColumnText(Object element, int columnIndex) {
                String str = "<undefined>";
                if (element instanceof Context) {
                    switch (columnIndex) {
                        case 0: {
                            str = this.getAdapterLabelProvider().getText(element);
                        }
                    }
                }
                return str;
            }

            public AdapterFactoryLabelProvider getAdapterLabelProvider() {
                if (this.adapterLabelProvider == null) {
                    this.adapterLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)ContextsListComposite.this.adapterFactory){

                        public String getText(Object object) {
                            Context context = (Context)object;
                            String str = context.getName();
                            if (ContextsListComposite.this.environment != null && ContextsListComposite.this.environment.getActiveContext() == context) {
                                str = String.valueOf(str) + " <Active>";
                            }
                            return str;
                        }
                    };
                }
                return this.adapterLabelProvider;
            }
        });
        this.tableViewer.setInput((Object)environmentContextListContextsObserveValue);
        IViewerObservableValue observeTableViewerSelection = ViewerProperties.singleSelection().observe((Viewer)this.tableViewer);
        ISWTObservableValue observeBtnDeleteEnabled = WidgetProperties.enabled().observe((Widget)this.btnDelete);
        this.m_bindingContext.bindValue((IObservableValue)observeBtnDeleteEnabled, (IObservableValue)observeTableViewerSelection, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(Object.class, Boolean.class){

            public Object convert(Object fromObject) {
                if (fromObject != null) {
                    return true;
                }
                return false;
            }
        }));
        return this.m_bindingContext;
    }

    protected void newSelection(ISelection selection) {
    }

    private Adapter getActiveContextAdapter() {
        if (this.activeContextAdapter == null) {
            this.activeContextAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getFeature() == ApogyCoreInvocatorPackage.Literals.ENVIRONMENT__ACTIVE_CONTEXT) {
                        ContextsListComposite.this.tableViewer.refresh();
                    }
                }
            };
        }
        return this.activeContextAdapter;
    }
}

