/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator.ui.composites;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.apogy.common.emf.ApogyCommonEMFPackage;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.EClassSettings;
import org.eclipse.apogy.common.emf.ui.NamedSetting;
import org.eclipse.apogy.common.emf.ui.wizards.ApogyEObjectWizard;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorPackage;
import org.eclipse.apogy.core.invocator.InitialConditions;
import org.eclipse.apogy.core.invocator.InitialConditionsList;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitialConditionsListComposite
extends Composite {
    private static final Logger Logger = LoggerFactory.getLogger(InitialConditionsListComposite.class);
    private InitialConditionsList initialConditionsList;
    private final WritableValue<InitialConditionsList> initialConditionsBinder = new WritableValue();
    private final TableViewer tableViewer;
    private final Button btnNew;
    private final Button btnDelete;
    private final Button btnCollect;
    private final Button btnApply;
    private DataBindingContext m_currentDataBindings;

    public InitialConditionsListComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.tableViewer = new TableViewer(composite, 67584);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gd_table = new GridData(4, 4, true, true, 1, 5);
        gd_table.widthHint = 300;
        gd_table.minimumWidth = 300;
        table.setLayoutData((Object)gd_table);
        this.tableViewer.setContentProvider((IContentProvider)new CustomContentProvider());
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)event.getSelection();
                InitialConditionsListComposite.this.newInitialConditionsSelected((InitialConditions)iStructuredSelection.getFirstElement());
            }
        });
        TableColumn tblclmnName = new TableColumn(table, 0);
        tblclmnName.setText("Name");
        TableColumn tblclmnDescription = new TableColumn(table, 0);
        tblclmnDescription.setText("Description");
        this.btnNew = new Button(composite, 0);
        this.btnNew.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.btnNew.setText("New");
        this.btnNew.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 13) {
                    NamedSetting namedSettings = ApogyCommonEMFUIFactory.eINSTANCE.createNamedSetting();
                    namedSettings.setParent((EObject)InitialConditionsListComposite.this.getInitialConditionsList());
                    namedSettings.setContainingFeature((ETypedElement)ApogyCoreInvocatorPackage.Literals.INITIAL_CONDITIONS_LIST__INITIAL_CONDITIONS);
                    ApogyEObjectWizard wizard = new ApogyEObjectWizard(ApogyCoreInvocatorPackage.Literals.INITIAL_CONDITIONS_LIST__INITIAL_CONDITIONS, (EObject)InitialConditionsListComposite.this.getInitialConditionsList(), (EClassSettings)namedSettings, ApogyCoreInvocatorPackage.Literals.INITIAL_CONDITIONS);
                    WizardDialog dialog = new WizardDialog(InitialConditionsListComposite.this.getShell(), (IWizard)wizard);
                    if (dialog.open() == 0 && !InitialConditionsListComposite.this.tableViewer.isBusy()) {
                        InitialConditionsListComposite.this.tableViewer.refresh();
                        InitialConditionsListComposite.this.packColumns();
                        InitialConditionsListComposite.this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)wizard.getCreatedEObject()), true);
                    }
                }
            }
        });
        this.btnDelete = new Button(composite, 0);
        this.btnDelete.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.btnDelete.setText("Delete");
        this.btnDelete.setEnabled(false);
        this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String initialConditionsToDeleteMessage = "";
                Iterator<InitialConditions> initialConditionsIterator = InitialConditionsListComposite.this.getSelectedInitialConditionsList().iterator();
                while (initialConditionsIterator.hasNext()) {
                    InitialConditions initialConditions = initialConditionsIterator.next();
                    initialConditionsToDeleteMessage = String.valueOf(initialConditionsToDeleteMessage) + initialConditions.getName();
                    if (!initialConditionsIterator.hasNext()) continue;
                    initialConditionsToDeleteMessage = String.valueOf(initialConditionsToDeleteMessage) + ", ";
                }
                MessageDialog dialog = new MessageDialog(null, "Delete the selected Initial Conditions", null, "Are you sure to delete these Initial Conditions: " + initialConditionsToDeleteMessage, 3, new String[]{"Yes", "No"}, 1);
                int result = dialog.open();
                if (result == 0) {
                    for (InitialConditions initialConditions : InitialConditionsListComposite.this.getSelectedInitialConditionsList()) {
                        try {
                            ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)InitialConditionsListComposite.this.getInitialConditionsList(), (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.INITIAL_CONDITIONS_LIST__INITIAL_CONDITIONS, (Object)initialConditions);
                        }
                        catch (Exception e) {
                            Logger.error("Unable to delete the Initial Conditions <" + initialConditions.getName() + ">", (Throwable)e);
                        }
                    }
                }
                InitialConditionsListComposite.this.refreshViewer();
            }
        });
        new Label(composite, 0);
        this.btnCollect = new Button(composite, 0);
        this.btnCollect.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.btnCollect.setText("Collect");
        this.btnCollect.setToolTipText("Collects the current states of the Variables and saves them in the selected Initial Conditions.");
        this.btnCollect.setEnabled(false);
        this.btnCollect.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                InitialConditions selectedInitialConditions = InitialConditionsListComposite.this.getSelectedInitialConditionsList().get(0);
                try {
                    ApogyCoreInvocatorFacade.INSTANCE.collectInitialConditions(ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession().getEnvironment(), selectedInitialConditions);
                }
                catch (Throwable t) {
                    Logger.error(t.getMessage(), t);
                }
                InitialConditionsListComposite.this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)selectedInitialConditions), true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnApply = new Button(composite, 0);
        this.btnApply.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.btnApply.setText("Apply");
        this.btnApply.setToolTipText("Applies the selected Initial Conditions to the Variables.");
        this.btnApply.setEnabled(false);
        this.btnApply.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                final InitialConditions selectedInitialConditions = InitialConditionsListComposite.this.getSelectedInitialConditionsList().get(0);
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            ApogyCoreInvocatorFacade.INSTANCE.applyInitialConditions(ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession().getEnvironment(), selectedInitialConditions, monitor);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                };
                try {
                    new ProgressMonitorDialog(InitialConditionsListComposite.this.getShell()).run(true, true, runnable);
                }
                catch (Throwable t) {
                    Logger.error(t.getMessage(), t);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (InitialConditionsListComposite.this.m_currentDataBindings != null) {
                    InitialConditionsListComposite.this.m_currentDataBindings.dispose();
                }
            }
        });
    }

    public void setSelectedInitialConditions(InitialConditions initialConditions) {
        if (initialConditions != null) {
            this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)initialConditions), true);
        } else {
            this.tableViewer.setSelection(null, true);
        }
    }

    public List<InitialConditions> getSelectedInitialConditionsList() {
        return ((IStructuredSelection)this.tableViewer.getSelection()).toList();
    }

    public InitialConditionsList getInitialConditionsList() {
        return this.initialConditionsList;
    }

    public void setInitialConditionsList(InitialConditionsList initialConditionsList) {
        if (this.m_currentDataBindings != null) {
            this.m_currentDataBindings.dispose();
        }
        this.initialConditionsList = initialConditionsList;
        if (initialConditionsList != null) {
            this.m_currentDataBindings = this.initDataBindingsCustom();
        } else {
            this.tableViewer.setInput(null);
        }
        this.refreshViewer();
    }

    protected void newInitialConditionsSelected(InitialConditions initialConditions) {
    }

    protected DataBindingContext initDataBindingsCustom() {
        DataBindingContext bindingContext = new DataBindingContext();
        this.initialConditionsBinder.setValue((Object)this.getInitialConditionsList());
        IObservableList environmentContextListContextsObserveValue = EMFProperties.list((FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCoreInvocatorPackage.Literals.INITIAL_CONDITIONS_LIST__INITIAL_CONDITIONS})).observeDetail(this.initialConditionsBinder);
        ObservableListContentProvider contentProvider = new ObservableListContentProvider();
        this.tableViewer.setContentProvider((IContentProvider)contentProvider);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(Properties.observeEach((IObservableSet)contentProvider.getKnownElements(), (IValueProperty[])new IValueProperty[]{EMFProperties.value((EStructuralFeature)ApogyCommonEMFPackage.Literals.DESCRIBED__DESCRIPTION), EMFProperties.value((EStructuralFeature)ApogyCommonEMFPackage.Literals.NAMED__NAME)})){
            private static final int NAME_COLUMN_ID = 0;
            private static final int DESCRIPTION_COLUMN_ID = 1;

            public String getColumnText(Object element, int columnIndex) {
                String str = "<undefined>";
                if (element instanceof InitialConditions) {
                    InitialConditions initialConditions = (InitialConditions)element;
                    switch (columnIndex) {
                        case 0: {
                            str = initialConditions.getName();
                            break;
                        }
                        case 1: {
                            str = initialConditions.getDescription();
                        }
                    }
                }
                return str;
            }
        });
        this.tableViewer.setInput((Object)environmentContextListContextsObserveValue);
        IViewerObservableValue observeSingleSelectionTableViewer = ViewerProperties.singleSelection().observe((Viewer)this.tableViewer);
        ISWTObservableValue observeEnabledBtnDeleteObserveWidget = WidgetProperties.enabled().observe((Widget)this.btnDelete);
        bindingContext.bindValue((IObservableValue)observeEnabledBtnDeleteObserveWidget, (IObservableValue)observeSingleSelectionTableViewer, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(Object.class, Boolean.class){

            public Object convert(Object fromObject) {
                if (fromObject != null) {
                    return true;
                }
                return false;
            }
        }));
        ISWTObservableValue observeEnabledBtnCollectObserveWidget = WidgetProperties.enabled().observe((Widget)this.btnCollect);
        bindingContext.bindValue((IObservableValue)observeEnabledBtnCollectObserveWidget, (IObservableValue)observeSingleSelectionTableViewer, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(Object.class, Boolean.class){

            public Object convert(Object fromObject) {
                if (fromObject != null) {
                    return true;
                }
                return false;
            }
        }));
        ISWTObservableValue observeEnabledBtnApplyObserveWidget = WidgetProperties.enabled().observe((Widget)this.btnApply);
        bindingContext.bindValue((IObservableValue)observeEnabledBtnApplyObserveWidget, (IObservableValue)observeSingleSelectionTableViewer, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(Object.class, Boolean.class){

            public Object convert(Object fromObject) {
                if (fromObject != null) {
                    return true;
                }
                return false;
            }
        }));
        return bindingContext;
    }

    private void packColumns() {
        if (!this.tableViewer.isBusy()) {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TableColumn[] tableColumnArray = InitialConditionsListComposite.this.tableViewer.getTable().getColumns();
                    int n = tableColumnArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableColumn column = tableColumnArray[n2];
                        column.pack();
                        ++n2;
                    }
                }
            });
        }
    }

    protected void refreshViewer() {
        if (!this.tableViewer.isBusy()) {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    InitialConditionsListComposite.this.tableViewer.refresh();
                    InitialConditionsListComposite.this.packColumns();
                }
            });
        }
    }

    private class CustomContentProvider
    implements ITreeContentProvider {
        private CustomContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof InitialConditionsList) {
                InitialConditionsList list = (InitialConditionsList)inputElement;
                return list.getInitialConditions().toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof InitialConditionsList) {
                InitialConditionsList list = (InitialConditionsList)parentElement;
                return list.getInitialConditions().toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof InitialConditionsList) {
                InitialConditionsList list = (InitialConditionsList)element;
                return !list.getInitialConditions().isEmpty();
            }
            return false;
        }
    }
}

